/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.container.impl;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.container.BasicContainer;
import com.hrznstudio.titanium.container.IDisableableContainer;
import com.hrznstudio.titanium.container.impl.DisableableSlot;
import java.awt.Point;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public class BasicInventoryContainer
extends BasicContainer
implements IDisableableContainer {
    private boolean isDisabled = false;
    private Inventory inventory;
    private boolean hasPlayerInventory;

    public BasicInventoryContainer(int id, Inventory inventory, FriendlyByteBuf buffer) {
        super(id, inventory, buffer);
    }

    public BasicInventoryContainer(MenuType type, Inventory inventory, int id) {
        super(type, id);
        this.inventory = inventory;
        this.addPlayerChestInventory();
    }

    public BasicInventoryContainer(MenuType type, Inventory inventory, int id, IAssetProvider assetProvider) {
        super(type, id, assetProvider);
        this.inventory = inventory;
    }

    public void initInventory() {
        this.addExtraSlots();
        this.addPlayerChestInventory();
        this.addHotbarSlots();
    }

    public void addPlayerChestInventory() {
        Point invPos = IAssetProvider.getAsset(this.getAssetProvider(), AssetTypes.BACKGROUND).getInventoryPosition();
        if (!this.hasPlayerInventory) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.m_38897_(new DisableableSlot((Container)this.inventory, j + i * 9 + 9, invPos.x + j * 18, invPos.y + i * 18, this));
                }
            }
            this.hasPlayerInventory = true;
        }
    }

    public void addHotbarSlots() {
        Point hotbarPos = IAssetProvider.getAsset(this.getAssetProvider(), AssetTypes.BACKGROUND).getHotbarPosition();
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)this.getPlayerInventory(), k, hotbarPos.x + k * 18, hotbarPos.y));
        }
    }

    public Inventory getPlayerInventory() {
        return this.inventory;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.isDisabled = disabled;
    }
}

