/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.net;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.util.NetworkUtils;

public abstract class ReloadListenerPacket<T extends ReloadListenerPacket<T>>
extends NetworkUtils.MessageProvider<T> {
    final String path;

    public ReloadListenerPacket(String path) {
        this.path = path;
    }

    public static class End
    extends ReloadListenerPacket<End> {
        public End(String path) {
            super(path);
        }

        @Override
        public void write(End msg, PacketBuffer buf) {
            buf.func_211400_a(msg.path, 50);
        }

        @Override
        public End read(PacketBuffer buf) {
            return new End(buf.func_150789_c(50));
        }

        @Override
        public void handle(End msg, Supplier<NetworkEvent.Context> ctx) {
            NetworkUtils.handlePacket(() -> () -> PlaceboJsonReloadListener.endSync(msg.path), ctx.get());
        }
    }

    public static class Content<V extends PlaceboJsonReloadListener.TypeKeyed<V>>
    extends ReloadListenerPacket<Content<V>> {
        final ResourceLocation key;
        final V item;

        public Content(String path, ResourceLocation key, V item) {
            super(path);
            this.key = key;
            this.item = item;
        }

        @Override
        public void write(Content<V> msg, PacketBuffer buf) {
            buf.func_211400_a(msg.path, 50);
            buf.func_192572_a(msg.key);
            PlaceboJsonReloadListener.writeItem(msg.path, msg.item, buf);
        }

        @Override
        public Content<V> read(PacketBuffer buf) {
            String path = buf.func_150789_c(50);
            ResourceLocation key = buf.func_192575_l();
            Object item = PlaceboJsonReloadListener.readItem(path, key, buf);
            return new Content(path, key, item);
        }

        @Override
        public void handle(Content<V> msg, Supplier<NetworkEvent.Context> ctx) {
            NetworkUtils.handlePacket(() -> () -> PlaceboJsonReloadListener.acceptItem(msg.path, msg.key, msg.item), ctx.get());
        }
    }

    public static class Start
    extends ReloadListenerPacket<Start> {
        public Start(String path) {
            super(path);
        }

        @Override
        public void write(Start msg, PacketBuffer buf) {
            buf.func_211400_a(msg.path, 50);
        }

        @Override
        public Start read(PacketBuffer buf) {
            return new Start(buf.func_150789_c(50));
        }

        @Override
        public void handle(Start msg, Supplier<NetworkEvent.Context> ctx) {
            NetworkUtils.handlePacket(() -> () -> PlaceboJsonReloadListener.initSync(msg.path), ctx.get());
        }
    }
}

