/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.stats.IStatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.gateways.GatewayObjects;
import shadows.gateways.client.GatewayParticleData;
import shadows.gateways.client.GatewayTickableSound;
import shadows.gateways.command.GatewayCommand;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.gate.GatewayManager;
import shadows.gateways.gate.Reward;
import shadows.gateways.gate.WaveEntity;
import shadows.gateways.item.GatePearlItem;
import shadows.gateways.net.ParticleMessage;
import shadows.gateways.recipe.GatewayRecipeSerializer;
import shadows.placebo.util.NetworkUtils;

@Mod(value="gateways")
public class Gateways {
    public static final String MODID = "gateways";
    public static final Logger LOGGER = LogManager.getLogger((String)"Gateways to Eternity");
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("gateways", "channel")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
    public static final ItemGroup TAB = new ItemGroup("gateways"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)GatewayObjects.GATE_PEARL);
        }
    };

    public Gateways() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        NetworkUtils.registerMessage((SimpleChannel)CHANNEL, (int)0, (NetworkUtils.MessageProvider)new ParticleMessage());
        MinecraftForge.EVENT_BUS.addListener(this::commands);
        MinecraftForge.EVENT_BUS.addListener(this::starting);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        Reward.initSerializers();
        WaveEntity.initSerializers();
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> e) {
        e.getRegistry().register(EntityType.Builder.func_220322_a(GatewayEntity::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(5).setUpdateInterval(20).func_220321_a(2.0f, 3.0f).setCustomClientFactory((se, w) -> {
            GatewayEntity ent = new GatewayEntity(GatewayObjects.GATEWAY, (World)w);
            GatewayTickableSound.startGatewaySound(ent);
            return ent;
        }).func_206830_a("gateway").setRegistryName("gateway"));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> e) {
        e.getRegistry().register(new GatePearlItem(new Item.Properties().func_200917_a(1).func_208103_a(Rarity.UNCOMMON).func_200916_a(TAB)).setRegistryName("gate_pearl"));
        Gateways.registerStat(GatewayObjects.Stats.STAT_GATES_DEFEATED, IStatFormatter.field_223218_b_);
    }

    @SubscribeEvent
    public void registerSerializers(RegistryEvent.Register<IRecipeSerializer<?>> e) {
        e.getRegistry().register(GatewayRecipeSerializer.INSTANCE.setRegistryName("gate_recipe"));
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{(SoundEvent)new SoundEvent(new ResourceLocation(MODID, "gate_warp")).setRegistryName("gate_warp"), (SoundEvent)new SoundEvent(new ResourceLocation(MODID, "gate_ambient")).setRegistryName("gate_ambient"), (SoundEvent)new SoundEvent(new ResourceLocation(MODID, "gate_start")).setRegistryName("gate_start"), (SoundEvent)new SoundEvent(new ResourceLocation(MODID, "gate_end")).setRegistryName("gate_end")});
    }

    @SubscribeEvent
    public void registerParticles(RegistryEvent.Register<ParticleType<?>> e) {
        e.getRegistry().register(new ParticleType<GatewayParticleData>(false, GatewayParticleData.DESERIALIZER){

            public Codec<GatewayParticleData> func_230522_e_() {
                return GatewayParticleData.CODEC;
            }
        }.setRegistryName("glow"));
    }

    public void commands(RegisterCommandsEvent e) {
        GatewayCommand.register((CommandDispatcher<CommandSource>)e.getDispatcher());
    }

    public void starting(AddReloadListenerEvent e) {
        e.addListener((IFutureReloadListener)GatewayManager.INSTANCE);
    }

    private static void registerStat(ResourceLocation id, IStatFormatter pFormatter) {
        Registry.func_218322_a((Registry)Registry.field_212623_l, (ResourceLocation)id, (Object)id);
        Stats.field_199092_j.func_199077_a((Object)id, pFormatter);
    }
}

