/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.client;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.registry.Registry;
import shadows.gateways.GatewayObjects;

public class GatewayParticleData
implements IParticleData {
    public final float red;
    public final float green;
    public final float blue;
    public static final Codec<GatewayParticleData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("r").forGetter(data -> Float.valueOf(data.red)), (App)Codec.FLOAT.fieldOf("g").forGetter(data -> Float.valueOf(data.green)), (App)Codec.FLOAT.fieldOf("b").forGetter(data -> Float.valueOf(data.blue))).apply((Applicative)builder, GatewayParticleData::new));
    public static final IParticleData.IDeserializer<GatewayParticleData> DESERIALIZER = new IParticleData.IDeserializer<GatewayParticleData>(){

        public GatewayParticleData fromCommand(ParticleType<GatewayParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float f = (float)reader.readDouble();
            reader.expect(' ');
            float f1 = (float)reader.readDouble();
            reader.expect(' ');
            float f2 = (float)reader.readDouble();
            return new GatewayParticleData(f, f1, f2);
        }

        public GatewayParticleData fromNetwork(ParticleType<GatewayParticleData> type, PacketBuffer buf) {
            return new GatewayParticleData(buf.readFloat(), buf.readFloat(), buf.readFloat());
        }
    };

    public GatewayParticleData(float r, float g, float b) {
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public GatewayParticleData(int r, int g, int b) {
        this((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public ParticleType<GatewayParticleData> func_197554_b() {
        return GatewayObjects.GLOW;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", Registry.field_212632_u.func_177774_c(this.func_197554_b()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }
}

