/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import shadows.gateways.entity.GatewayEntity;

public class GatewayRenderer
extends EntityRenderer<GatewayEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("gateways", "textures/entity/gateway.png");

    public GatewayRenderer(EntityRendererManager mgr) {
        super(mgr);
    }

    public ResourceLocation getTextureLocation(GatewayEntity entity) {
        return TEXTURE;
    }

    public void render(GatewayEntity gate, float yaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buf, int packedLight) {
        float time;
        float baseScale;
        matrix.func_227860_a_();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Vector3d playerV = player.func_174824_e(partialTicks);
        Vector3d portal = gate.func_213303_ch();
        float scale = baseScale = gate.getGateway().getSize().getScale();
        double yOffset = gate.func_213302_cg() / 2.0f;
        matrix.func_227861_a_(0.0, yOffset, 0.0);
        matrix.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 90.0f, true));
        matrix.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 180.0f - (float)GatewayRenderer.angleOf(portal, playerV), true));
        matrix.func_227862_a_(2.0f, 1.0f, 1.0f);
        if (!gate.isWaveActive() && !gate.isLastWave()) {
            float maxTime;
            time = (float)gate.getTicksActive() + partialTicks;
            if (time <= (maxTime = (float)gate.getCurrentWave().setupTime())) {
                scale = MathHelper.func_219799_g((float)(time / maxTime), (float)gate.getClientScale(), (float)baseScale);
            }
        } else {
            int magic;
            time = (float)gate.getTicksActive() + partialTicks;
            if (time < (float)(magic = 10)) {
                matrix.func_227862_a_(MathHelper.func_219799_g((float)(time / (float)magic), (float)1.0f, (float)1.33f), 1.0f, 1.0f);
                matrix.func_227862_a_(1.0f, MathHelper.func_219799_g((float)(time / (float)magic), (float)1.0f, (float)1.33f), 1.0f);
            } else if (time < (float)(2 * magic)) {
                matrix.func_227862_a_(MathHelper.func_219799_g((float)((time -= (float)magic) / (float)magic), (float)1.33f, (float)1.0f), 1.0f, 1.0f);
                matrix.func_227862_a_(1.0f, MathHelper.func_219799_g((float)(time / (float)magic), (float)1.33f, (float)1.0f), 1.0f);
            } else {
                float progress = ((float)gate.getTicksActive() + partialTicks - 20.0f) % 80.0f / 80.0f;
                gate.setClientScale(scale += (float)Math.sin(Math.PI * 2 * (double)progress) * baseScale / 6.0f);
            }
        }
        matrix.func_227862_a_(scale, scale, 1.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTextureLocation(gate));
        IVertexBuilder builder = buf.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getTextureLocation(gate)));
        int color = gate.getGateway().getColor().func_240742_a_();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float frameHeight = 0.11111111f;
        int frame = gate.field_70173_aa % 9;
        builder.func_227888_a_(matrix.func_227866_c_().func_227870_a_(), -1.0f, -1.0f, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(1.0f, 1.0f - (float)frame * frameHeight).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrix.func_227866_c_().func_227872_b_(), 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix.func_227866_c_().func_227870_a_(), -1.0f, 1.0f, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(1.0f, 0.8888889f - (float)frame * frameHeight).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrix.func_227866_c_().func_227872_b_(), 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix.func_227866_c_().func_227870_a_(), 1.0f, 1.0f, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(0.0f, 0.8888889f - (float)frame * frameHeight).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrix.func_227866_c_().func_227872_b_(), 0.0f, 1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix.func_227866_c_().func_227870_a_(), 1.0f, -1.0f, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(0.0f, 1.0f - (float)frame * frameHeight).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrix.func_227866_c_().func_227872_b_(), 0.0f, 1.0f, 0.0f).func_181675_d();
        matrix.func_227865_b_();
    }

    public static double angleOf(Vector3d p1, Vector3d p2) {
        double deltaY = p2.field_72449_c - p1.field_72449_c;
        double deltaX = p2.field_72450_a - p1.field_72450_a;
        double result = Math.toDegrees(Math.atan2(deltaY, deltaX));
        return result < 0.0 ? 360.0 + result : result;
    }
}

