/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ClientBossInfo;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import shadows.gateways.GatewayObjects;
import shadows.gateways.client.GatewayParticle;
import shadows.gateways.client.GatewayRenderer;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.gate.Gateway;
import shadows.gateways.gate.Reward;
import shadows.gateways.gate.WaveEntity;
import shadows.gateways.item.GatePearlItem;
import shadows.gateways.misc.RandomAttributeModifier;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT}, modid="gateways")
public class GatewaysClient {
    public static final ResourceLocation BARS = new ResourceLocation("textures/gui/bars.png");

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent e) {
        e.enqueueWork(() -> {
            Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tint) -> {
                Gateway gate = GatePearlItem.getGate(stack);
                if (gate != null) {
                    return gate.getColor().func_240742_a_();
                }
                return 0xAAAAFF;
            }, new IItemProvider[]{GatewayObjects.GATE_PEARL});
            ItemModelsProperties.func_239418_a_((Item)GatewayObjects.GATE_PEARL, (ResourceLocation)new ResourceLocation("gateways", "size"), (stack, level, entity) -> {
                Gateway gate = GatePearlItem.getGate(stack);
                if (gate == null) {
                    return 2.0f;
                }
                return gate.getSize().ordinal();
            });
            Minecraft.func_71410_x().func_175598_ae().func_229087_a_(GatewayObjects.GATEWAY, (EntityRenderer)new GatewayRenderer(Minecraft.func_71410_x().func_175598_ae()));
        });
        MinecraftForge.EVENT_BUS.addListener(GatewaysClient::bossRenderPre);
        MinecraftForge.EVENT_BUS.addListener(GatewaysClient::tooltip);
    }

    @SubscribeEvent
    public static void factories(ParticleFactoryRegisterEvent e) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a(GatewayObjects.GLOW, GatewayParticle.Factory::new);
    }

    @SubscribeEvent
    public static void stitch(TextureStitchEvent.Pre e) {
        if (e.getMap().func_229223_g_().equals((Object)AtlasTexture.field_215262_g)) {
            e.addSprite(new ResourceLocation("gateways", "particle/glow"));
        }
    }

    public static void tooltip(ItemTooltipEvent e) {
        if (e.getItemStack().func_77973_b() == GatewayObjects.GATE_PEARL) {
            Gateway gate = GatePearlItem.getGate(e.getItemStack());
            List tooltips = e.getToolTip();
            if (gate == null) {
                tooltips.add(new StringTextComponent("Errored Gate Pearl, file a bug report detailing how you obtained this."));
                return;
            }
            IFormattableTextComponent comp = new TranslationTextComponent("tooltip.gateways.max_waves", new Object[]{gate.getNumWaves()}).func_240699_a_(TextFormatting.GRAY);
            tooltips.add(comp);
            if (Screen.func_231173_s_()) {
                int wave = 0;
                if (e.getPlayer() != null) {
                    wave = e.getPlayer().field_70173_aa / 50 % gate.getNumWaves();
                }
                comp = new TranslationTextComponent("tooltip.gateways.wave", new Object[]{wave + 1}).func_240701_a_(new TextFormatting[]{TextFormatting.GREEN, TextFormatting.UNDERLINE});
                tooltips.add(comp);
                tooltips.add(ITextComponent.func_244388_a(null));
                comp = new TranslationTextComponent("tooltip.gateways.entities").func_240699_a_(TextFormatting.BLUE);
                tooltips.add(comp);
                HashMap<String, Integer> counts = new HashMap<String, Integer>();
                for (WaveEntity waveEntity : gate.getWave(wave).entities()) {
                    counts.put(waveEntity.getDescription().getString(), counts.getOrDefault(waveEntity.getDescription().getString(), 0) + 1);
                }
                for (Map.Entry entry : counts.entrySet()) {
                    comp = new TranslationTextComponent("tooltip.gateways.list1", new Object[]{entry.getValue(), new TranslationTextComponent((String)entry.getKey())}).func_240699_a_(TextFormatting.BLUE);
                    tooltips.add(comp);
                }
                if (!gate.getWave(wave).modifiers().isEmpty()) {
                    comp = new TranslationTextComponent("tooltip.gateways.modifiers").func_240699_a_(TextFormatting.RED);
                    tooltips.add(comp);
                    for (RandomAttributeModifier randomAttributeModifier : gate.getWave(wave).modifiers()) {
                        comp = GatewaysClient.toComponent(randomAttributeModifier.getAttribute(), randomAttributeModifier.genModifier(e.getPlayer().func_70681_au()));
                        comp = new TranslationTextComponent("tooltip.gateways.list2", new Object[]{comp.getString()}).func_240699_a_(TextFormatting.RED);
                        tooltips.add(comp);
                    }
                }
                comp = new TranslationTextComponent("tooltip.gateways.rewards").func_240699_a_(TextFormatting.GOLD);
                tooltips.add(comp);
                for (Reward reward : gate.getWave(wave).rewards()) {
                    reward.appendHoverText(c -> tooltips.add(new TranslationTextComponent("tooltip.gateways.list2", new Object[]{c}).func_240699_a_(TextFormatting.GOLD)));
                }
            } else {
                comp = new TranslationTextComponent("tooltip.gateways.shift").func_240699_a_(TextFormatting.GRAY);
                tooltips.add(comp);
            }
            if (Screen.func_231172_r_()) {
                comp = new TranslationTextComponent("tooltip.gateways.completion").func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.UNDERLINE});
                tooltips.add(comp);
                tooltips.add(ITextComponent.func_244388_a(null));
                comp = new TranslationTextComponent("tooltip.gateways.experience", new Object[]{gate.getCompletionXp()}).func_240699_a_(TextFormatting.YELLOW);
                tooltips.add(comp);
                for (Reward r : gate.getRewards()) {
                    r.appendHoverText(c -> tooltips.add(new TranslationTextComponent("tooltip.gateways.list3", new Object[]{c}).func_240699_a_(TextFormatting.YELLOW)));
                }
            } else {
                comp = new TranslationTextComponent("tooltip.gateways.ctrl").func_240699_a_(TextFormatting.GRAY);
                tooltips.add(comp);
            }
        }
    }

    public static void bossRenderPre(RenderGameOverlayEvent.BossInfo event) {
        ClientBossInfo boss = event.getBossInfo();
        String name = boss.func_186744_e().getString();
        if (name.startsWith("GATEWAY_ID")) {
            ClientWorld level = Minecraft.func_71410_x().field_71441_e;
            event.setCanceled(true);
            Entity entity = level.func_73045_a(Integer.valueOf(name.substring(10)).intValue());
            if (entity instanceof GatewayEntity) {
                int i;
                GatewayEntity gate = (GatewayEntity)entity;
                int color = gate.getGateway().getColor().func_240742_a_();
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(BARS);
                RenderSystem.color4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
                MatrixStack stack = event.getMatrixStack();
                int wave = gate.getWave() + 1;
                int maxWave = gate.getGateway().getNumWaves();
                int enemies = gate.getActiveEnemies();
                int maxEnemies = gate.getCurrentWave().entities().size();
                int x = event.getX();
                int y = event.getY();
                int y2 = y + event.getIncrement();
                Screen.func_238464_a_((MatrixStack)stack, (int)x, (int)y, (int)200, (float)0.0f, (float)60.0f, (int)182, (int)5, (int)256, (int)256);
                Screen.func_238464_a_((MatrixStack)stack, (int)x, (int)y2, (int)200, (float)0.0f, (float)60.0f, (int)182, (int)5, (int)256, (int)256);
                float waveProgress = 1.0f / (float)maxWave;
                float progress = waveProgress * (float)(maxWave - wave + 1);
                if (gate.isWaveActive()) {
                    progress -= waveProgress * ((float)(maxEnemies - enemies) / (float)maxEnemies);
                }
                if ((i = (int)(progress * 183.0f)) > 0) {
                    Screen.func_238464_a_((MatrixStack)stack, (int)x, (int)y, (int)200, (float)0.0f, (float)65.0f, (int)i, (int)5, (int)256, (int)256);
                }
                float maxTime = gate.getCurrentWave().maxWaveTime();
                if (gate.isWaveActive()) {
                    i = (int)((maxTime - (float)gate.getTicksActive()) / maxTime * 183.0f);
                    if (i > 0) {
                        Screen.func_238464_a_((MatrixStack)stack, (int)x, (int)y2, (int)200, (float)0.0f, (float)65.0f, (int)i, (int)5, (int)256, (int)256);
                    }
                } else {
                    maxTime = gate.getCurrentWave().setupTime();
                    i = (int)((float)gate.getTicksActive() / maxTime * 183.0f);
                    if (i > 0) {
                        Screen.func_238464_a_((MatrixStack)stack, (int)x, (int)y2, (int)200, (float)0.0f, (float)65.0f, (int)i, (int)5, (int)256, (int)256);
                    }
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                int width = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
                IFormattableTextComponent component = new StringTextComponent(gate.func_200201_e().getString()).func_240699_a_(TextFormatting.GOLD);
                int strWidth = font.func_238414_a_((ITextProperties)component);
                int textX = width / 2 - strWidth / 2;
                int textY = y - 9;
                font.func_243246_a(stack, (ITextComponent)component, (float)textX, (float)textY, 0xFFFFFF);
                event.setIncrement(event.getIncrement() * 2);
                textY = y2 - 9;
                int time = (int)maxTime - gate.getTicksActive();
                String str = I18n.func_135052_a((String)"boss.gateways.wave", (Object[])new Object[]{wave, maxWave, StringUtils.func_76337_a((int)time), enemies});
                if (!gate.isWaveActive()) {
                    str = gate.isLastWave() ? I18n.func_135052_a((String)"boss.gateways.done", (Object[])new Object[0]) : I18n.func_135052_a((String)"boss.gateways.starting", (Object[])new Object[]{wave, StringUtils.func_76337_a((int)time)});
                }
                component = new StringTextComponent(str).func_240699_a_(TextFormatting.GREEN);
                strWidth = font.func_238414_a_((ITextProperties)component);
                textX = width / 2 - strWidth / 2;
                font.func_243246_a(stack, (ITextComponent)component, (float)textX, (float)textY, 0xFFFFFF);
            }
        }
    }

    public static ITextComponent toComponent(Attribute attr, AttributeModifier modif) {
        double amt = modif.func_111164_d();
        if (modif.func_220375_c() == AttributeModifier.Operation.ADDITION) {
            if (attr == Attributes.field_233820_c_) {
                amt *= 10.0;
            }
        } else {
            amt *= 100.0;
        }
        int code = modif.func_220375_c().ordinal();
        if (amt > 0.0) {
            return new TranslationTextComponent("attribute.modifier.plus." + code, new Object[]{ItemStack.field_111284_a.format(amt), new TranslationTextComponent(attr.func_233754_c_())}).func_240699_a_(TextFormatting.BLUE);
        }
        return new TranslationTextComponent("attribute.modifier.take." + code, new Object[]{ItemStack.field_111284_a.format(amt *= -1.0), new TranslationTextComponent(attr.func_233754_c_())}).func_240699_a_(TextFormatting.RED);
    }
}

