/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.entity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import shadows.gateways.GatewayObjects;
import shadows.gateways.Gateways;
import shadows.gateways.client.ParticleHandler;
import shadows.gateways.gate.Gateway;
import shadows.gateways.gate.GatewayManager;
import shadows.gateways.gate.Wave;
import shadows.gateways.net.ParticleMessage;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.util.NetworkUtils;

public class GatewayEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public static final DataParameter<Boolean> WAVE_ACTIVE = EntityDataManager.func_187226_a(GatewayEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> TICKS_ACTIVE = EntityDataManager.func_187226_a(GatewayEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> WAVE = EntityDataManager.func_187226_a(GatewayEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> ENEMIES = EntityDataManager.func_187226_a(GatewayEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected Gateway gate;
    protected ServerBossInfo bossEvent;
    protected final Set<LivingEntity> currentWaveEntities = new HashSet<LivingEntity>();
    protected final Set<UUID> unresolvedWaveEntities = new HashSet<UUID>();
    protected UUID summonerId;
    protected float clientScale = 0.0f;
    protected Queue<ItemStack> undroppedItems = new ArrayDeque<ItemStack>();

    public GatewayEntity(World level, PlayerEntity placer, Gateway gate) {
        super(GatewayObjects.GATEWAY, level);
        this.summonerId = placer.func_110124_au();
        this.gate = gate;
        this.func_200203_b((ITextComponent)new TranslationTextComponent(gate.getId().toString().replace(':', '.')).func_240703_c_(Style.field_240709_b_.func_240718_a_(gate.getColor())));
        this.bossEvent = this.createBossEvent();
        this.func_213323_x_();
    }

    public GatewayEntity(EntityType<?> type, World level) {
        super(type, level);
    }

    public EntitySize func_213305_a(Pose pPose) {
        return this.gate.getSize().dims;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (!this.unresolvedWaveEntities.isEmpty()) {
                for (UUID id : this.unresolvedWaveEntities) {
                    Entity e = ((ServerWorld)this.field_70170_p).func_217461_a(id);
                    if (!(e instanceof LivingEntity)) continue;
                    this.currentWaveEntities.add((LivingEntity)e);
                }
                this.unresolvedWaveEntities.clear();
            }
            if (this.isWaveActive()) {
                int maxWaveTime = this.getCurrentWave().maxWaveTime();
                if (this.getTicksActive() > maxWaveTime) {
                    this.onFailure(this.currentWaveEntities, (ITextComponent)new TranslationTextComponent("error.gateways.wave_elapsed").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.UNDERLINE}));
                    return;
                }
                this.field_70180_af.func_187227_b(TICKS_ACTIVE, (Object)(this.getTicksActive() + 1));
            }
            boolean active = this.isWaveActive();
            List enemies = this.currentWaveEntities.stream().filter(Entity::func_70089_S).collect(Collectors.toList());
            for (LivingEntity entity : enemies) {
                if (entity.func_70068_e((Entity)this) > this.gate.getLeashRangeSq()) {
                    this.onFailure(this.currentWaveEntities, (ITextComponent)new TranslationTextComponent("error.gateways.too_far").func_240699_a_(TextFormatting.RED));
                    return;
                }
                if (entity.field_70173_aa % 20 != 0) continue;
                this.spawnParticle(this.gate.getColor(), entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), 0);
            }
            this.field_70180_af.func_187227_b(ENEMIES, (Object)enemies.size());
            if (active && enemies.size() == 0) {
                this.onWaveEnd(this.getCurrentWave());
                this.currentWaveEntities.clear();
                this.field_70180_af.func_187227_b(WAVE_ACTIVE, (Object)false);
                this.field_70180_af.func_187227_b(TICKS_ACTIVE, (Object)0);
                this.field_70180_af.func_187227_b(WAVE, (Object)Math.min(this.getWave() + 1, this.gate.getNumWaves()));
            } else if (!active && !this.isLastWave()) {
                if (this.getTicksActive() > this.getCurrentWave().setupTime()) {
                    this.spawnWave();
                    return;
                }
                this.field_70180_af.func_187227_b(TICKS_ACTIVE, (Object)(this.getTicksActive() + 1));
            }
            if (this.field_70173_aa % 4 == 0 && !this.undroppedItems.isEmpty()) {
                for (int i = 0; i < 3; ++i) {
                    this.spawnItem(this.undroppedItems.remove());
                    if (this.undroppedItems.isEmpty()) break;
                }
            }
            if (!active && this.undroppedItems.isEmpty() && this.isLastWave()) {
                this.completePortal();
            }
        } else if (this.field_70173_aa % 20 == 0) {
            ParticleHandler.spawnIdleParticles(this);
        }
    }

    public boolean isLastWave() {
        return this.getWave() == this.gate.getNumWaves();
    }

    public Wave getCurrentWave() {
        return this.gate.getWave(Math.min(this.gate.getNumWaves() - 1, this.getWave()));
    }

    public void spawnWave() {
        BlockPos blockpos = this.func_233580_cy_();
        List<LivingEntity> spawned = this.gate.getWave(this.getWave()).spawnWave((ServerWorld)this.field_70170_p, blockpos, this);
        this.currentWaveEntities.addAll(spawned);
        this.field_70180_af.func_187227_b(WAVE_ACTIVE, (Object)true);
        this.field_70180_af.func_187227_b(TICKS_ACTIVE, (Object)0);
        this.field_70180_af.func_187227_b(ENEMIES, (Object)this.currentWaveEntities.size());
    }

    protected void completePortal() {
        int i;
        for (int completionXp = this.gate.getCompletionXp(); completionXp > 0; completionXp -= i) {
            i = 5;
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), i));
        }
        PlayerEntity player = this.summonerOrClosest();
        this.gate.getRewards().forEach(r -> r.generateLoot((ServerWorld)this.field_70170_p, this, player, this::spawnCompletionItem));
        this.func_70106_y();
        this.func_184185_a(GatewayObjects.GATE_END, 1.0f, 1.0f);
        this.field_70170_p.func_217373_a(EntityPredicate.field_221016_a, null, this.func_174813_aQ().func_186662_g(15.0)).forEach(p -> p.func_195066_a(GatewayObjects.Stats.STAT_GATES_DEFEATED));
    }

    public void onGateCreated() {
        this.func_184185_a(GatewayObjects.GATE_START, 1.0f, 1.0f);
    }

    protected void onWaveEnd(Wave wave) {
        PlayerEntity player = this.summonerOrClosest();
        this.undroppedItems.addAll(wave.spawnRewards((ServerWorld)this.field_70170_p, this, player));
    }

    public PlayerEntity summonerOrClosest() {
        PlayerEntity player;
        PlayerEntity playerEntity = player = this.summonerId == null ? null : this.field_70170_p.func_217371_b(this.summonerId);
        if (player == null) {
            player = this.field_70170_p.func_217362_a((Entity)this, 50.0);
        }
        if (player == null) {
            return this.summonerId == null ? FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_70170_p)) : FakePlayerFactory.get((ServerWorld)((ServerWorld)this.field_70170_p), (GameProfile)new GameProfile(this.summonerId, ""));
        }
        return player;
    }

    public void onFailure(Collection<LivingEntity> remaining, ITextComponent message) {
        PlayerEntity player = this.summonerOrClosest();
        if (player != null) {
            player.func_145747_a(message, Util.field_240973_b_);
        }
        GatewayEntity.spawnLightningOn(this, false);
        remaining.stream().filter(Entity::func_70089_S).forEach(e -> GatewayEntity.spawnLightningOn((Entity)e, true));
        remaining.forEach(e -> e.func_70106_y());
        this.func_70106_y();
    }

    protected ServerBossInfo createBossEvent() {
        ServerBossInfo event = new ServerBossInfo((ITextComponent)new StringTextComponent("GATEWAY_ID" + this.func_145782_y()), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);
        event.func_186743_c(true);
        return event;
    }

    protected void func_213281_b(CompoundNBT tag) {
        tag.func_74768_a("wave", this.getWave());
        tag.func_74778_a("gate", this.gate.getId().toString());
        long[] ids = new long[this.currentWaveEntities.size() * 2];
        int idx = 0;
        for (LivingEntity e : this.currentWaveEntities) {
            UUID id = e.func_110124_au();
            ids[idx++] = id.getMostSignificantBits();
            ids[idx++] = id.getLeastSignificantBits();
        }
        tag.func_197644_a("wave_entities", ids);
        tag.func_74757_a("active", this.isWaveActive());
        tag.func_74768_a("ticks_active", this.getTicksActive());
        if (this.summonerId != null) {
            tag.func_186854_a("summoner", this.summonerId);
        }
        ListNBT stacks = new ListNBT();
        for (ItemStack s : this.undroppedItems) {
            stacks.add((Object)s.serializeNBT());
        }
        tag.func_218657_a("queued_stacks", (INBT)stacks);
    }

    protected void func_70037_a(CompoundNBT tag) {
        this.field_70180_af.func_187227_b(WAVE, (Object)tag.func_74762_e("wave"));
        this.gate = (Gateway)GatewayManager.INSTANCE.getOrDefault(new ResourceLocation(tag.func_74779_i("gate")), (PlaceboJsonReloadListener.TypeKeyed)this.gate);
        if (this.gate == null) {
            Gateways.LOGGER.error("Invalid gateway at {} will be removed.", (Object)this.func_213303_ch());
            this.func_70106_y();
        }
        long[] entities = tag.func_197645_o("wave_entities");
        for (int i = 0; i < entities.length; i += 2) {
            this.unresolvedWaveEntities.add(new UUID(entities[i], entities[i + 1]));
        }
        this.field_70180_af.func_187227_b(WAVE_ACTIVE, (Object)tag.func_74767_n("active"));
        this.field_70180_af.func_187227_b(TICKS_ACTIVE, (Object)tag.func_74762_e("ticks_active"));
        if (tag.func_74764_b("summoner")) {
            this.summonerId = tag.func_186857_a("summoner");
        }
        ListNBT stacks = tag.func_150295_c("queued_stacks", 10);
        for (INBT inbt : stacks) {
            this.undroppedItems.add(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)inbt)));
        }
        this.bossEvent = this.createBossEvent();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(WAVE_ACTIVE, (Object)false);
        this.field_70180_af.func_187214_a(TICKS_ACTIVE, (Object)0);
        this.field_70180_af.func_187214_a(WAVE, (Object)0);
        this.field_70180_af.func_187214_a(ENEMIES, (Object)0);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossEvent.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossEvent.func_186761_b(player);
    }

    public int getTicksActive() {
        return (Integer)this.field_70180_af.func_187225_a(TICKS_ACTIVE);
    }

    public boolean isWaveActive() {
        return (Boolean)this.field_70180_af.func_187225_a(WAVE_ACTIVE);
    }

    public int getWave() {
        return (Integer)this.field_70180_af.func_187225_a(WAVE);
    }

    public int getActiveEnemies() {
        return (Integer)this.field_70180_af.func_187225_a(ENEMIES);
    }

    public Gateway getGateway() {
        return this.gate;
    }

    public ServerBossInfo getBossInfo() {
        return this.bossEvent;
    }

    public float getClientScale() {
        return this.clientScale;
    }

    public void setClientScale(float clientScale) {
        this.clientScale = clientScale;
    }

    public static void spawnLightningOn(Entity entity, boolean effectOnly) {
        LightningBoltEntity bolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(entity.field_70170_p);
        bolt.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        bolt.func_233623_a_(effectOnly);
        entity.field_70170_p.func_217376_c((Entity)bolt);
    }

    public void spawnParticle(Color color, double x, double y, double z, int type) {
        NetworkUtils.sendToTracking((SimpleChannel)Gateways.CHANNEL, (Object)((Object)new ParticleMessage(this, x, y, z, color, type)), (ServerWorld)((ServerWorld)this.field_70170_p), (BlockPos)new BlockPos((int)x, (int)y, (int)z));
    }

    public void spawnItem(ItemStack stack) {
        ItemEntity i = new ItemEntity(this.field_70170_p, 0.0, 0.0, 0.0, stack);
        i.func_70107_b(this.func_226277_ct_() + MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.5, (double)0.5), this.func_226278_cu_() + 1.5, this.func_226281_cx_() + MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.5, (double)0.5));
        i.func_213293_j(MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.15, (double)0.15), 0.4, MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.15, (double)0.15));
        this.field_70170_p.func_217376_c((Entity)i);
        this.field_70170_p.func_184148_a(null, i.func_226277_ct_(), i.func_226278_cu_(), i.func_226281_cx_(), GatewayObjects.GATE_WARP, SoundCategory.HOSTILE, 0.25f, 2.0f);
    }

    public void spawnCompletionItem(ItemStack stack) {
        ItemEntity i = new ItemEntity(this.field_70170_p, 0.0, 0.0, 0.0, stack);
        double variance = 0.05f * this.gate.getSize().getScale();
        i.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_());
        i.func_213293_j(MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(-variance), (double)variance), (double)(this.func_213302_cg() / 20.0f), MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(-variance), (double)variance));
        i.func_174873_u();
        this.field_70170_p.func_217376_c((Entity)i);
    }

    public void writeSpawnData(PacketBuffer buf) {
        buf.func_192572_a(this.gate.getId());
    }

    public void readSpawnData(PacketBuffer buf) {
        this.gate = (Gateway)GatewayManager.INSTANCE.getValue(buf.func_192575_l());
        if (this.gate == null) {
            throw new RuntimeException("Invalid gateway received on client!");
        }
    }

    protected int func_184840_I() {
        return 2;
    }

    public static enum GatewaySize {
        SMALL(EntitySize.func_220314_b((float)2.0f, (float)3.0f), 1.0f),
        MEDIUM(EntitySize.func_220314_b((float)4.0f, (float)6.0f), 2.0f),
        LARGE(EntitySize.func_220314_b((float)6.0f, (float)9.0f), 3.0f);

        private final EntitySize dims;
        private final float scale;

        private GatewaySize(EntitySize dims, float scale) {
            this.dims = dims;
            this.scale = scale;
        }

        public float getScale() {
            return this.scale;
        }
    }
}

