/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.gate;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.text.Color;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.gate.Reward;
import shadows.gateways.gate.Wave;
import shadows.gateways.misc.RandomAttributeModifier;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.util.json.ItemAdapter;
import shadows.placebo.util.json.NBTAdapter;

public class Gateway
extends PlaceboJsonReloadListener.TypeKeyedBase<Gateway> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(Reward.class, (Object)new Reward.Serializer()).registerTypeAdapter(ItemStack.class, (Object)ItemAdapter.INSTANCE).registerTypeAdapter(CompoundNBT.class, (Object)NBTAdapter.INSTANCE).registerTypeAdapter(RandomAttributeModifier.class, (Object)new RandomAttributeModifier.Deserializer()).registerTypeAdapter(Wave.class, (Object)new Wave.Serializer()).create();
    protected final GatewayEntity.GatewaySize size;
    protected final Color color;
    protected final List<Wave> waves;
    protected final List<Reward> rewards;
    protected final int completionXp;
    protected final double spawnRange;
    protected final double leashRange;

    Gateway(GatewayEntity.GatewaySize size, Color color, List<Wave> waves, List<Reward> rewards, int completionXp, double spawnRange, double leashRange) {
        this.size = size;
        this.color = color;
        this.waves = waves;
        this.rewards = rewards;
        this.completionXp = completionXp;
        this.spawnRange = spawnRange;
        this.leashRange = leashRange;
    }

    public GatewayEntity.GatewaySize getSize() {
        return this.size;
    }

    public Color getColor() {
        return this.color;
    }

    public List<Wave> getWaves() {
        return this.waves;
    }

    public int getNumWaves() {
        return this.waves.size();
    }

    public Wave getWave(int n) {
        return this.waves.get(n);
    }

    public List<Reward> getRewards() {
        return this.rewards;
    }

    public int getCompletionXp() {
        return this.completionXp;
    }

    public double getSpawnRange() {
        return this.spawnRange;
    }

    public JsonObject write() {
        JsonObject obj = new JsonObject();
        obj.addProperty("size", this.size.name().toLowerCase(Locale.ROOT));
        obj.addProperty("color", this.color.func_240747_b_());
        obj.add("waves", GSON.toJsonTree(this.waves));
        obj.add("rewards", GSON.toJsonTree(this.rewards));
        obj.addProperty("completion_xp", (Number)this.completionXp);
        obj.addProperty("spawn_range", (Number)this.spawnRange);
        obj.addProperty("leash_range", (Number)this.leashRange);
        return obj;
    }

    public static Gateway read(JsonObject obj) {
        GatewayEntity.GatewaySize size;
        String _size = JSONUtils.func_151200_h((JsonObject)obj, (String)"size").toUpperCase(Locale.ROOT);
        try {
            size = GatewayEntity.GatewaySize.valueOf(_size);
        }
        catch (IllegalArgumentException ex) {
            throw new JsonParseException("Invalid gateway size " + _size);
        }
        String _color = JSONUtils.func_151200_h((JsonObject)obj, (String)"color");
        Color color = Color.func_240745_a_((String)_color);
        if (color == null) {
            throw new JsonParseException("Invalid gateway color " + _color);
        }
        List waves = (List)GSON.fromJson(obj.get("waves"), new TypeToken<List<Wave>>(){}.getType());
        List rewards = (List)GSON.fromJson(obj.get("rewards"), new TypeToken<List<Reward>>(){}.getType());
        int completionXp = JSONUtils.func_151203_m((JsonObject)obj, (String)"completion_xp");
        double spawnRange = JSONUtils.func_151217_k((JsonObject)obj, (String)"spawn_range");
        double leashRange = JSONUtils.func_151221_a((JsonObject)obj, (String)"leash_range", (float)32.0f);
        return new Gateway(size, color, waves, rewards, completionXp, spawnRange, leashRange);
    }

    public void write(PacketBuffer buf) {
        buf.writeByte(this.size.ordinal());
        buf.func_180714_a(this.color.func_240747_b_());
        buf.func_150787_b(this.waves.size());
        this.waves.forEach(w -> w.write(buf));
        buf.func_150787_b(this.rewards.size());
        this.rewards.forEach(r -> r.write(buf));
        buf.writeInt(this.completionXp);
        buf.writeDouble(this.spawnRange);
        buf.writeDouble(this.leashRange);
    }

    public static Gateway read(PacketBuffer buf) {
        GatewayEntity.GatewaySize size = GatewayEntity.GatewaySize.values()[buf.readByte()];
        Color color = Color.func_240745_a_((String)buf.func_218666_n());
        int nWaves = buf.func_150792_a();
        ArrayList<Wave> waves = new ArrayList<Wave>(nWaves);
        for (int i = 0; i < nWaves; ++i) {
            waves.add(Wave.read(buf));
        }
        int nRewards = buf.func_150792_a();
        ArrayList<Reward> rewards = new ArrayList<Reward>(nRewards);
        for (int i = 0; i < nRewards; ++i) {
            rewards.add(Reward.read(buf));
        }
        int completionXp = buf.readInt();
        double spawnRange = buf.readDouble();
        double leashRange = buf.readDouble();
        return new Gateway(size, color, waves, rewards, completionXp, spawnRange, leashRange);
    }

    public double getLeashRangeSq() {
        return this.leashRange * this.leashRange;
    }
}

