/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.gate;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.misc.GSerialBuilder;
import shadows.placebo.json.SerializerBuilder;
import shadows.placebo.util.json.ItemAdapter;

public interface Reward {
    public static final Method dropFromLootTable = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"func_213354_a", (Class[])new Class[]{DamageSource.class, Boolean.TYPE});
    public static final MethodHandle DROP_LOOT = Reward.lootMethodHandle();
    public static final Map<String, SerializerBuilder.Serializer> SERIALIZERS = new HashMap<String, SerializerBuilder.Serializer>();

    public void generateLoot(ServerWorld var1, GatewayEntity var2, PlayerEntity var3, Consumer<ItemStack> var4);

    default public JsonObject write() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", this.getName());
        return obj;
    }

    default public void write(PacketBuffer buf) {
        buf.func_180714_a(this.getName());
    }

    public String getName();

    public void appendHoverText(Consumer<ITextComponent> var1);

    public static Reward read(JsonElement json) {
        JsonObject obj = json.getAsJsonObject();
        String type = JSONUtils.func_151200_h((JsonObject)obj, (String)"type");
        SerializerBuilder.Serializer serializer = SERIALIZERS.get(type);
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown Reward Type: " + type);
        }
        return (Reward)serializer.deserialize(obj);
    }

    public static Reward read(PacketBuffer buf) {
        String type = buf.func_218666_n();
        SerializerBuilder.Serializer serializer = SERIALIZERS.get(type);
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown Reward Type: " + type);
        }
        return (Reward)serializer.deserialize(buf);
    }

    public static void initSerializers() {
        SERIALIZERS.put("stack", new GSerialBuilder("Stack Reward").json(StackReward::read, StackReward::write).net(StackReward::read, StackReward::write).build(true));
        SERIALIZERS.put("stack_list", new GSerialBuilder("Stack List Reward").json(StackListReward::read, StackListReward::write).net(StackListReward::read, StackListReward::write).build(true));
        SERIALIZERS.put("entity_loot", new GSerialBuilder("Entity Loot Reward").json(EntityLootReward::read, EntityLootReward::write).net(EntityLootReward::read, EntityLootReward::write).build(true));
        SERIALIZERS.put("loot_table", new GSerialBuilder("Entity Loot Reward").json(LootTableReward::read, LootTableReward::write).net(LootTableReward::read, LootTableReward::write).build(true));
        SERIALIZERS.put("chanced", new GSerialBuilder("Chanced Reward").json(ChancedReward::read, ChancedReward::write).net(ChancedReward::read, ChancedReward::write).build(true));
        SERIALIZERS.put("command", new GSerialBuilder("Command Reward").json(CommandReward::read, CommandReward::write).net(CommandReward::read, CommandReward::write).build(true));
    }

    public static MethodHandle lootMethodHandle() {
        dropFromLootTable.setAccessible(true);
        try {
            return MethodHandles.lookup().unreflect(dropFromLootTable);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class CommandReward
    implements Reward {
        private final String command;

        CommandReward(String command) {
            this.command = command;
        }

        @Override
        public void generateLoot(ServerWorld level, GatewayEntity gate, PlayerEntity summoner, Consumer<ItemStack> list) {
            String realCmd = this.command.replace("<summoner>", summoner.func_146103_bH().getName());
            level.func_73046_m().func_195571_aL().func_197059_a(gate.func_195051_bN(), realCmd);
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Reward.super.write();
            obj.addProperty("command", this.command);
            return obj;
        }

        public static CommandReward read(JsonObject obj) {
            return new CommandReward(JSONUtils.func_151200_h((JsonObject)obj, (String)"command"));
        }

        @Override
        public void write(PacketBuffer buf) {
            Reward.super.write(buf);
            buf.func_180714_a(this.command);
        }

        public static CommandReward read(PacketBuffer buf) {
            return new CommandReward(buf.func_218666_n());
        }

        @Override
        public String getName() {
            return "command";
        }

        @Override
        public void appendHoverText(Consumer<ITextComponent> list) {
            list.accept((ITextComponent)new TranslationTextComponent("reward.gateways.command", new Object[]{this.command}));
        }
    }

    public static class ChancedReward
    implements Reward {
        private final Reward reward;
        private final float chance;
        static DecimalFormat fmt = new DecimalFormat("##.##%");

        public ChancedReward(Reward reward, float chance) {
            this.reward = reward;
            this.chance = chance;
        }

        @Override
        public void generateLoot(ServerWorld level, GatewayEntity gate, PlayerEntity summoner, Consumer<ItemStack> list) {
            if (level.field_73012_v.nextFloat() < this.chance) {
                this.reward.generateLoot(level, gate, summoner, list);
            }
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Reward.super.write();
            obj.addProperty("chance", (Number)Float.valueOf(this.chance));
            obj.add("reward", (JsonElement)this.reward.write());
            return obj;
        }

        public static ChancedReward read(JsonObject obj) {
            float chance = JSONUtils.func_151217_k((JsonObject)obj, (String)"chance");
            Reward reward = Reward.read((JsonElement)JSONUtils.func_152754_s((JsonObject)obj, (String)"reward"));
            return new ChancedReward(reward, chance);
        }

        @Override
        public void write(PacketBuffer buf) {
            Reward.super.write(buf);
            buf.writeFloat(this.chance);
            this.reward.write(buf);
        }

        public static ChancedReward read(PacketBuffer buf) {
            float chance = buf.readFloat();
            Reward reward = Reward.read(buf);
            return new ChancedReward(reward, chance);
        }

        @Override
        public String getName() {
            return "chanced";
        }

        @Override
        public void appendHoverText(Consumer<ITextComponent> list) {
            this.reward.appendHoverText(c -> list.accept((ITextComponent)new TranslationTextComponent("reward.gateways.chance", new Object[]{fmt.format(this.chance * 100.0f), c})));
        }
    }

    public static class LootTableReward
    implements Reward {
        private final ResourceLocation table;
        private final int rolls;

        public LootTableReward(ResourceLocation table, int rolls) {
            this.table = table;
            this.rolls = rolls;
        }

        @Override
        public void generateLoot(ServerWorld level, GatewayEntity gate, PlayerEntity summoner, Consumer<ItemStack> list) {
            LootTable realTable = level.func_73046_m().func_200249_aQ().func_186521_a(this.table);
            for (int i = 0; i < this.rolls; ++i) {
                LootContext.Builder ctx = new LootContext.Builder(level).func_216015_a(LootParameters.field_237457_g_, (Object)gate.func_242282_l(1.0f)).func_216016_a((long)(gate.field_70173_aa + i));
                ctx.func_186469_a(summoner.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)summoner).func_216015_a(LootParameters.field_216289_i, (Object)summoner.func_184614_ca());
                realTable.func_216113_a(ctx.func_216022_a(LootParameterSets.field_216261_b)).forEach(list);
            }
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Reward.super.write();
            obj.addProperty("loot_table", this.table.toString());
            obj.addProperty("rolls", (Number)this.rolls);
            return obj;
        }

        public static LootTableReward read(JsonObject obj) {
            return new LootTableReward(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)obj, (String)"loot_table")), JSONUtils.func_151203_m((JsonObject)obj, (String)"rolls"));
        }

        @Override
        public void write(PacketBuffer buf) {
            Reward.super.write(buf);
            buf.func_192572_a(this.table);
            buf.writeInt(this.rolls);
        }

        public static LootTableReward read(PacketBuffer buf) {
            return new LootTableReward(buf.func_192575_l(), buf.readInt());
        }

        @Override
        public String getName() {
            return "loot_table";
        }

        @Override
        public void appendHoverText(Consumer<ITextComponent> list) {
            list.accept((ITextComponent)new TranslationTextComponent("reward.gateways.loot_table", new Object[]{this.rolls, this.table}));
        }
    }

    public static class EntityLootReward
    implements Reward {
        private final EntityType<?> type;
        @Nullable
        private final CompoundNBT nbt;
        private final int rolls;

        public EntityLootReward(EntityType<?> type, @Nullable CompoundNBT nbt, int rolls) {
            this.type = type;
            this.nbt = nbt;
            this.rolls = rolls;
        }

        @Override
        public void generateLoot(ServerWorld level, GatewayEntity gate, PlayerEntity summoner, Consumer<ItemStack> list) {
            try {
                ArrayList items = new ArrayList();
                Entity entity = this.type.func_200721_a((World)level);
                for (int i = 0; i < this.rolls; ++i) {
                    if (this.nbt != null) {
                        entity.func_70020_e(this.nbt);
                    }
                    entity.func_70012_b(summoner.func_226277_ct_(), summoner.func_226278_cu_(), summoner.func_226281_cx_(), 0.0f, 0.0f);
                    entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)summoner).func_151518_m().func_76359_i().func_76348_h(), 1.0f);
                    entity.captureDrops(items);
                    DROP_LOOT.invoke(entity, DamageSource.func_76365_a((PlayerEntity)summoner), true);
                    entity.remove(false);
                }
                items.stream().map(ItemEntity::func_92059_d).forEach(list);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Reward.super.write();
            obj.addProperty("entity", this.type.getRegistryName().toString());
            if (this.nbt != null) {
                obj.add("nbt", ItemAdapter.ITEM_READER.toJsonTree((Object)this.nbt));
            }
            obj.addProperty("rolls", (Number)this.rolls);
            return obj;
        }

        public static EntityLootReward read(JsonObject obj) {
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)obj, (String)"entity")));
            CompoundNBT tag = obj.has("nbt") ? (CompoundNBT)ItemAdapter.ITEM_READER.fromJson(obj.get("nbt"), CompoundNBT.class) : null;
            int rolls = JSONUtils.func_151203_m((JsonObject)obj, (String)"rolls");
            return new EntityLootReward(type, tag, rolls);
        }

        @Override
        public void write(PacketBuffer buf) {
            Reward.super.write(buf);
            buf.writeRegistryId(this.type);
            buf.func_150786_a(this.nbt == null ? new CompoundNBT() : this.nbt);
            buf.func_150787_b(this.rolls);
        }

        public static EntityLootReward read(PacketBuffer buf) {
            EntityType type = (EntityType)buf.readRegistryIdSafe(EntityType.class);
            CompoundNBT tag = buf.func_150793_b();
            int rolls = buf.func_150792_a();
            return new EntityLootReward(type, tag, rolls);
        }

        @Override
        public String getName() {
            return "entity_loot";
        }

        @Override
        public void appendHoverText(Consumer<ITextComponent> list) {
            list.accept((ITextComponent)new TranslationTextComponent("reward.gateways.entity", new Object[]{this.rolls, new TranslationTextComponent(this.type.func_210760_d())}));
        }
    }

    public static class StackListReward
    implements Reward {
        private final NonNullList<ItemStack> stacks;

        public StackListReward(NonNullList<ItemStack> stacks) {
            this.stacks = stacks;
        }

        @Override
        public void generateLoot(ServerWorld level, GatewayEntity gate, PlayerEntity summoner, Consumer<ItemStack> list) {
            this.stacks.forEach(s -> list.accept(s.func_77946_l()));
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Reward.super.write();
            obj.add("stacks", ItemAdapter.ITEM_READER.toJsonTree(this.stacks));
            return obj;
        }

        public static StackListReward read(JsonObject obj) {
            return new StackListReward((NonNullList<ItemStack>)((NonNullList)ItemAdapter.ITEM_READER.fromJson(obj.get("stacks"), new TypeToken<List<ItemStack>>(){}.getType())));
        }

        @Override
        public void write(PacketBuffer buf) {
            Reward.super.write(buf);
            buf.func_150787_b(this.stacks.size());
            this.stacks.forEach(arg_0 -> ((PacketBuffer)buf).func_150788_a(arg_0));
        }

        public static StackListReward read(PacketBuffer buf) {
            NonNullList stacks = NonNullList.func_191197_a((int)buf.func_150792_a(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < stacks.size(); ++i) {
                stacks.set(i, (Object)buf.func_150791_c());
            }
            return new StackListReward((NonNullList<ItemStack>)stacks);
        }

        @Override
        public String getName() {
            return "stack_list";
        }

        @Override
        public void appendHoverText(Consumer<ITextComponent> list) {
            for (ItemStack stack : this.stacks) {
                list.accept((ITextComponent)new TranslationTextComponent("reward.gateways.stack", new Object[]{stack.func_190916_E(), stack.func_151000_E()}));
            }
        }
    }

    public static class StackReward
    implements Reward {
        private final ItemStack stack;

        public StackReward(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public void generateLoot(ServerWorld level, GatewayEntity gate, PlayerEntity summoner, Consumer<ItemStack> list) {
            list.accept(this.stack.func_77946_l());
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Reward.super.write();
            obj.add("stack", ItemAdapter.ITEM_READER.toJsonTree((Object)this.stack));
            return obj;
        }

        public static StackReward read(JsonObject obj) {
            return new StackReward((ItemStack)ItemAdapter.ITEM_READER.fromJson(obj.get("stack"), ItemStack.class));
        }

        @Override
        public void write(PacketBuffer buf) {
            Reward.super.write(buf);
            buf.func_150788_a(this.stack);
        }

        public static StackReward read(PacketBuffer buf) {
            return new StackReward(buf.func_150791_c());
        }

        @Override
        public String getName() {
            return "stack";
        }

        @Override
        public void appendHoverText(Consumer<ITextComponent> list) {
            list.accept((ITextComponent)new TranslationTextComponent("reward.gateways.stack", new Object[]{this.stack.func_190916_E(), this.stack.func_151000_E()}));
        }
    }

    public static class Serializer
    implements JsonDeserializer<Reward>,
    JsonSerializer<Reward> {
        public JsonElement serialize(Reward src, Type typeOfSrc, JsonSerializationContext context) {
            return src.write();
        }

        public Reward deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Reward.read(json);
        }
    }
}

