/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.gate;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.gateways.GatewayObjects;
import shadows.gateways.Gateways;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.gate.Gateway;
import shadows.gateways.gate.Reward;
import shadows.gateways.gate.WaveEntity;
import shadows.gateways.misc.RandomAttributeModifier;
import shadows.gateways.misc.StepFunction;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.SerializerBuilder;

public class Wave {
    private final List<WaveEntity> entities;
    private final List<RandomAttributeModifier> modifiers;
    private final List<Reward> rewards;
    private final int maxWaveTime;
    private final int setupTime;

    public Wave(List<WaveEntity> entities, List<RandomAttributeModifier> modifiers, List<Reward> rewards, int maxWaveTime, int setupTime) {
        this.entities = entities;
        this.modifiers = modifiers;
        this.rewards = rewards;
        this.maxWaveTime = maxWaveTime;
        this.setupTime = setupTime;
    }

    public List<LivingEntity> spawnWave(ServerWorld level, BlockPos pos, GatewayEntity gate) {
        ArrayList<LivingEntity> spawned = new ArrayList<LivingEntity>();
        for (WaveEntity toSpawn : this.entities) {
            double spawnRange = gate.getGateway().getSpawnRange();
            int tries = 0;
            double x = (double)pos.func_177958_n() + (-1.0 + 2.0 * level.field_73012_v.nextDouble()) * spawnRange;
            double y = pos.func_177956_o() + level.field_73012_v.nextInt(3) - 1;
            double z = (double)pos.func_177952_p() + (-1.0 + 2.0 * level.field_73012_v.nextDouble()) * spawnRange;
            while (!level.func_226664_a_(toSpawn.getAABB(x, y, z)) && tries++ < 7) {
                x = (double)pos.func_177958_n() + (level.field_73012_v.nextDouble() - level.field_73012_v.nextDouble()) * spawnRange + 0.5;
                y = pos.func_177956_o() + level.field_73012_v.nextInt(3 * (int)gate.getGateway().getSize().getScale()) - 1;
                z = (double)pos.func_177952_p() + (level.field_73012_v.nextDouble() - level.field_73012_v.nextDouble()) * spawnRange + 0.5;
            }
            double fx = x;
            double fy = y;
            double fz = z;
            if (level.func_226664_a_(toSpawn.getAABB(fx, fy, fz))) {
                LivingEntity entity = toSpawn.createEntity((World)level);
                if (entity == null) {
                    Gateways.LOGGER.error("Gate {} failed to create a living entity during wave {}!", (Object)gate.func_200200_C_().getString(), (Object)gate.getWave());
                    continue;
                }
                entity.func_70012_b(fx, fy, fz, level.field_73012_v.nextFloat() * 360.0f, level.field_73012_v.nextFloat() * 360.0f);
                entity.func_226276_cg_().filter(e -> e instanceof LivingEntity).map(LivingEntity.class::cast).forEach(e -> {
                    this.modifiers.forEach(m -> m.apply(level.field_73012_v, (LivingEntity)e));
                    e.func_70606_j(entity.func_110138_aP());
                    e.func_195064_c(new EffectInstance(Effects.field_76429_m, 5, 100, true, false));
                });
                if (entity instanceof MobEntity) {
                    MobEntity mob = (MobEntity)entity;
                    if (toSpawn.shouldFinalizeSpawn() && !ForgeEventFactory.doSpecialSpawn((MobEntity)((MobEntity)entity), (World)level, (float)((float)entity.func_226277_ct_()), (float)((float)entity.func_226278_cu_()), (float)((float)entity.func_226281_cx_()), null, (SpawnReason)SpawnReason.SPAWNER)) {
                        mob.func_213386_a((IServerWorld)level, level.func_175649_E(entity.func_233580_cy_()), SpawnReason.SPAWNER, null, null);
                    }
                    mob.func_70624_b((LivingEntity)gate.field_70170_p.func_217362_a((Entity)gate, 12.0));
                }
                level.func_242417_l((Entity)entity);
                level.func_184148_a(null, gate.func_226277_ct_(), gate.func_226278_cu_(), gate.func_226281_cx_(), GatewayObjects.GATE_WARP, SoundCategory.HOSTILE, 0.5f, 1.0f);
                spawned.add(entity);
                gate.spawnParticle(gate.getGateway().getColor(), entity.func_226277_ct_() + (double)(entity.func_213311_cf() / 2.0f), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_() + (double)(entity.func_213311_cf() / 2.0f), 0);
                continue;
            }
            gate.onFailure(spawned, (ITextComponent)new TranslationTextComponent("error.gateways.wave_failed").func_240699_a_(TextFormatting.RED));
            break;
        }
        return spawned;
    }

    public List<ItemStack> spawnRewards(ServerWorld level, GatewayEntity gate, PlayerEntity summoner) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        this.rewards.forEach(r -> r.generateLoot(level, gate, summoner, s -> {
            if (!s.func_190926_b()) {
                stacks.add((ItemStack)s);
            }
        }));
        return stacks;
    }

    public JsonObject write() {
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        for (WaveEntity entity : this.entities) {
            SerializerBuilder.Serializer s = entity.getSerializer();
            ResourceLocation id = (ResourceLocation)WaveEntity.SERIALIZERS.inverse().get((Object)s);
            JsonObject entityData = s.serialize((Object)entity);
            entityData.addProperty("type", id.toString());
            arr.add((JsonElement)entityData);
        }
        obj.add("entities", (JsonElement)arr);
        obj.add("modifiers", Gateway.GSON.toJsonTree(this.modifiers));
        obj.add("rewards", Gateway.GSON.toJsonTree(this.rewards));
        obj.addProperty("max_wave_time", (Number)this.maxWaveTime);
        obj.addProperty("setup_time", (Number)this.setupTime);
        return obj;
    }

    public static Wave read(JsonObject obj) {
        List<Reward> rewards;
        JsonArray entities = obj.get("entities").getAsJsonArray();
        ArrayList<WaveEntity> entityList = new ArrayList<WaveEntity>();
        for (JsonElement e : entities) {
            JsonObject entity = e.getAsJsonObject();
            ResourceLocation id = entity.has("type") ? new ResourceLocation(entity.get("type").getAsString()) : PlaceboJsonReloadListener.DEFAULT;
            SerializerBuilder.Serializer s = (SerializerBuilder.Serializer)WaveEntity.SERIALIZERS.get((Object)id);
            entityList.add((WaveEntity)s.deserialize(entity));
        }
        List<RandomAttributeModifier> modifiers = (List<RandomAttributeModifier>)Gateway.GSON.fromJson(obj.get("modifiers"), new TypeToken<List<RandomAttributeModifier>>(){}.getType());
        if (modifiers == null) {
            modifiers = Collections.emptyList();
        }
        if ((rewards = (List<Reward>)Gateway.GSON.fromJson(obj.get("rewards"), new TypeToken<List<Reward>>(){}.getType())) == null) {
            rewards = Collections.emptyList();
        }
        int maxWaveTime = JSONUtils.func_151203_m((JsonObject)obj, (String)"max_wave_time");
        int recoveryTime = JSONUtils.func_151203_m((JsonObject)obj, (String)"setup_time");
        return new Wave(entityList, modifiers, rewards, maxWaveTime, recoveryTime);
    }

    public void write(PacketBuffer buf) {
        buf.func_150787_b(this.entities.size());
        for (WaveEntity entity : this.entities) {
            SerializerBuilder.Serializer s = entity.getSerializer();
            ResourceLocation id = (ResourceLocation)WaveEntity.SERIALIZERS.inverse().get((Object)s);
            buf.func_192572_a(id);
            s.serialize((Object)entity, buf);
        }
        buf.func_150787_b(this.modifiers.size());
        this.modifiers.forEach(m -> {
            buf.writeRegistryId((IForgeRegistryEntry)m.getAttribute());
            buf.writeByte(m.getOp().ordinal());
            buf.writeFloat(m.getValue().min());
        });
        buf.func_150787_b(this.rewards.size());
        this.rewards.forEach(r -> r.write(buf));
        buf.writeInt(this.maxWaveTime);
        buf.writeInt(this.setupTime);
    }

    public static Wave read(PacketBuffer buf) {
        int size = buf.func_150792_a();
        ArrayList<WaveEntity> entities = new ArrayList<WaveEntity>(size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buf.func_192575_l();
            SerializerBuilder.Serializer s = (SerializerBuilder.Serializer)WaveEntity.SERIALIZERS.get((Object)id);
            entities.add((WaveEntity)s.deserialize(buf));
        }
        size = buf.func_150792_a();
        ArrayList<RandomAttributeModifier> modifiers = new ArrayList<RandomAttributeModifier>(size);
        for (int i = 0; i < size; ++i) {
            Attribute attrib = (Attribute)buf.readRegistryIdSafe(Attribute.class);
            AttributeModifier.Operation op = AttributeModifier.Operation.values()[buf.readByte()];
            float value = buf.readFloat();
            modifiers.add(new RandomAttributeModifier(attrib, op, new StepFunction(value, 1, 0.0f)));
        }
        size = buf.func_150792_a();
        ArrayList<Reward> rewards = new ArrayList<Reward>(size);
        for (int i = 0; i < size; ++i) {
            rewards.add(Reward.read(buf));
        }
        int maxWaveTime = buf.readInt();
        int recoveryTime = buf.readInt();
        return new Wave(entities, modifiers, rewards, maxWaveTime, recoveryTime);
    }

    public int maxWaveTime() {
        return this.maxWaveTime;
    }

    public int setupTime() {
        return this.setupTime;
    }

    public List<WaveEntity> entities() {
        return this.entities;
    }

    public List<RandomAttributeModifier> modifiers() {
        return this.modifiers;
    }

    public List<Reward> rewards() {
        return this.rewards;
    }

    public static class Serializer
    implements JsonDeserializer<Wave>,
    JsonSerializer<Wave> {
        public JsonElement serialize(Wave src, Type typeOfSrc, JsonSerializationContext context) {
            return src.write();
        }

        public Wave deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Wave.read(json.getAsJsonObject());
        }
    }
}

