/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.gate;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.SerializerBuilder;
import shadows.placebo.util.json.ItemAdapter;

public interface WaveEntity {
    public static final BiMap<ResourceLocation, SerializerBuilder.Serializer> SERIALIZERS = HashBiMap.create();

    public LivingEntity createEntity(World var1);

    public ITextComponent getDescription();

    public AxisAlignedBB getAABB(double var1, double var3, double var5);

    public boolean shouldFinalizeSpawn();

    public SerializerBuilder.Serializer getSerializer();

    public static void initSerializers() {
        SERIALIZERS.put((Object)PlaceboJsonReloadListener.DEFAULT, (Object)StandardWaveEntity.SERIALIZER);
    }

    public static <T extends IForgeRegistryEntry<T>> T getRegistryObject(JsonObject parent, String name, IForgeRegistry<T> registry) {
        String key = JSONUtils.func_151200_h((JsonObject)parent, (String)name);
        IForgeRegistryEntry regObj = registry.getValue(new ResourceLocation(key));
        if (regObj == null) {
            throw new JsonSyntaxException("Failed to parse " + registry.getRegistryName() + " object with key " + key);
        }
        return (T)regObj;
    }

    public static class StandardWaveEntity
    implements WaveEntity {
        static final SerializerBuilder.Serializer SERIALIZER = new SerializerBuilder("Std Wave Entity").withJsonDeserializer(StandardWaveEntity::read).withJsonSerializer(StandardWaveEntity::write).withNetworkDeserializer(StandardWaveEntity::read).withNetworkSerializer(StandardWaveEntity::write).build(true);
        protected final EntityType<?> type;
        protected final CompoundNBT tag;

        public StandardWaveEntity(EntityType<?> type, @Nullable CompoundNBT tag) {
            this.type = type;
            this.tag = tag == null ? new CompoundNBT() : tag;
            this.tag.func_74778_a("id", type.getRegistryName().toString());
        }

        @Override
        public LivingEntity createEntity(World level) {
            Entity ent = EntityType.func_220335_a((CompoundNBT)this.tag, (World)level, Function.identity());
            return ent instanceof LivingEntity ? (LivingEntity)ent : null;
        }

        @Override
        public ITextComponent getDescription() {
            return new TranslationTextComponent(this.type.func_210760_d());
        }

        @Override
        public AxisAlignedBB getAABB(double x, double y, double z) {
            return this.type.func_220328_a(x, y, z);
        }

        @Override
        public boolean shouldFinalizeSpawn() {
            return this.tag.func_186856_d() == 1 || this.tag.func_74767_n("ForceFinalizeSpawn");
        }

        @Override
        public SerializerBuilder.Serializer getSerializer() {
            return SERIALIZER;
        }

        public JsonObject write() {
            JsonObject entityData = new JsonObject();
            entityData.addProperty("entity", this.type.getRegistryName().toString());
            if (this.tag != null) {
                entityData.add("nbt", ItemAdapter.ITEM_READER.toJsonTree((Object)this.tag));
            }
            return entityData;
        }

        public static StandardWaveEntity read(JsonObject obj) {
            EntityType type = (EntityType)WaveEntity.getRegistryObject(obj, "entity", ForgeRegistries.ENTITIES);
            CompoundNBT nbt = obj.has("nbt") ? (CompoundNBT)ItemAdapter.ITEM_READER.fromJson(obj.get("nbt"), CompoundNBT.class) : null;
            return new StandardWaveEntity(type, nbt);
        }

        public void write(PacketBuffer buf) {
            buf.writeRegistryId(this.type);
        }

        public static StandardWaveEntity read(PacketBuffer buf) {
            return new StandardWaveEntity((EntityType)buf.readRegistryIdSafe(EntityType.class), null);
        }
    }
}

