/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.item;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.gate.Gateway;
import shadows.gateways.gate.GatewayManager;

public class GatePearlItem
extends Item {
    public GatePearlItem(Item.Properties props) {
        super(props);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        ItemStack stack = ctx.func_195996_i();
        BlockPos pos = ctx.func_195995_a();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (!world.func_217357_a(GatewayEntity.class, new AxisAlignedBB(pos).func_72314_b(25.0, 25.0, 25.0)).isEmpty()) {
            return ActionResultType.FAIL;
        }
        GatewayEntity entity = new GatewayEntity(world, ctx.func_195999_j(), GatePearlItem.getGate(stack));
        BlockState state = world.func_180495_p(pos);
        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + state.func_196954_c((IBlockReader)world, pos).func_197758_c(Direction.Axis.Y), (double)pos.func_177952_p() + 0.5);
        int y = 0;
        while (y++ < 4 && !world.func_226669_j_((Entity)entity)) {
            entity.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0, entity.func_226281_cx_());
        }
        if (!world.func_226669_j_((Entity)entity)) {
            ctx.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("error.gateways.no_space").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            return ActionResultType.FAIL;
        }
        world.func_217376_c((Entity)entity);
        entity.onGateCreated();
        if (!ctx.func_195999_j().func_184812_l_()) {
            stack.func_190918_g(1);
        }
        return ActionResultType.CONSUME;
    }

    public static void setGate(ItemStack opener, Gateway gate) {
        opener.func_196082_o().func_74778_a("gateway", gate.getId().toString());
    }

    public static Gateway getGate(ItemStack opener) {
        return (Gateway)GatewayManager.INSTANCE.getValue(new ResourceLocation(opener.func_196082_o().func_74779_i("gateway")));
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (stack.func_82837_s()) {
            return super.func_200295_i(stack);
        }
        Gateway gate = GatePearlItem.getGate(stack);
        if (gate != null) {
            return new TranslationTextComponent("gateways.gate_pearl", new Object[]{new TranslationTextComponent(gate.getId().toString().replace(':', '.'))}).func_240703_c_(Style.field_240709_b_.func_240718_a_(gate.getColor()));
        }
        return super.func_200295_i(stack);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            GatewayManager.INSTANCE.getValues().stream().sorted((g1, g2) -> g1.getId().compareTo(g2.getId())).forEach(gate -> {
                ItemStack stack = new ItemStack((IItemProvider)this);
                GatePearlItem.setGate(stack, gate);
                items.add((Object)stack);
            });
        }
    }
}

