/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.net;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.Color;
import net.minecraftforge.fml.network.NetworkEvent;
import shadows.gateways.client.ParticleHandler;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.mixin.MixinColor;
import shadows.placebo.util.NetworkUtils;

public class ParticleMessage
extends NetworkUtils.MessageProvider<ParticleMessage> {
    public int gateId;
    public double x;
    public double y;
    public double z;
    public int type;
    public int color;

    public ParticleMessage(GatewayEntity source, double x, double y, double z, Color color, int type) {
        this(source.func_145782_y(), x, y, z, ((MixinColor)color).getValue(), type);
    }

    public ParticleMessage(int id, double x, double y, double z, int color, int type) {
        this.gateId = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.color = color;
        this.type = type;
    }

    public ParticleMessage() {
    }

    public Class<ParticleMessage> getMsgClass() {
        return ParticleMessage.class;
    }

    public ParticleMessage read(PacketBuffer buf) {
        int id = buf.readInt();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        int color = buf.readInt();
        byte type = buf.readByte();
        return new ParticleMessage(id, x, y, z, color, (int)type);
    }

    public void write(ParticleMessage msg, PacketBuffer buf) {
        buf.writeInt(msg.gateId);
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        buf.writeInt(msg.color);
        buf.writeByte(msg.type);
    }

    public void handle(ParticleMessage msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkUtils.handlePacket(() -> () -> ParticleHandler.handle(msg), (NetworkEvent.Context)ctx.get());
    }
}

