/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.gate;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.gateways.entity.GatewayEntity;
import shadows.placebo.json.ItemAdapter;
import shadows.placebo.json.JsonUtil;
import shadows.placebo.json.SerializerBuilder;

public interface Failure {
    public static final Map<String, SerializerBuilder.Serializer> SERIALIZERS = new HashMap<String, SerializerBuilder.Serializer>();

    public void onFailure(ServerLevel var1, GatewayEntity var2, Player var3, GatewayEntity.FailureReason var4);

    default public JsonObject write() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", this.getName());
        return obj;
    }

    default public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.getName());
    }

    public String getName();

    public void appendHoverText(Consumer<Component> var1);

    public static Failure read(JsonObject obj) {
        String type = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
        SerializerBuilder.Serializer serializer = SERIALIZERS.get(type);
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown Failure Type: " + type);
        }
        return (Failure)serializer.read(obj);
    }

    public static Failure read(FriendlyByteBuf buf) {
        String type = buf.m_130277_();
        SerializerBuilder.Serializer serializer = SERIALIZERS.get(type);
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown Failure Type: " + type);
        }
        return (Failure)serializer.read(buf);
    }

    public static void initSerializers() {
        SERIALIZERS.put("explosion", new SerializerBuilder("Explosion Failure").autoRegister(ExplosionFailure.class).build(true));
        SERIALIZERS.put("mob_effect", new SerializerBuilder("Mob Effect Failure").autoRegister(MobEffectFailure.class).build(true));
        SERIALIZERS.put("summon", new SerializerBuilder("Summon Failure").autoRegister(SummonFailure.class).build(true));
        SERIALIZERS.put("chanced", new SerializerBuilder("Chanced Failure").autoRegister(ChancedFailure.class).build(true));
        SERIALIZERS.put("command", new SerializerBuilder("Command Failure").autoRegister(CommandFailure.class).build(true));
    }

    public record ExplosionFailure(float strength, boolean fire, boolean blockDamage) implements Failure
    {
        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            level.m_46518_((Entity)gate, gate.m_20185_(), gate.m_20186_(), gate.m_20189_(), this.strength, this.fire, this.blockDamage ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Failure.super.write();
            obj.addProperty("strength", (Number)Float.valueOf(this.strength));
            obj.addProperty("fire", Boolean.valueOf(this.fire));
            obj.addProperty("block_damage", Boolean.valueOf(this.blockDamage));
            return obj;
        }

        public static ExplosionFailure read(JsonObject obj) {
            return new ExplosionFailure(GsonHelper.m_13915_((JsonObject)obj, (String)"strength"), GsonHelper.m_13855_((JsonObject)obj, (String)"fire", (boolean)true), GsonHelper.m_13855_((JsonObject)obj, (String)"block_damage", (boolean)true));
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            Failure.super.write(buf);
            buf.writeFloat(this.strength);
            buf.writeBoolean(this.fire);
            buf.writeBoolean(this.blockDamage);
        }

        public static ExplosionFailure read(FriendlyByteBuf buf) {
            return new ExplosionFailure(buf.readFloat(), buf.readBoolean(), buf.readBoolean());
        }

        @Override
        public String getName() {
            return "explosion";
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)new TranslatableComponent("failure.gateways.explosion", new Object[]{Float.valueOf(this.strength), this.fire, this.blockDamage}));
        }
    }

    public record MobEffectFailure(MobEffect effect, int duration, int amplifier) implements Failure
    {
        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            level.m_45955_(TargetingConditions.m_148353_(), null, gate.m_142469_().m_82400_(gate.getGateway().leashRange)).forEach(p -> p.m_7292_(new MobEffectInstance(this.effect, this.duration, this.amplifier)));
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Failure.super.write();
            obj.addProperty("effect", ForgeRegistries.MOB_EFFECTS.getKey((IForgeRegistryEntry)this.effect).toString());
            obj.addProperty("duration", (Number)this.duration);
            obj.addProperty("amplifier", (Number)this.amplifier);
            return obj;
        }

        public static MobEffectFailure read(JsonObject obj) {
            return new MobEffectFailure((MobEffect)JsonUtil.getRegistryObject((JsonObject)obj, (String)"effect", (IForgeRegistry)ForgeRegistries.MOB_EFFECTS), GsonHelper.m_13927_((JsonObject)obj, (String)"duration"), GsonHelper.m_13824_((JsonObject)obj, (String)"amplifier", (int)0));
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            Failure.super.write(buf);
            buf.writeRegistryId((IForgeRegistryEntry)this.effect);
            buf.writeInt(this.duration);
            buf.writeInt(this.amplifier);
        }

        public static MobEffectFailure read(FriendlyByteBuf buf) {
            return new MobEffectFailure((MobEffect)buf.readRegistryIdSafe(MobEffect.class), buf.readInt(), buf.readInt());
        }

        @Override
        public String getName() {
            return "mob_effect";
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)new TranslatableComponent("failure.gateways.mob_effect", new Object[]{MobEffectFailure.toComponent(new MobEffectInstance(this.effect, this.duration, this.amplifier))}));
        }

        private static Component toComponent(MobEffectInstance mobeffectinstance) {
            TranslatableComponent mutablecomponent = new TranslatableComponent(mobeffectinstance.m_19576_());
            MobEffect mobeffect = mobeffectinstance.m_19544_();
            if (mobeffectinstance.m_19564_() > 0) {
                mutablecomponent = new TranslatableComponent("potion.withAmplifier", new Object[]{mutablecomponent, new TranslatableComponent("potion.potency." + mobeffectinstance.m_19564_())});
            }
            if (mobeffectinstance.m_19557_() > 20) {
                mutablecomponent = new TranslatableComponent("potion.withDuration", new Object[]{mutablecomponent, MobEffectUtil.m_19581_((MobEffectInstance)mobeffectinstance, (float)1.0f)});
            }
            return mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_());
        }
    }

    public record SummonFailure(EntityType<?> type, @Nullable CompoundTag nbt, int count) implements Failure
    {
        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            for (int i = 0; i < this.count; ++i) {
                Entity entity = this.type.m_20615_((Level)level);
                if (this.nbt != null) {
                    entity.m_20258_(this.nbt);
                }
                entity.m_7678_(gate.m_20185_(), gate.m_20186_(), gate.m_20189_(), 0.0f, 0.0f);
                level.m_7967_(entity);
            }
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Failure.super.write();
            obj.addProperty("entity", ForgeRegistries.ENTITIES.getKey(this.type).toString());
            if (this.nbt != null) {
                obj.add("nbt", ItemAdapter.ITEM_READER.toJsonTree((Object)this.nbt));
            }
            obj.addProperty("count", (Number)this.count);
            return obj;
        }

        public static SummonFailure read(JsonObject obj) {
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(obj.get("entity").getAsString()));
            CompoundTag tag = obj.has("nbt") ? (CompoundTag)ItemAdapter.ITEM_READER.fromJson(obj.get("nbt"), CompoundTag.class) : null;
            int count = GsonHelper.m_13927_((JsonObject)obj, (String)"count");
            return new SummonFailure(type, tag, count);
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            Failure.super.write(buf);
            buf.writeRegistryId(this.type);
            buf.m_130079_(this.nbt == null ? new CompoundTag() : this.nbt);
            buf.m_130130_(this.count);
        }

        public static SummonFailure read(FriendlyByteBuf buf) {
            EntityType type = (EntityType)buf.readRegistryIdSafe(EntityType.class);
            CompoundTag tag = buf.m_130260_();
            int count = buf.m_130242_();
            return new SummonFailure(type, tag, count);
        }

        @Override
        public String getName() {
            return "summon";
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)new TranslatableComponent("failure.gateways.summon", new Object[]{this.count, new TranslatableComponent(this.type.m_20675_())}));
        }
    }

    public record ChancedFailure(Failure failure, float chance) implements Failure
    {
        static DecimalFormat fmt = new DecimalFormat("##.##%");

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            if (level.f_46441_.nextFloat() < this.chance) {
                this.failure.onFailure(level, gate, summoner, reason);
            }
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Failure.super.write();
            obj.addProperty("chance", (Number)Float.valueOf(this.chance));
            obj.add("failure", (JsonElement)this.failure.write());
            return obj;
        }

        public static ChancedFailure read(JsonObject obj) {
            float chance = GsonHelper.m_13915_((JsonObject)obj, (String)"chance");
            Failure reward = Failure.read(GsonHelper.m_13930_((JsonObject)obj, (String)"failure"));
            return new ChancedFailure(reward, chance);
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            Failure.super.write(buf);
            buf.writeFloat(this.chance);
            this.failure.write(buf);
        }

        public static ChancedFailure read(FriendlyByteBuf buf) {
            float chance = buf.readFloat();
            Failure reward = Failure.read(buf);
            return new ChancedFailure(reward, chance);
        }

        @Override
        public String getName() {
            return "chanced";
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            this.failure.appendHoverText(c -> list.accept((Component)new TranslatableComponent("failure.gateways.chance", new Object[]{fmt.format(this.chance * 100.0f), c})));
        }
    }

    public record CommandFailure(String command, String desc) implements Failure
    {
        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            String realCmd = this.command.replace("<summoner>", summoner.m_36316_().getName());
            level.m_142572_().m_129892_().m_82117_(gate.m_20203_(), realCmd);
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Failure.super.write();
            obj.addProperty("command", this.command);
            return obj;
        }

        public static CommandFailure read(JsonObject obj) {
            return new CommandFailure(GsonHelper.m_13906_((JsonObject)obj, (String)"command"), GsonHelper.m_13906_((JsonObject)obj, (String)"desc"));
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            Failure.super.write(buf);
            buf.m_130070_(this.desc);
        }

        public static CommandFailure read(FriendlyByteBuf buf) {
            return new CommandFailure("", buf.m_130277_());
        }

        @Override
        public String getName() {
            return "command";
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)new TranslatableComponent(this.desc));
        }
    }

    public static class Serializer
    implements JsonDeserializer<Failure>,
    JsonSerializer<Failure> {
        public JsonElement serialize(Failure src, Type typeOfSrc, JsonSerializationContext context) {
            return src.write();
        }

        public Failure deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Failure.read(json.getAsJsonObject());
        }
    }
}

