/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.item;

import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.gate.Gateway;
import shadows.gateways.gate.GatewayManager;

public class GatePearlItem
extends Item {
    public GatePearlItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        ItemStack stack = ctx.m_43722_();
        BlockPos pos = ctx.m_8083_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!world.m_45976_(GatewayEntity.class, new AABB(pos).m_82377_(25.0, 25.0, 25.0)).isEmpty()) {
            return InteractionResult.FAIL;
        }
        GatewayEntity entity = new GatewayEntity(world, ctx.m_43723_(), GatePearlItem.getGate(stack));
        BlockState state = world.m_8055_(pos);
        entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + state.m_60808_((BlockGetter)world, pos).m_83297_(Direction.Axis.Y), (double)pos.m_123343_() + 0.5);
        int y = 0;
        while (y++ < 4 && !world.m_45786_((Entity)entity)) {
            entity.m_6034_(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_());
        }
        if (!world.m_45786_((Entity)entity)) {
            ctx.m_43723_().m_6352_((Component)new TranslatableComponent("error.gateways.no_space").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return InteractionResult.FAIL;
        }
        world.m_7967_((Entity)entity);
        entity.onGateCreated();
        if (!ctx.m_43723_().m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResult.CONSUME;
    }

    public static void setGate(ItemStack opener, Gateway gate) {
        opener.m_41784_().m_128359_("gateway", gate.getId().toString());
    }

    public static Gateway getGate(ItemStack opener) {
        return (Gateway)GatewayManager.INSTANCE.getValue(new ResourceLocation(opener.m_41784_().m_128461_("gateway")));
    }

    public Component m_7626_(ItemStack stack) {
        if (stack.m_41788_()) {
            return super.m_7626_(stack);
        }
        Gateway gate = GatePearlItem.getGate(stack);
        if (gate != null) {
            return new TranslatableComponent("gateways.gate_pearl", new Object[]{new TranslatableComponent(gate.getId().toString().replace(':', '.'))}).m_130948_(Style.f_131099_.m_131148_(gate.getColor()));
        }
        return super.m_7626_(stack);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            GatewayManager.INSTANCE.getValues().stream().sorted((g1, g2) -> g1.getId().compareTo(g2.getId())).forEach(gate -> {
                ItemStack stack = new ItemStack((ItemLike)this);
                GatePearlItem.setGate(stack, gate);
                items.add((Object)stack);
            });
        }
    }

    public static interface IGateSupplier {
        public GatewayEntity createGate(Level var1, Player var2, Gateway var3);
    }
}

