/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.json;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import shadows.placebo.json.PlaceboJsonReloadListener;

public class DynamicRegistryObject<T>
implements Supplier<T> {
    protected final ResourceLocation id;
    protected final PlaceboJsonReloadListener<? super T> manager;
    protected T object;

    public DynamicRegistryObject(ResourceLocation id, PlaceboJsonReloadListener<? super T> manager) {
        this.id = id;
        this.manager = manager;
    }

    @Override
    public T get() {
        return this.object == null ? (this.object = this.manager.getValue(this.id)) : this.object;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isPresent() {
        return this.object != null || this.manager.getValue(this.id) != null;
    }

    public void invalidate() {
        this.object = null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.get());
        }
    }
}

