/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.gateways.GatewayObjects;
import shadows.gateways.client.GatewayParticleData;
import shadows.gateways.client.GatewayTickableSound;
import shadows.gateways.command.GatewayCommand;
import shadows.gateways.entity.GatewayEntity;
import shadows.gateways.gate.Failure;
import shadows.gateways.gate.GatewayManager;
import shadows.gateways.gate.Reward;
import shadows.gateways.gate.WaveEntity;
import shadows.gateways.item.GatePearlItem;
import shadows.gateways.net.ParticleMessage;
import shadows.gateways.recipe.GatewayRecipeSerializer;
import shadows.placebo.network.MessageHelper;
import shadows.placebo.network.MessageProvider;

@Mod(value="gateways")
public class Gateways {
    public static final String MODID = "gateways";
    public static final Logger LOGGER = LogManager.getLogger((String)"Gateways to Eternity");
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("gateways", "channel")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
    public static final CreativeModeTab TAB = new CreativeModeTab("gateways"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)GatewayObjects.GATE_PEARL.get());
        }
    };

    public Gateways() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MessageHelper.registerMessage((SimpleChannel)CHANNEL, (int)0, (MessageProvider)new ParticleMessage());
        MinecraftForge.EVENT_BUS.addListener(this::commands);
        MinecraftForge.EVENT_BUS.addListener(this::teleport);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        GatewayManager.INSTANCE.registerToBus();
        Reward.initSerializers();
        WaveEntity.initSerializers();
        Failure.initSerializers();
    }

    @SubscribeEvent
    public void register(RegisterEvent e) {
        if (e.getForgeRegistry() == ForgeRegistries.ITEMS) {
            this.registerItems();
        }
        if (e.getForgeRegistry() == ForgeRegistries.ENTITY_TYPES) {
            this.registerEntities();
        }
        if (e.getForgeRegistry() == ForgeRegistries.RECIPE_SERIALIZERS) {
            this.registerSerializers();
        }
        if (e.getForgeRegistry() == ForgeRegistries.SOUND_EVENTS) {
            this.registerSounds();
        }
        if (e.getForgeRegistry() == ForgeRegistries.PARTICLE_TYPES) {
            this.registerParticles();
        }
    }

    public void registerEntities() {
        ForgeRegistries.ENTITY_TYPES.register("gateway", (Object)EntityType.Builder.m_20704_(GatewayEntity::new, (MobCategory)MobCategory.MISC).setTrackingRange(5).setUpdateInterval(20).m_20699_(2.0f, 3.0f).setCustomClientFactory((se, w) -> {
            GatewayEntity ent = new GatewayEntity((EntityType<?>)((EntityType)GatewayObjects.GATEWAY.get()), (Level)w);
            GatewayTickableSound.startGatewaySound(ent);
            return ent;
        }).m_20712_("gateway"));
    }

    public void registerItems() {
        ForgeRegistries.ITEMS.register("gate_pearl", (Object)new GatePearlItem(new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON).m_41491_(TAB)));
        Gateways.registerStat(GatewayObjects.Stats.STAT_GATES_DEFEATED, StatFormatter.f_12873_);
    }

    public void registerSerializers() {
        ForgeRegistries.RECIPE_SERIALIZERS.register("gate_recipe", (Object)GatewayRecipeSerializer.INSTANCE);
    }

    public void registerSounds() {
        for (String s : new String[]{"gate_warp", "gate_ambient", "gate_start", "gate_end"}) {
            ForgeRegistries.SOUND_EVENTS.register(s, (Object)new SoundEvent(Gateways.loc(s)));
        }
    }

    private static ResourceLocation loc(String s) {
        return new ResourceLocation(MODID, s);
    }

    public void registerParticles() {
        ForgeRegistries.PARTICLE_TYPES.register("glow", (Object)new ParticleType<GatewayParticleData>(false, GatewayParticleData.DESERIALIZER){

            public Codec<GatewayParticleData> m_7652_() {
                return GatewayParticleData.CODEC;
            }
        });
    }

    public void commands(RegisterCommandsEvent e) {
        GatewayCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    private static void registerStat(ResourceLocation id, StatFormatter pFormatter) {
        Registry.m_122965_((Registry)Registry.f_122832_, (ResourceLocation)id, (Object)id);
        Stats.f_12988_.m_12899_((Object)id, pFormatter);
    }

    public void teleport(EntityTeleportEvent e) {
        Entity entity = e.getEntity();
        if (entity.getPersistentData().m_128441_("gateways.owner")) {
            GatewayEntity gate;
            ServerLevel sl;
            UUID id = entity.getPersistentData().m_128342_("gateways.owner");
            Level level = entity.f_19853_;
            if (level instanceof ServerLevel && (level = (sl = (ServerLevel)level).m_8791_(id)) instanceof GatewayEntity && (gate = (GatewayEntity)level).m_20275_(e.getTargetX(), e.getTargetY(), e.getTargetZ()) >= gate.getGateway().getLeashRangeSq()) {
                e.setTargetX(gate.m_20185_() + 0.5 * (double)gate.m_20205_());
                e.setTargetY(gate.m_20186_() + 0.5 * (double)gate.m_20206_());
                e.setTargetZ(gate.m_20189_() + 0.5 * (double)gate.m_20205_());
            }
        }
    }
}

