/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.entity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.simple.SimpleChannel;
import shadows.gateways.GatewayObjects;
import shadows.gateways.Gateways;
import shadows.gateways.client.ParticleHandler;
import shadows.gateways.event.GateEvent;
import shadows.gateways.gate.Gateway;
import shadows.gateways.gate.GatewayManager;
import shadows.gateways.gate.Wave;
import shadows.gateways.net.ParticleMessage;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.network.PacketDistro;

public class GatewayEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<Boolean> WAVE_ACTIVE = SynchedEntityData.m_135353_(GatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> TICKS_ACTIVE = SynchedEntityData.m_135353_(GatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> WAVE = SynchedEntityData.m_135353_(GatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ENEMIES = SynchedEntityData.m_135353_(GatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected Gateway gate;
    protected ServerBossEvent bossEvent;
    protected final Set<LivingEntity> currentWaveEntities = new HashSet<LivingEntity>();
    protected final Set<UUID> unresolvedWaveEntities = new HashSet<UUID>();
    protected UUID summonerId;
    protected float clientScale = 0.0f;
    protected Queue<ItemStack> undroppedItems = new ArrayDeque<ItemStack>();
    protected FailureReason failureReason;

    public GatewayEntity(Level level, Player placer, Gateway gate) {
        super((EntityType)GatewayObjects.GATEWAY.get(), level);
        this.summonerId = placer.m_20148_();
        this.gate = gate;
        this.m_6593_((Component)Component.m_237115_((String)gate.getId().toString().replace(':', '.')).m_130948_(Style.f_131099_.m_131148_(gate.getColor())));
        this.bossEvent = this.createBossEvent();
        this.m_6210_();
    }

    public GatewayEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return this.gate.getSize().dims;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (!this.unresolvedWaveEntities.isEmpty()) {
                for (UUID id : this.unresolvedWaveEntities) {
                    Entity e2 = ((ServerLevel)this.f_19853_).m_8791_(id);
                    if (!(e2 instanceof LivingEntity)) continue;
                    this.currentWaveEntities.add((LivingEntity)e2);
                }
                this.unresolvedWaveEntities.clear();
            }
            if (this.isWaveActive()) {
                int maxWaveTime = this.getCurrentWave().maxWaveTime();
                if (this.getTicksActive() > maxWaveTime) {
                    this.onFailure(this.currentWaveEntities, FailureReason.TIMER_ELAPSED);
                    return;
                }
                this.f_19804_.m_135381_(TICKS_ACTIVE, (Object)(this.getTicksActive() + 1));
            }
            boolean active = this.isWaveActive();
            List<LivingEntity> enemies = this.currentWaveEntities.stream().filter(e -> e.m_21223_() > 0.0f && e.m_146911_() != Entity.RemovalReason.KILLED).toList();
            for (LivingEntity entity : enemies) {
                if (this.isOutOfRange((Entity)entity)) {
                    this.onFailure(this.currentWaveEntities, FailureReason.ENTITY_TOO_FAR);
                    return;
                }
                if (entity.f_19797_ % 20 != 0) continue;
                this.spawnParticle(this.gate.getColor(), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 0);
            }
            this.f_19804_.m_135381_(ENEMIES, (Object)enemies.size());
            if (active && enemies.size() == 0) {
                this.onWaveEnd(this.getCurrentWave());
                this.currentWaveEntities.clear();
                this.f_19804_.m_135381_(WAVE_ACTIVE, (Object)false);
                this.f_19804_.m_135381_(TICKS_ACTIVE, (Object)0);
                this.f_19804_.m_135381_(WAVE, (Object)Math.min(this.getWave() + 1, this.gate.getNumWaves()));
            } else if (!active && !this.isLastWave()) {
                if (this.getTicksActive() > this.getCurrentWave().setupTime()) {
                    this.spawnWave();
                    return;
                }
                this.f_19804_.m_135381_(TICKS_ACTIVE, (Object)(this.getTicksActive() + 1));
            }
            if (this.f_19797_ % 4 == 0 && !this.undroppedItems.isEmpty()) {
                for (int i = 0; i < this.getDropCount(); ++i) {
                    this.spawnItem(this.undroppedItems.remove());
                    if (this.undroppedItems.isEmpty()) break;
                }
            }
            if (!active && this.undroppedItems.isEmpty() && this.isLastWave()) {
                this.completePortal();
            }
        } else if (this.f_19797_ % 20 == 0) {
            ParticleHandler.spawnIdleParticles(this);
        }
    }

    protected int getDropCount() {
        return 3 + this.undroppedItems.size() / 100;
    }

    public boolean isLastWave() {
        return this.getWave() == this.gate.getNumWaves();
    }

    public Wave getCurrentWave() {
        return this.gate.getWave(Math.min(this.gate.getNumWaves() - 1, this.getWave()));
    }

    public void spawnWave() {
        BlockPos blockpos = this.m_20183_();
        List<LivingEntity> spawned = this.gate.getWave(this.getWave()).spawnWave((ServerLevel)this.f_19853_, blockpos, this);
        this.currentWaveEntities.addAll(spawned);
        this.f_19804_.m_135381_(WAVE_ACTIVE, (Object)true);
        this.f_19804_.m_135381_(TICKS_ACTIVE, (Object)0);
        this.f_19804_.m_135381_(ENEMIES, (Object)this.currentWaveEntities.size());
    }

    protected void completePortal() {
        int i;
        for (int completionXp = this.gate.getCompletionXp(); completionXp > 0; completionXp -= i) {
            i = 5;
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), i));
        }
        Player player = this.summonerOrClosest();
        this.gate.getRewards().forEach(r -> r.generateLoot((ServerLevel)this.f_19853_, this, player, this::spawnCompletionItem));
        this.bossEvent.m_7006_(false);
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_5496_((SoundEvent)GatewayObjects.GATE_END.get(), 1.0f, 1.0f);
        this.f_19853_.m_45955_(TargetingConditions.f_26872_, null, this.m_20191_().m_82400_(15.0)).forEach(p -> p.m_36220_(GatewayObjects.Stats.STAT_GATES_DEFEATED));
        MinecraftForge.EVENT_BUS.post((Event)new GateEvent.Completed(this));
    }

    public void onGateCreated() {
        this.m_5496_((SoundEvent)GatewayObjects.GATE_START.get(), 1.0f, 1.0f);
        MinecraftForge.EVENT_BUS.post((Event)new GateEvent.Opened(this));
    }

    protected void onWaveEnd(Wave wave) {
        Player player = this.summonerOrClosest();
        this.undroppedItems.addAll(wave.spawnRewards((ServerLevel)this.f_19853_, this, player));
    }

    public Player summonerOrClosest() {
        Player player;
        Player player2 = player = this.summonerId == null ? null : this.f_19853_.m_46003_(this.summonerId);
        if (player == null) {
            player = this.f_19853_.m_45930_((Entity)this, 50.0);
        }
        if (player == null) {
            return this.summonerId == null ? FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.f_19853_)) : FakePlayerFactory.get((ServerLevel)((ServerLevel)this.f_19853_), (GameProfile)new GameProfile(this.summonerId, ""));
        }
        return player;
    }

    public void onFailure(Collection<LivingEntity> remaining, FailureReason reason) {
        this.failureReason = reason;
        MinecraftForge.EVENT_BUS.post((Event)new GateEvent.Failed(this));
        Player player = this.summonerOrClosest();
        if (player != null) {
            player.m_213846_(reason.getMsg());
        }
        GatewayEntity.spawnLightningOn(this, false);
        remaining.stream().filter(Entity::m_6084_).forEach(e -> GatewayEntity.spawnLightningOn((Entity)e, true));
        remaining.forEach(e -> e.m_142687_(Entity.RemovalReason.DISCARDED));
        this.getGateway().getFailures().forEach(f -> f.onFailure((ServerLevel)this.f_19853_, this, player, reason));
        this.bossEvent.m_7006_(false);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected ServerBossEvent createBossEvent() {
        ServerBossEvent event = new ServerBossEvent((Component)Component.m_237113_((String)("GATEWAY_ID" + this.m_19879_())), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
        event.m_7006_(true);
        return event;
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("wave", this.getWave());
        tag.m_128359_("gate", this.gate.getId().toString());
        long[] ids = new long[this.currentWaveEntities.size() * 2];
        int idx = 0;
        for (LivingEntity e : this.currentWaveEntities) {
            UUID id = e.m_20148_();
            ids[idx++] = id.getMostSignificantBits();
            ids[idx++] = id.getLeastSignificantBits();
        }
        tag.m_128388_("wave_entities", ids);
        tag.m_128379_("active", this.isWaveActive());
        tag.m_128405_("ticks_active", this.getTicksActive());
        if (this.summonerId != null) {
            tag.m_128362_("summoner", this.summonerId);
        }
        ListTag stacks = new ListTag();
        for (ItemStack s : this.undroppedItems) {
            stacks.add((Object)s.serializeNBT());
        }
        tag.m_128365_("queued_stacks", (Tag)stacks);
    }

    protected void m_7378_(CompoundTag tag) {
        this.f_19804_.m_135381_(WAVE, (Object)tag.m_128451_("wave"));
        this.gate = (Gateway)GatewayManager.INSTANCE.getOrDefault(new ResourceLocation(tag.m_128461_("gate")), (PlaceboJsonReloadListener.TypeKeyed)this.gate);
        if (this.gate == null) {
            Gateways.LOGGER.error("Invalid gateway at {} will be removed.", (Object)this.m_20182_());
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        long[] entities = tag.m_128467_("wave_entities");
        for (int i = 0; i < entities.length; i += 2) {
            this.unresolvedWaveEntities.add(new UUID(entities[i], entities[i + 1]));
        }
        this.f_19804_.m_135381_(WAVE_ACTIVE, (Object)tag.m_128471_("active"));
        this.f_19804_.m_135381_(TICKS_ACTIVE, (Object)tag.m_128451_("ticks_active"));
        if (tag.m_128441_("summoner")) {
            this.summonerId = tag.m_128342_("summoner");
        }
        ListTag stacks = tag.m_128437_("queued_stacks", 10);
        for (Tag inbt : stacks) {
            this.undroppedItems.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)inbt)));
        }
        this.bossEvent = this.createBossEvent();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(WAVE_ACTIVE, (Object)false);
        this.f_19804_.m_135372_(TICKS_ACTIVE, (Object)0);
        this.f_19804_.m_135372_(WAVE, (Object)0);
        this.f_19804_.m_135372_(ENEMIES, (Object)0);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    public int getTicksActive() {
        return (Integer)this.f_19804_.m_135370_(TICKS_ACTIVE);
    }

    public boolean isWaveActive() {
        return (Boolean)this.f_19804_.m_135370_(WAVE_ACTIVE);
    }

    public int getWave() {
        return (Integer)this.f_19804_.m_135370_(WAVE);
    }

    public int getActiveEnemies() {
        return (Integer)this.f_19804_.m_135370_(ENEMIES);
    }

    public Gateway getGateway() {
        return this.gate;
    }

    public ServerBossEvent getBossInfo() {
        return this.bossEvent;
    }

    public float getClientScale() {
        return this.clientScale;
    }

    public void setClientScale(float clientScale) {
        this.clientScale = clientScale;
    }

    public static void spawnLightningOn(Entity entity, boolean effectOnly) {
        LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(entity.f_19853_);
        bolt.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        bolt.m_20874_(effectOnly);
        entity.f_19853_.m_7967_((Entity)bolt);
    }

    public void spawnParticle(TextColor color, double x, double y, double z, int type) {
        PacketDistro.sendToTracking((SimpleChannel)Gateways.CHANNEL, (Object)new ParticleMessage(this, x, y, z, color, type), (ServerLevel)((ServerLevel)this.f_19853_), (BlockPos)new BlockPos((int)x, (int)y, (int)z));
    }

    public void spawnItem(ItemStack stack) {
        ItemEntity i = new ItemEntity(this.f_19853_, 0.0, 0.0, 0.0, stack);
        i.m_6034_(this.m_20185_() + Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.5, (double)0.5), this.m_20186_() + 1.5, this.m_20189_() + Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.5, (double)0.5));
        i.m_20334_(Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.15, (double)0.15), 0.4, Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.15, (double)0.15));
        this.f_19853_.m_7967_((Entity)i);
        this.f_19853_.m_6263_(null, i.m_20185_(), i.m_20186_(), i.m_20189_(), (SoundEvent)GatewayObjects.GATE_WARP.get(), SoundSource.HOSTILE, 0.25f, 2.0f);
    }

    public void spawnCompletionItem(ItemStack stack) {
        ItemEntity i = new ItemEntity(this.f_19853_, 0.0, 0.0, 0.0, stack);
        double variance = 0.05f * this.gate.getSize().getScale();
        i.m_6034_(this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_());
        i.m_20334_(Mth.m_216263_((RandomSource)this.f_19796_, (double)(-variance), (double)variance), (double)(this.m_20206_() / 20.0f), Mth.m_216263_((RandomSource)this.f_19796_, (double)(-variance), (double)variance));
        i.m_149678_();
        this.f_19853_.m_7967_((Entity)i);
    }

    public void writeSpawnData(FriendlyByteBuf buf) {
        buf.m_130085_(this.gate.getId());
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        this.gate = (Gateway)GatewayManager.INSTANCE.getValue(buf.m_130281_());
        if (this.gate == null) {
            throw new RuntimeException("Invalid gateway received on client!");
        }
    }

    protected int m_8088_() {
        return 2;
    }

    @Nullable
    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    public boolean isOutOfRange(Entity entity) {
        return entity.m_20280_((Entity)this) > this.gate.getLeashRangeSq() || entity.m_146911_() == Entity.RemovalReason.CHANGED_DIMENSION;
    }

    public static enum GatewaySize {
        SMALL(EntityDimensions.m_20395_((float)2.0f, (float)3.0f), 1.0f),
        MEDIUM(EntityDimensions.m_20395_((float)4.0f, (float)6.0f), 2.0f),
        LARGE(EntityDimensions.m_20395_((float)6.0f, (float)9.0f), 3.0f);

        private final EntityDimensions dims;
        private final float scale;

        private GatewaySize(EntityDimensions dims, float scale) {
            this.dims = dims;
            this.scale = scale;
        }

        public float getScale() {
            return this.scale;
        }
    }

    public static enum FailureReason {
        SPAWN_FAILED("error.gateways.wave_failed"),
        ENTITY_TOO_FAR("error.gateways.too_far"),
        TIMER_ELAPSED("error.gateways.wave_elapsed");

        private final String langKey;

        private FailureReason(String langKey) {
            this.langKey = langKey;
        }

        public Component getMsg() {
            return Component.m_237115_((String)this.langKey).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.UNDERLINE});
        }
    }
}

