/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.gate;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.gateways.entity.GatewayEntity;
import shadows.placebo.json.ItemAdapter;
import shadows.placebo.json.PSerializer;

public interface Reward {
    public static final Method dropFromLootTable = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_7625_", (Class[])new Class[]{DamageSource.class, Boolean.TYPE});
    public static final MethodHandle DROP_LOOT = Reward.lootMethodHandle();
    public static final Map<String, PSerializer<? extends Reward>> SERIALIZERS = new HashMap<String, PSerializer<? extends Reward>>();

    public void generateLoot(ServerLevel var1, GatewayEntity var2, Player var3, Consumer<ItemStack> var4);

    default public JsonObject write() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", this.getName());
        return obj;
    }

    default public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.getName());
    }

    public String getName();

    public void appendHoverText(Consumer<Component> var1);

    public static Reward read(JsonObject obj) {
        String type = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
        PSerializer<? extends Reward> serializer = SERIALIZERS.get(type);
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown Reward Type: " + type);
        }
        return (Reward)serializer.read((JsonElement)obj);
    }

    public static Reward read(FriendlyByteBuf buf) {
        String type = buf.m_130277_();
        PSerializer<? extends Reward> serializer = SERIALIZERS.get(type);
        if (serializer == null) {
            throw new JsonSyntaxException("Unknown Reward Type: " + type);
        }
        return (Reward)serializer.read(buf);
    }

    public static void initSerializers() {
        SERIALIZERS.put("stack", (PSerializer<? extends Reward>)PSerializer.autoRegister((String)"Stack Reward", StackReward.class).build(true));
        SERIALIZERS.put("stack_list", (PSerializer<? extends Reward>)PSerializer.autoRegister((String)"Stack List Reward", StackListReward.class).build(true));
        SERIALIZERS.put("entity_loot", (PSerializer<? extends Reward>)PSerializer.autoRegister((String)"Entity Loot Reward", EntityLootReward.class).build(true));
        SERIALIZERS.put("loot_table", (PSerializer<? extends Reward>)PSerializer.autoRegister((String)"Loot Table Reward", LootTableReward.class).build(true));
        SERIALIZERS.put("chanced", (PSerializer<? extends Reward>)PSerializer.autoRegister((String)"Chanced Reward", ChancedReward.class).build(true));
        SERIALIZERS.put("command", (PSerializer<? extends Reward>)PSerializer.autoRegister((String)"Command Reward", CommandReward.class).build(true));
    }

    private static MethodHandle lootMethodHandle() {
        dropFromLootTable.setAccessible(true);
        try {
            return MethodHandles.lookup().unreflect(dropFromLootTable);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public record StackReward(ItemStack stack) implements Reward
    {
        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            list.accept(this.stack.m_41777_());
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Reward.super.write();
            obj.add("stack", ItemAdapter.ITEM_READER.toJsonTree((Object)this.stack));
            return obj;
        }

        public static StackReward read(JsonObject obj) {
            return new StackReward((ItemStack)ItemAdapter.ITEM_READER.fromJson(obj.get("stack"), ItemStack.class));
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            Reward.super.write(buf);
            buf.m_130055_(this.stack);
        }

        public static StackReward read(FriendlyByteBuf buf) {
            return new StackReward(buf.m_130267_());
        }

        @Override
        public String getName() {
            return "stack";
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)Component.m_237110_((String)"reward.gateways.stack", (Object[])new Object[]{this.stack.m_41613_(), this.stack.m_41611_()}));
        }
    }

    public record StackListReward(List<ItemStack> stacks) implements Reward
    {
        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            this.stacks.forEach(s -> list.accept(s.m_41777_()));
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Reward.super.write();
            obj.add("stacks", ItemAdapter.ITEM_READER.toJsonTree(this.stacks));
            return obj;
        }

        public static StackListReward read(JsonObject obj) {
            return new StackListReward((List)ItemAdapter.ITEM_READER.fromJson(obj.get("stacks"), new TypeToken<List<ItemStack>>(){}.getType()));
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            Reward.super.write(buf);
            buf.m_130130_(this.stacks.size());
            this.stacks.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130055_(arg_0));
        }

        public static StackListReward read(FriendlyByteBuf buf) {
            NonNullList stacks = NonNullList.m_122780_((int)buf.m_130242_(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < stacks.size(); ++i) {
                stacks.set(i, (Object)buf.m_130267_());
            }
            return new StackListReward((List<ItemStack>)stacks);
        }

        @Override
        public String getName() {
            return "stack_list";
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            for (ItemStack stack : this.stacks) {
                list.accept((Component)Component.m_237110_((String)"reward.gateways.stack", (Object[])new Object[]{stack.m_41613_(), stack.m_41611_()}));
            }
        }
    }

    public record EntityLootReward(EntityType<?> type, @Nullable CompoundTag nbt, int rolls) implements Reward
    {
        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            try {
                ArrayList items = new ArrayList();
                Entity entity = this.type.m_20615_((Level)level);
                entity.getPersistentData().m_128379_("apoth.no_pinata", true);
                for (int i = 0; i < this.rolls; ++i) {
                    if (this.nbt != null) {
                        entity.m_20258_(this.nbt);
                    }
                    entity.m_7678_(summoner.m_20185_(), summoner.m_20186_(), summoner.m_20189_(), 0.0f, 0.0f);
                    entity.m_6469_(DamageSource.m_19344_((Player)summoner).m_19382_().m_19381_().m_19380_(), 1.0f);
                    entity.captureDrops(items);
                    DROP_LOOT.invoke(entity, DamageSource.m_19344_((Player)summoner), true);
                }
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                items.stream().map(ItemEntity::m_32055_).forEach(list);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Reward.super.write();
            obj.addProperty("entity", ForgeRegistries.ENTITY_TYPES.getKey(this.type).toString());
            if (this.nbt != null) {
                obj.add("nbt", ItemAdapter.ITEM_READER.toJsonTree((Object)this.nbt));
            }
            obj.addProperty("rolls", (Number)this.rolls);
            return obj;
        }

        public static EntityLootReward read(JsonObject obj) {
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(obj.get("entity").getAsString()));
            CompoundTag tag = obj.has("nbt") ? (CompoundTag)ItemAdapter.ITEM_READER.fromJson(obj.get("nbt"), CompoundTag.class) : null;
            int rolls = GsonHelper.m_13927_((JsonObject)obj, (String)"rolls");
            return new EntityLootReward(type, tag, rolls);
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            Reward.super.write(buf);
            buf.writeRegistryId(ForgeRegistries.ENTITY_TYPES, this.type);
            buf.m_130079_(this.nbt == null ? new CompoundTag() : this.nbt);
            buf.m_130130_(this.rolls);
        }

        public static EntityLootReward read(FriendlyByteBuf buf) {
            EntityType type = (EntityType)buf.readRegistryIdSafe(EntityType.class);
            CompoundTag tag = buf.m_130260_();
            int rolls = buf.m_130242_();
            return new EntityLootReward(type, tag, rolls);
        }

        @Override
        public String getName() {
            return "entity_loot";
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)Component.m_237110_((String)"reward.gateways.entity", (Object[])new Object[]{this.rolls, Component.m_237115_((String)this.type.m_20675_())}));
        }
    }

    public record LootTableReward(ResourceLocation table, int rolls) implements Reward
    {
        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            LootTable realTable = level.m_7654_().m_129898_().m_79217_(this.table);
            for (int i = 0; i < this.rolls; ++i) {
                LootContext.Builder ctx = new LootContext.Builder(level).m_78972_(LootContextParams.f_81460_, (Object)gate.m_20318_(1.0f)).m_78965_((long)(gate.f_19797_ + i));
                ctx.m_78963_(summoner.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)summoner).m_78972_(LootContextParams.f_81463_, (Object)summoner.m_21205_());
                realTable.m_230922_(ctx.m_78975_(LootContextParamSets.f_81411_)).forEach(list);
            }
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Reward.super.write();
            obj.addProperty("loot_table", this.table.toString());
            obj.addProperty("rolls", (Number)this.rolls);
            return obj;
        }

        public static LootTableReward read(JsonObject obj) {
            return new LootTableReward(new ResourceLocation(GsonHelper.m_13906_((JsonObject)obj, (String)"loot_table")), GsonHelper.m_13927_((JsonObject)obj, (String)"rolls"));
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            Reward.super.write(buf);
            buf.m_130085_(this.table);
            buf.writeInt(this.rolls);
        }

        public static LootTableReward read(FriendlyByteBuf buf) {
            return new LootTableReward(buf.m_130281_(), buf.readInt());
        }

        @Override
        public String getName() {
            return "loot_table";
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)Component.m_237110_((String)"reward.gateways.loot_table", (Object[])new Object[]{this.rolls, this.table}));
        }
    }

    public record ChancedReward(Reward reward, float chance) implements Reward
    {
        static DecimalFormat fmt = new DecimalFormat("##.##%");

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            if (level.f_46441_.m_188501_() < this.chance) {
                this.reward.generateLoot(level, gate, summoner, list);
            }
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Reward.super.write();
            obj.addProperty("chance", (Number)Float.valueOf(this.chance));
            obj.add("reward", (JsonElement)this.reward.write());
            return obj;
        }

        public static ChancedReward read(JsonObject obj) {
            float chance = GsonHelper.m_13915_((JsonObject)obj, (String)"chance");
            Reward reward = Reward.read(GsonHelper.m_13930_((JsonObject)obj, (String)"reward"));
            return new ChancedReward(reward, chance);
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            Reward.super.write(buf);
            buf.writeFloat(this.chance);
            this.reward.write(buf);
        }

        public static ChancedReward read(FriendlyByteBuf buf) {
            float chance = buf.readFloat();
            Reward reward = Reward.read(buf);
            return new ChancedReward(reward, chance);
        }

        @Override
        public String getName() {
            return "chanced";
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            this.reward.appendHoverText(c -> list.accept((Component)Component.m_237110_((String)"reward.gateways.chance", (Object[])new Object[]{fmt.format(this.chance), c})));
        }
    }

    public record CommandReward(String command, String desc) implements Reward
    {
        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            String realCmd = this.command.replace("<summoner>", summoner.m_36316_().getName());
            level.m_7654_().m_129892_().m_230957_(gate.m_20203_(), realCmd);
        }

        @Override
        public JsonObject write() {
            JsonObject obj = Reward.super.write();
            obj.addProperty("command", this.command);
            return obj;
        }

        public static CommandReward read(JsonObject obj) {
            return new CommandReward(GsonHelper.m_13906_((JsonObject)obj, (String)"command"), GsonHelper.m_13906_((JsonObject)obj, (String)"desc"));
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            Reward.super.write(buf);
            buf.m_130070_(this.desc);
        }

        public static CommandReward read(FriendlyByteBuf buf) {
            return new CommandReward("", buf.m_130277_());
        }

        @Override
        public String getName() {
            return "command";
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)Component.m_237115_((String)this.desc));
        }
    }

    public static class Serializer
    implements JsonDeserializer<Reward>,
    JsonSerializer<Reward> {
        public JsonElement serialize(Reward src, Type typeOfSrc, JsonSerializationContext context) {
            return src.write();
        }

        public Reward deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Reward.read(json.getAsJsonObject());
        }
    }
}

