/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.gate;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonObject;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import shadows.placebo.json.ItemAdapter;
import shadows.placebo.json.JsonUtil;
import shadows.placebo.json.PSerializer;
import shadows.placebo.json.PlaceboJsonReloadListener;

public interface WaveEntity {
    public static final BiMap<ResourceLocation, PSerializer<WaveEntity>> SERIALIZERS = HashBiMap.create();

    public LivingEntity createEntity(Level var1);

    public Component getDescription();

    public AABB getAABB(double var1, double var3, double var5);

    public boolean shouldFinalizeSpawn();

    public PSerializer<WaveEntity> getSerializer();

    public static void initSerializers() {
        SERIALIZERS.put((Object)PlaceboJsonReloadListener.DEFAULT, StandardWaveEntity.SERIALIZER);
    }

    public static class StandardWaveEntity
    implements WaveEntity {
        static final PSerializer<WaveEntity> SERIALIZER = PSerializer.autoRegister((String)"Std Wave Entity", StandardWaveEntity.class).build(true);
        protected final EntityType<?> type;
        protected final CompoundTag tag;

        public StandardWaveEntity(EntityType<?> type, @Nullable CompoundTag tag) {
            this.type = type;
            this.tag = tag == null ? new CompoundTag() : tag;
            this.tag.m_128359_("id", EntityType.m_20613_(type).toString());
        }

        @Override
        public LivingEntity createEntity(Level level) {
            LivingEntity l;
            Entity ent = EntityType.m_20645_((CompoundTag)this.tag, (Level)level, Function.identity());
            return ent instanceof LivingEntity ? (l = (LivingEntity)ent) : null;
        }

        @Override
        public Component getDescription() {
            return Component.m_237115_((String)this.type.m_20675_());
        }

        @Override
        public AABB getAABB(double x, double y, double z) {
            return this.type.m_20585_(x, y, z);
        }

        @Override
        public boolean shouldFinalizeSpawn() {
            return this.tag.m_128440_() == 1 || this.tag.m_128471_("ForceFinalizeSpawn");
        }

        @Override
        public PSerializer<WaveEntity> getSerializer() {
            return SERIALIZER;
        }

        public JsonObject write() {
            JsonObject entityData = new JsonObject();
            entityData.addProperty("entity", EntityType.m_20613_(this.type).toString());
            if (this.tag != null) {
                entityData.add("nbt", ItemAdapter.ITEM_READER.toJsonTree((Object)this.tag));
            }
            return entityData;
        }

        public static WaveEntity read(JsonObject obj) {
            EntityType type = (EntityType)JsonUtil.getRegistryObject((JsonObject)obj, (String)"entity", (IForgeRegistry)ForgeRegistries.ENTITY_TYPES);
            CompoundTag nbt = obj.has("nbt") ? (CompoundTag)ItemAdapter.ITEM_READER.fromJson(obj.get("nbt"), CompoundTag.class) : null;
            return new StandardWaveEntity(type, nbt);
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeRegistryId(ForgeRegistries.ENTITY_TYPES, this.type);
        }

        public static WaveEntity read(FriendlyByteBuf buf) {
            return new StandardWaveEntity((EntityType)buf.readRegistryIdSafe(EntityType.class), null);
        }
    }
}

