/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.htcyd.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.htcyd.world.features.BlockstrucFeature;
import net.mcreator.htcyd.world.features.SmallboatfirewormFeature;
import net.mcreator.htcyd.world.features.plants.DaggaFeature;
import net.mcreator.htcyd.world.features.plants.DragonNipFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class HtcydModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"htcyd");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> DRAGON_NIP = HtcydModFeatures.register("dragon_nip", DragonNipFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, DragonNipFeature.GENERATE_BIOMES, DragonNipFeature::placedFeature));
    public static final RegistryObject<Feature<?>> DAGGA = HtcydModFeatures.register("dagga", DaggaFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, DaggaFeature.GENERATE_BIOMES, DaggaFeature::placedFeature));
    public static final RegistryObject<Feature<?>> SMALLBOATFIREWORM = HtcydModFeatures.register("smallboatfireworm", SmallboatfirewormFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, SmallboatfirewormFeature.GENERATE_BIOMES, SmallboatfirewormFeature::placedFeature));
    public static final RegistryObject<Feature<?>> BLOCKSTRUC = HtcydModFeatures.register("blockstruc", BlockstrucFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, BlockstrucFeature.GENERATE_BIOMES, BlockstrucFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

