/*
 * Decompiled with CFR 0.152.
 */
package moguns.entities;

import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.entity.ProjectileEntity;
import com.mrcrayfish.guns.event.GunProjectileHitEvent;
import com.mrcrayfish.guns.item.GunItem;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TakiProjectileEntity
extends ProjectileEntity {
    private static final Predicate<BlockState> IGNORE_LEAVES = input -> input != null && (Boolean)Config.COMMON.gameplay.ignoreLeaves.get() != false && input.func_177230_c() instanceof LeavesBlock;

    public TakiProjectileEntity(EntityType<? extends ProjectileEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    public TakiProjectileEntity(EntityType<? extends ProjectileEntity> entityType, World worldIn, LivingEntity shooter, ItemStack stack, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, stack, item, modifiedGun);
    }

    protected void onProjectileTick() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197595_F, true, this.func_226277_ct_() - this.func_213322_ci().func_82615_a() / (double)i, this.func_226278_cu_() - this.func_213322_ci().func_82617_b() / (double)i, this.func_226281_cx_() - this.func_213322_ci().func_82616_c() / (double)i, 0.0, 0.0, 0.0);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            Vector3d startVec = this.func_213303_ch();
            Vector3d endVec = startVec.func_178787_e(this.func_213322_ci());
            BlockRayTraceResult result = TakiProjectileEntity.rayTraceBlocks(this.field_70170_p, new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this), IGNORE_LEAVES);
            this.onHit((RayTraceResult)result, startVec, endVec);
        }
    }

    protected void onHitEntity(Entity entity, Vector3d hitVec, Vector3d startVec, Vector3d endVec, boolean headshot) {
        super.onHitEntity(entity, hitVec, startVec, endVec, headshot);
        entity.func_70015_d(5);
    }

    private void onHit(RayTraceResult result, Vector3d startVec, Vector3d endVec) {
        if (MinecraftForge.EVENT_BUS.post((Event)new GunProjectileHitEvent(result, (ProjectileEntity)this))) {
            return;
        }
        if (result instanceof BlockRayTraceResult) {
            BlockPos offsetPos;
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)result;
            if (blockRayTraceResult.func_216346_c() == RayTraceResult.Type.MISS) {
                return;
            }
            Vector3d hitVec = result.func_216347_e();
            BlockPos pos = blockRayTraceResult.func_216350_a();
            if (((Boolean)Config.COMMON.gameplay.enableGunGriefing.get()).booleanValue() && AbstractFireBlock.func_241465_a_((World)this.field_70170_p, (BlockPos)(offsetPos = pos.func_177972_a(blockRayTraceResult.func_216354_b())), (Direction)blockRayTraceResult.func_216354_b())) {
                BlockState fireState = AbstractFireBlock.func_235326_a_((IBlockReader)this.field_70170_p, (BlockPos)offsetPos);
                this.field_70170_p.func_180501_a(offsetPos, fireState, 11);
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197595_F, hitVec.field_72450_a - 1.0 + this.field_70146_Z.nextDouble() * 2.0, hitVec.field_72448_b, hitVec.field_72449_c - 1.0 + this.field_70146_Z.nextDouble() * 2.0, 4, 0.0, 0.0, 0.0, 0.0);
            }
            return;
        }
    }

    private static BlockRayTraceResult rayTraceBlocks(World world, RayTraceContext context, Predicate<BlockState> ignorePredicate) {
        return TakiProjectileEntity.performRayTrace(context, (rayTraceContext, blockPos) -> {
            BlockState blockState = world.func_180495_p(blockPos);
            if (ignorePredicate.test(blockState)) {
                return null;
            }
            FluidState fluidState = world.func_204610_c(blockPos);
            Vector3d startVec = rayTraceContext.func_222253_b();
            Vector3d endVec = rayTraceContext.func_222250_a();
            VoxelShape blockShape = rayTraceContext.func_222251_a(blockState, (IBlockReader)world, blockPos);
            BlockRayTraceResult blockResult = world.func_217296_a(startVec, endVec, blockPos, blockShape, blockState);
            VoxelShape fluidShape = rayTraceContext.func_222252_a(fluidState, (IBlockReader)world, blockPos);
            BlockRayTraceResult fluidResult = fluidShape.func_212433_a(startVec, endVec, blockPos);
            double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.func_222253_b().func_72436_e(blockResult.func_216347_e());
            double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.func_222253_b().func_72436_e(fluidResult.func_216347_e());
            return blockDistance <= fluidDistance ? blockResult : fluidResult;
        }, rayTraceContext -> {
            Vector3d Vector3d2 = rayTraceContext.func_222253_b().func_178788_d(rayTraceContext.func_222250_a());
            return BlockRayTraceResult.func_216352_a((Vector3d)rayTraceContext.func_222250_a(), (Direction)Direction.func_210769_a((double)Vector3d2.field_72450_a, (double)Vector3d2.field_72448_b, (double)Vector3d2.field_72449_c), (BlockPos)new BlockPos(rayTraceContext.func_222250_a()));
        });
    }

    private static <T> T performRayTrace(RayTraceContext context, BiFunction<RayTraceContext, BlockPos, T> hitFunction, Function<RayTraceContext, T> p_217300_2_) {
        int blockZ;
        int blockY;
        Vector3d endVec;
        Vector3d startVec = context.func_222253_b();
        if (startVec.equals((Object)(endVec = context.func_222250_a()))) {
            return p_217300_2_.apply(context);
        }
        double startX = MathHelper.func_219803_d((double)-1.0E-7, (double)endVec.field_72450_a, (double)startVec.field_72450_a);
        double startY = MathHelper.func_219803_d((double)-1.0E-7, (double)endVec.field_72448_b, (double)startVec.field_72448_b);
        double startZ = MathHelper.func_219803_d((double)-1.0E-7, (double)endVec.field_72449_c, (double)startVec.field_72449_c);
        double endX = MathHelper.func_219803_d((double)-1.0E-7, (double)startVec.field_72450_a, (double)endVec.field_72450_a);
        double endY = MathHelper.func_219803_d((double)-1.0E-7, (double)startVec.field_72448_b, (double)endVec.field_72448_b);
        double endZ = MathHelper.func_219803_d((double)-1.0E-7, (double)startVec.field_72449_c, (double)endVec.field_72449_c);
        int blockX = MathHelper.func_76128_c((double)endX);
        BlockPos.Mutable mutablePos = new BlockPos.Mutable(blockX, blockY = MathHelper.func_76128_c((double)endY), blockZ = MathHelper.func_76128_c((double)endZ));
        T t = hitFunction.apply(context, (BlockPos)mutablePos);
        if (t != null) {
            return t;
        }
        double deltaX = startX - endX;
        double deltaY = startY - endY;
        double deltaZ = startZ - endZ;
        int signX = MathHelper.func_219802_k((double)deltaX);
        int signY = MathHelper.func_219802_k((double)deltaY);
        int signZ = MathHelper.func_219802_k((double)deltaZ);
        double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
        double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
        double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
        double d12 = d9 * (signX > 0 ? 1.0 - MathHelper.func_181162_h((double)endX) : MathHelper.func_181162_h((double)endX));
        double d13 = d10 * (signY > 0 ? 1.0 - MathHelper.func_181162_h((double)endY) : MathHelper.func_181162_h((double)endY));
        double d14 = d11 * (signZ > 0 ? 1.0 - MathHelper.func_181162_h((double)endZ) : MathHelper.func_181162_h((double)endZ));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    blockX += signX;
                    d12 += d9;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                blockY += signY;
                d13 += d10;
            } else {
                blockZ += signZ;
                d14 += d11;
            }
            if ((t1 = hitFunction.apply(context, (BlockPos)mutablePos.func_181079_c(blockX, blockY, blockZ))) == null) continue;
            return t1;
        }
        return p_217300_2_.apply(context);
    }
}

