/*
 * Decompiled with CFR 0.152.
 */
package moguns.events;

import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.client.handler.RecoilHandler;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.event.GunFireEvent;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.util.GunModifierHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="moguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RecoilShootingEvent {
    private static RecoilShootingEvent instance;
    public static int recoilRand;
    private float cameraRecoil;
    private float progressCameraRecoil;

    public static RecoilShootingEvent get() {
        if (instance == null) {
            instance = new RecoilShootingEvent();
        }
        return instance;
    }

    private RecoilShootingEvent() {
    }

    @SubscribeEvent
    public static void preShoot(GunFireEvent.Pre event) {
        if (!event.isClient()) {
            if (!(event.getStack().m_41720_() instanceof GunItem)) {
                return;
            }
            recoilRand = new Random().nextInt(2);
        }
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Post event) {
        if (event.isClient()) {
            if (!((Boolean)Config.SERVER.enableCameraRecoil.get()).booleanValue()) {
                return;
            }
            ItemStack heldItem = event.getStack();
            GunItem gunItem = (GunItem)heldItem.m_41720_();
            Gun modifiedGun = gunItem.getModifiedGun(heldItem);
            float recoilModifier = 1.0f - GunModifierHelper.getRecoilModifier((ItemStack)heldItem);
            recoilModifier = (float)((double)recoilModifier * RecoilHandler.get().getAdsRecoilReduction(modifiedGun));
            this.cameraRecoil = modifiedGun.getGeneral().getRecoilAngle() * recoilModifier;
            this.progressCameraRecoil = 0.0f;
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!((Boolean)Config.SERVER.enableCameraRecoil.get()).booleanValue()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END || this.cameraRecoil <= 0.0f) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        float recoilAmount = this.cameraRecoil * mc.m_91297_() * 0.15f;
        float startProgress = this.progressCameraRecoil / this.cameraRecoil;
        float endProgress = (this.progressCameraRecoil + recoilAmount) / this.cameraRecoil;
        float yaw = mc.f_91074_.m_146908_();
        if (startProgress < 0.2f) {
            if (recoilRand == 1) {
                mc.f_91074_.m_146922_(yaw - (endProgress - startProgress) / 0.2f * this.cameraRecoil / 2.0f);
            } else {
                mc.f_91074_.m_146922_(yaw + (endProgress - startProgress) / 0.2f * this.cameraRecoil / 2.0f);
            }
        } else if (recoilRand == 1) {
            mc.f_91074_.m_146922_(yaw + (endProgress - startProgress) / 0.8f * this.cameraRecoil / 2.0f);
        } else {
            mc.f_91074_.m_146922_(yaw - (endProgress - startProgress) / 0.8f * this.cameraRecoil / 2.0f);
        }
        this.progressCameraRecoil += recoilAmount;
        if (this.progressCameraRecoil >= this.cameraRecoil) {
            this.cameraRecoil = 0.0f;
            this.progressCameraRecoil = 0.0f;
        }
    }
}

