/*
 * Decompiled with CFR 0.152.
 */
package net.aridastle.monstersandmushrooms.item.custom;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.aridastle.monstersandmushrooms.item.ModArmorMaterials;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.item.GeoArmorItem;

public class BugsyArmorItem
extends GeoArmorItem
implements IAnimatable {
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final Map<ArmorMaterial, MobEffectInstance> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ModArmorMaterials.SUSPICIOUS_LEAF, (Object)new MobEffectInstance(MobEffects.f_19621_, 200)).build();

    public BugsyArmorItem(ArmorMaterial material, EquipmentSlot slot, Item.Properties settings) {
        super(material, slot, settings);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 20.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        return PlayState.CONTINUE;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.m_5776_() && this.hasFullSuitOfArmorOn(player)) {
            this.evaluateArmorEffects(player);
        }
    }

    private void evaluateArmorEffects(Player player) {
        for (Map.Entry<ArmorMaterial, MobEffectInstance> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            ArmorMaterial mapArmorMaterial = entry.getKey();
            MobEffectInstance mapStatusEffect = entry.getValue();
            if (!this.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffect);
        }
    }

    private void addStatusEffectForMaterial(Player player, ArmorMaterial mapArmorMaterial, MobEffectInstance mapStatusEffect) {
        boolean hasPlayerEffect = player.m_21023_(mapStatusEffect.m_19544_());
        if (this.hasCorrectArmorOn(mapArmorMaterial, player) && !hasPlayerEffect) {
            player.m_7292_(new MobEffectInstance(mapStatusEffect.m_19544_(), mapStatusEffect.m_19557_(), mapStatusEffect.m_19564_()));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 1));
        }
        if (!(player.f_20916_ >= 1 || player.m_21188_() == null || player.m_21188_().m_21023_(MobEffects.f_19613_) || player.m_21188_().m_21023_(MobEffects.f_19614_) || player.m_21188_().m_21023_(MobEffects.f_19597_) || player.m_21188_().m_21023_(MobEffects.f_19620_) || player.m_21188_().m_21023_(MobEffects.f_19619_))) {
            int max = 4;
            int min = 0;
            int rand_int = (int)Math.floor(Math.random() * (double)(max - min + 1) + (double)min);
            if (rand_int == 0) {
                player.m_21188_().m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100));
            } else if (rand_int == 1) {
                player.m_21188_().m_7292_(new MobEffectInstance(MobEffects.f_19614_, 50));
            } else if (rand_int == 2) {
                player.m_21188_().m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100));
            } else if (rand_int == 3) {
                player.m_21188_().m_7292_(new MobEffectInstance(MobEffects.f_19620_, 50));
            } else if (rand_int == 4) {
                player.m_21188_().m_7292_(new MobEffectInstance(MobEffects.f_19619_, 100));
            }
        }
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack breastplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return !helmet.m_41619_() && !breastplate.m_41619_() && !leggings.m_41619_() && !boots.m_41619_();
    }

    private boolean hasCorrectArmorOn(ArmorMaterial material, Player player) {
        for (ItemStack armorStack : player.m_150109_().f_35975_) {
            if (armorStack.m_41720_() instanceof ArmorItem) continue;
            return false;
        }
        ArmorItem boots = (ArmorItem)player.m_150109_().m_36052_(0).m_41720_();
        ArmorItem leggings = (ArmorItem)player.m_150109_().m_36052_(1).m_41720_();
        ArmorItem breastplate = (ArmorItem)player.m_150109_().m_36052_(2).m_41720_();
        ArmorItem helmet = (ArmorItem)player.m_150109_().m_36052_(3).m_41720_();
        return helmet.m_40401_() == material && breastplate.m_40401_() == material && leggings.m_40401_() == material && boots.m_40401_() == material;
    }
}

