/*
 * Decompiled with CFR 0.152.
 */
package net.aridastle.monstersandmushrooms.item.custom;

import java.util.function.Consumer;
import net.aridastle.monstersandmushrooms.entity.client.weapon.ShroomsterStaffRenderer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ShroomsterStaffItem
extends SwordItem
implements IAnimatable {
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public ShroomsterStaffItem(Tier ttier, int attack_damage, float attack_speed, Item.Properties pproperties) {
        super(ttier, attack_damage, attack_speed, pproperties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new ShroomsterStaffRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.shroomsterstaff.aura", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.m_5776_() && hand == InteractionHand.MAIN_HAND) {
            this.voidEffect(player, level);
            player.m_36335_().m_41524_((Item)this, 1000);
        }
        return super.m_7203_(level, player, hand);
    }

    private void voidEffect(Player player, Level level) {
        Vec3 to = this.rangedEffect(player, level, 30);
        AreaEffectCloud lingeringPotion = new AreaEffectCloud(EntityType.f_20476_, level);
        lingeringPotion.m_19716_(new MobEffectInstance(MobEffects.f_19609_, 500));
        lingeringPotion.m_19716_(new MobEffectInstance(MobEffects.f_216964_, 500));
        lingeringPotion.m_20219_(to);
        level.m_7967_((Entity)lingeringPotion);
    }

    private Vec3 rangedEffect(Player player, Level level, int range) {
        Vec3 playerRot = player.m_20252_(0.0f);
        Vec3 path = playerRot.m_82490_((double)range);
        Vec3 from = player.m_20299_(0.0f);
        Vec3 to = from.m_82549_(path);
        BlockHitResult blockhit = level.m_45547_(new ClipContext(from, to, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        return blockhit.m_82450_();
    }
}

