/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.nasty;

import com.lupicus.nasty.config.MyConfig;
import com.lupicus.nasty.entity.ModEntities;
import com.lupicus.nasty.item.ModItems;
import com.lupicus.nasty.sound.ModSounds;
import com.lupicus.nasty.util.SpawnData;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="nasty")
public class Main {
    public static final String MODID = "nasty";

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, MyConfig.COMMON_SPEC);
        MinecraftForge.EVENT_BUS.register(SpawnData.class);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(() -> ModItems.setup());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void setupClient(FMLClientSetupEvent event) {
        ModEntities.setupClient();
    }

    @SubscribeEvent
    public void setupServer(FMLDedicatedServerSetupEvent event) {
    }

    @Mod.EventBusSubscriber
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onServerStarting(FMLServerStartingEvent event) {
            ModEntities.addSpawnData();
        }

        @SubscribeEvent
        public static void onServerStopping(FMLServerStoppingEvent event) {
            ModEntities.removeSpawnData();
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            ModItems.register((IForgeRegistry<Item>)event.getRegistry());
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void onColorsRegistry(ColorHandlerEvent.Item event) {
            ModItems.register(event.getItemColors());
        }

        @SubscribeEvent
        public static void onEntityRegistry(RegistryEvent.Register<EntityType<?>> event) {
            ModEntities.register(event.getRegistry());
        }

        @SubscribeEvent
        public static void onSoundRegistry(RegistryEvent.Register<SoundEvent> event) {
            ModSounds.register((IForgeRegistry<SoundEvent>)event.getRegistry());
        }
    }
}

