/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.nasty.entity;

import com.lupicus.nasty.config.MyConfig;
import com.lupicus.nasty.sound.ModSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class ExplosiveArrowEntity
extends ArrowEntity {
    private BlockPos target;

    public ExplosiveArrowEntity(EntityType<? extends ArrowEntity> type, World world) {
        super(type, world);
    }

    public ExplosiveArrowEntity(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public ExplosiveArrowEntity(World worldIn, LivingEntity shooter) {
        super(worldIn, shooter);
    }

    protected void func_70227_a(RayTraceResult raytraceResultIn) {
        super.func_70227_a(raytraceResultIn);
        if (raytraceResultIn.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult result = (BlockRayTraceResult)raytraceResultIn;
            this.target = result.func_216350_a();
            this.createExplosion((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.5f, Explosion.Mode.BREAK);
            this.func_70106_y();
        }
    }

    private Explosion createExplosion(double x, double y, double z, float r, Explosion.Mode mode) {
        return this.createExplosion(null, x, y, z, r, mode);
    }

    private Explosion createExplosion(@Nullable DamageSource source, double x, double y, double z, float r, Explosion.Mode mode) {
        if (!(this.field_70170_p instanceof ServerWorld)) {
            return null;
        }
        ServerWorld world = (ServerWorld)this.field_70170_p;
        SimpleExplosion e = new SimpleExplosion((World)world, (Entity)this, source, null, x, y, z, r, false, mode);
        if (ForgeEventFactory.onExplosionStart((World)world, (Explosion)e)) {
            return e;
        }
        e.func_77278_a();
        e.func_77279_a(false);
        if (mode == Explosion.Mode.NONE) {
            e.func_180342_d();
        }
        for (ServerPlayerEntity serverplayerentity : world.func_217369_A()) {
            if (!(serverplayerentity.func_70092_e(x, y, z) < 4096.0)) continue;
            serverplayerentity.field_71135_a.func_147359_a((IPacket)new SExplosionPacket(x, y, z, r, e.func_180343_e(), (Vector3d)e.func_77277_b().get(serverplayerentity)));
        }
        return e;
    }

    public boolean func_174816_a(Explosion explosionIn, IBlockReader worldIn, BlockPos pos, BlockState blockStateIn, float f) {
        if (!this.target.equals((Object)pos)) {
            return false;
        }
        return MyConfig.explosiveArrowOnBlock;
    }

    protected void func_213868_a(EntityRayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.func_216348_a();
        LivingEntity le = null;
        boolean blocking = false;
        EquipmentSlotType slot = EquipmentSlotType.OFFHAND;
        double rot = 0.0;
        if (MyConfig.explosiveArrowOnArmor && entity instanceof LivingEntity) {
            le = (LivingEntity)entity;
            if (MyConfig.explosiveArrowOnShield) {
                Object se = this.func_234616_v_();
                if (se == null) {
                    se = this;
                }
                if ((blocking = this.canBlockDamageSource(le, (Entity)se)) && le.func_184600_cs() == Hand.MAIN_HAND) {
                    slot = EquipmentSlotType.MAINHAND;
                }
            }
            rot = this.field_70177_z;
        }
        super.func_213868_a(raytraceResultIn);
        if (blocking || le != null && rot == (double)this.field_70177_z) {
            ItemStack stack;
            if (!blocking) {
                slot = EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)this.field_70146_Z.nextInt(4));
            }
            if (!(stack = le.func_184582_a(slot)).func_190926_b()) {
                le.func_184201_a(slot, ItemStack.field_190927_a);
                Vector3d pos = le.func_213303_ch();
                ItemEntity itementity = new ItemEntity(le.field_70170_p, pos.field_72450_a, pos.field_72448_b + 1.0, pos.field_72449_c, stack);
                itementity.func_174869_p();
                float f = this.field_70146_Z.nextFloat() * 0.5f;
                float f1 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                itementity.func_213293_j((double)(-MathHelper.func_76126_a((float)f1) * f), 0.2, (double)(MathHelper.func_76134_b((float)f1) * f));
                le.field_70170_p.func_217376_c((Entity)itementity);
                le.field_70170_p.func_184148_a(null, le.func_226277_ct_(), le.func_226278_cu_(), le.func_226281_cx_(), ModSounds.ARMOR_DROP, le.func_184176_by(), 1.0f, 1.0f);
            }
            if (this.func_70089_S()) {
                this.func_70106_y();
            }
        }
    }

    private boolean canBlockDamageSource(LivingEntity target, Entity source) {
        if (target.func_184585_cz() && this.func_213874_s() <= 0) {
            Vector3d vec3d2 = source.func_213303_ch();
            Vector3d vec3d = target.func_70676_i(1.0f);
            Vector3d vec3d1 = vec3d2.func_72444_a(target.func_213303_ch()).func_72432_b();
            vec3d1 = new Vector3d(vec3d1.field_72450_a, 0.0, vec3d1.field_72449_c);
            if (vec3d1.func_72430_b(vec3d) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public float func_180428_a(Explosion explosionIn, IBlockReader worldIn, BlockPos pos, BlockState blockStateIn, FluidState ifluidstateIn, float f2) {
        return f2 / MyConfig.explosiveArrowStrength;
    }

    public static class SimpleExplosion
    extends Explosion {
        private double x;
        private double y;
        private double z;
        private World world;
        private Entity exploder;

        public SimpleExplosion(World worldIn, Entity exploderIn, @Nullable DamageSource dmgsrc, @Nullable ExplosionContext ctx, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, Explosion.Mode modeIn) {
            super(worldIn, exploderIn, dmgsrc, ctx, xIn, yIn, zIn, sizeIn, causesFireIn, modeIn);
            this.world = worldIn;
            this.x = xIn;
            this.y = yIn;
            this.z = zIn;
            this.exploder = exploderIn;
        }

        public void func_77278_a() {
            List list = this.func_180343_e();
            BlockPos blockpos = new BlockPos(this.x, this.y, this.z);
            BlockState blockstate = this.world.func_180495_p(blockpos);
            FluidState fluidstate = this.world.func_204610_c(blockpos);
            if (!blockstate.isAir((IBlockReader)this.world, blockpos) || !fluidstate.func_206888_e()) {
                float f2 = Math.max(blockstate.getExplosionResistance((IBlockReader)this.world, blockpos, (Explosion)this), fluidstate.getExplosionResistance((IBlockReader)this.world, blockpos, (Explosion)this));
                if (this.exploder != null) {
                    f2 = this.exploder.func_180428_a((Explosion)this, (IBlockReader)this.world, blockpos, blockstate, fluidstate, f2);
                }
                if (f2 < 1.0f && (this.exploder == null || this.exploder.func_174816_a((Explosion)this, (IBlockReader)this.world, blockpos, blockstate, f2))) {
                    list.add(blockpos);
                }
            }
        }
    }
}

