/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.nasty.entity;

import com.lupicus.nasty.config.MyConfig;
import com.lupicus.nasty.entity.NastySkeletonEntity;
import com.lupicus.nasty.entity.NastyWolfEntity;
import com.lupicus.nasty.renderer.entity.NastySkeletonRenderer;
import com.lupicus.nasty.renderer.entity.NastyWolfRenderer;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModEntities {
    public static final EntityType<NastySkeletonEntity> NASTY_SKELETON = ModEntities.register("skeleton", EntityType.Builder.func_220322_a(NastySkeletonEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.99f).func_233606_a_(8));
    public static final EntityType<NastyWolfEntity> NASTY_WOLF = ModEntities.register("wolf", EntityType.Builder.func_220322_a(NastyWolfEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 0.85f).func_233606_a_(8));

    private static <T extends Entity> EntityType<T> register(String name, EntityType.Builder<T> builder) {
        String key = "nasty:" + name;
        EntityType type = builder.func_206830_a(key);
        type.setRegistryName(key);
        return type;
    }

    public static void register(IForgeRegistry<EntityType<?>> forgeRegistry) {
        forgeRegistry.registerAll((IForgeRegistryEntry[])new EntityType[]{NASTY_SKELETON, NASTY_WOLF});
        EntitySpawnPlacementRegistry.func_209343_a(NASTY_SKELETON, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, NastySkeletonEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(NASTY_WOLF, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, NastyWolfEntity::canSpawn);
        GlobalEntityTypeAttributes.put(NASTY_SKELETON, (AttributeModifierMap)NastySkeletonEntity.registerAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put(NASTY_WOLF, (AttributeModifierMap)NastyWolfEntity.registerAttibutes().func_233813_a_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setupClient() {
        RenderingRegistry.registerEntityRenderingHandler(NASTY_SKELETON, rm -> new NastySkeletonRenderer(rm));
        RenderingRegistry.registerEntityRenderingHandler(NASTY_WOLF, rm -> new NastyWolfRenderer(rm));
    }

    public static void addSpawnData() {
        int val = MyConfig.spawnDungeon;
        if (val > 0) {
            DungeonHooks.addDungeonMob(NASTY_SKELETON, (int)val);
        }
    }

    public static void removeSpawnData() {
        DungeonHooks.removeDungeonMob(NASTY_SKELETON);
    }

    public static void getBiomeSpawnData(List<EntityType<?>> mobs, List<MobSpawnInfo.Spawners> spawns) {
        int val = MyConfig.spawnBiome;
        if (val > 0) {
            mobs.add(EntityType.field_200741_ag);
            spawns.add(new MobSpawnInfo.Spawners(NASTY_SKELETON, val, 1, 3));
        }
    }

    public static void getFeatureSpawnData(List<EntityType<?>> mobs, List<MobSpawnInfo.Spawners> spawns) {
        int val = MyConfig.spawnFeature;
        if (val > 0) {
            mobs.add(EntityType.field_200741_ag);
            spawns.add(new MobSpawnInfo.Spawners(NASTY_SKELETON, val, 3, 4));
        }
    }
}

