/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.nasty.entity;

import com.lupicus.nasty.config.MyConfig;
import com.lupicus.nasty.entity.IHasVirus;
import com.lupicus.nasty.entity.ModEntities;
import com.lupicus.nasty.entity.NastyWolfEntity;
import com.lupicus.nasty.entity.ai.controller.JumpMovementController;
import com.lupicus.nasty.entity.ai.goal.SpreadVirusGoal;
import com.lupicus.nasty.item.ModItems;
import com.lupicus.nasty.pathfinding.JumpPathNavigator;
import com.lupicus.nasty.util.ArrowHelper;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraftforge.registries.ForgeRegistries;

public class NastySkeletonEntity
extends AbstractSkeletonEntity
implements IHasVirus {
    public static final int NVARIANTS = 6;
    private static int defVariant = 0;
    private static boolean singleVariant = false;
    private static HashMap<String, AdjParms> biomeMap = new HashMap();
    private static final DataParameter<Integer> SUB_TYPE = EntityDataManager.func_187226_a(NastySkeletonEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final RangedBowAttackGoal<NastySkeletonEntity> aiArrowAttack = new RangedBowAttackGoal((MonsterEntity)this, 1.0, 20, 40.0f);
    private final MeleeAttackGoal aiAttackOnCollide = new MeleeAttackGoal((CreatureEntity)this, 1.2, false){

        public void func_75251_c() {
            super.func_75251_c();
            NastySkeletonEntity.this.func_213395_q(false);
        }

        public void func_75249_e() {
            super.func_75249_e();
            NastySkeletonEntity.this.func_213395_q(true);
        }
    };

    public NastySkeletonEntity(EntityType<? extends NastySkeletonEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_85036_m();
        this.field_70765_h = new JumpMovementController((MobEntity)this);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    protected SoundEvent func_190727_o() {
        return SoundEvents.field_187868_fj;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return AbstractSkeletonEntity.func_234275_m_().func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233819_b_, 24.0).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    protected void func_184651_r() {
        if (MyConfig.virusChance > 0.0f && MyConfig.virusDistance > 0.0f) {
            this.field_70714_bg.func_75776_a(1, (Goal)new SpreadVirusGoal(this, SkeletonEntity.class, MyConfig.virusDistance, MyConfig.virusChance));
        }
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FleeSunGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUB_TYPE, (Object)0);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new JumpPathNavigator((MobEntity)this, worldIn);
    }

    public int getSubType() {
        return (Integer)this.field_70180_af.func_187225_a(SUB_TYPE);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("SubType", (byte)this.getSubType());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(SUB_TYPE, (Object)compound.func_74771_c("SubType"));
    }

    protected ResourceLocation func_184647_J() {
        ResourceLocation res = super.func_184647_J();
        return new ResourceLocation(res.func_110624_b(), res.func_110623_a() + "/" + this.getSubType());
    }

    public void func_85036_m() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            if (this.aiAttackOnCollide == null) {
                return;
            }
            this.field_70714_bg.func_85156_a((Goal)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a(this.aiArrowAttack);
            ItemStack itemstack = this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f));
            if (itemstack.func_77973_b() instanceof BowItem) {
                int i = 20;
                if (this.field_70170_p.func_175659_aa() != Difficulty.HARD) {
                    i = 40;
                }
                this.aiArrowAttack.func_189428_b(i);
                this.field_70714_bg.func_75776_a(4, this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(4, (Goal)this.aiAttackOnCollide);
            }
        }
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        double temp;
        double dz;
        double dx;
        double d2;
        BlockPos pos = this.func_233580_cy_();
        Biome biome = worldIn.func_226691_t_(pos);
        if (MyConfig.spawnTempBased && (reason == SpawnReason.NATURAL || reason == SpawnReason.CHUNK_GENERATION)) {
            float temp2 = biome.func_225486_c(pos);
            int subtype = singleVariant ? defVariant : this.randomTempBased(temp2);
            this.field_70180_af.func_187227_b(SUB_TYPE, (Object)subtype);
        } else if (reason != SpawnReason.CONVERSION) {
            int subtype = singleVariant ? defVariant : this.randomVariant();
            this.field_70180_af.func_187227_b(SUB_TYPE, (Object)subtype);
        }
        if (difficultyIn.func_203095_a() == Difficulty.HARD) {
            this.func_110148_a(Attributes.field_233823_f_).func_233767_b_(new AttributeModifier("difficulty", 3.0, AttributeModifier.Operation.ADDITION));
        }
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        IWorldInfo winfo = worldIn.func_72912_H();
        BlockPos spos = new BlockPos(winfo.func_76079_c(), winfo.func_76075_d(), winfo.func_76074_e());
        double x0 = spos.func_177958_n();
        double z0 = spos.func_177952_p();
        double xzf = worldIn.func_230315_m_().func_242724_f();
        if (xzf != 1.0) {
            x0 /= xzf;
            z0 /= xzf;
        }
        if ((d2 = (dx = (double)pos.func_177958_n() - x0) * dx + (dz = (double)pos.func_177952_p() - z0) * dz) >= MyConfig.maxDistanceSq) {
            temp = MyConfig.maxHealth;
        } else if (d2 <= MyConfig.minDistanceSq) {
            temp = MyConfig.minHealth;
        } else {
            double p = (Math.sqrt(d2) - MyConfig.minDistance) / (MyConfig.maxDistance - MyConfig.minDistance);
            temp = (MyConfig.maxHealth - MyConfig.minHealth) * p + MyConfig.minHealth;
        }
        float health = (float)Math.floor(temp);
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)health);
        this.func_70606_j(this.func_110138_aP());
        String keyPrefix = worldIn.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome) + ":";
        AdjParms adj = biomeMap.get(keyPrefix + this.getSubType());
        if (adj == null) {
            adj = biomeMap.get(keyPrefix + "*");
        }
        if (adj != null) {
            double val = adj.hp;
            if (val != 0.0) {
                this.func_110148_a(Attributes.field_233818_a_).func_233767_b_(new AttributeModifier("biome", val, AttributeModifier.Operation.MULTIPLY_BASE));
                this.func_70606_j(this.func_110138_aP());
            }
            if ((val = adj.speed) != 0.0) {
                this.func_110148_a(Attributes.field_233821_d_).func_233767_b_(new AttributeModifier("biome", val, AttributeModifier.Operation.MULTIPLY_BASE));
            }
        }
        this.setPotionsBasedOnDifficulty(difficultyIn);
        return spawnDataIn;
    }

    public static void configUpdate() {
        NastySkeletonEntity.setupWeights();
        NastySkeletonEntity.setupBiomes();
    }

    private static void setupBiomes() {
        String[] array = MyConfig.biomeAdjustments;
        biomeMap.clear();
        for (int i = 0; i < array.length; ++i) {
            String line = array[i].trim();
            String[] fields = line.split(",");
            try {
                if (fields.length != 4) {
                    throw new Exception("bad number of fields");
                }
                String biomeName = fields[0].trim();
                String variant = fields[1].trim();
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeName));
                if (biome == null) {
                    throw new Exception("bad biome value");
                }
                if (!variant.equals("*")) {
                    int j = Integer.parseInt(variant);
                    if (j < 0 || j >= 6) {
                        throw new Exception("bad variant value");
                    }
                    variant = Integer.toString(j);
                }
                biomeMap.put(biomeName + ":" + variant, new AdjParms(Double.parseDouble(fields[2]), Double.parseDouble(fields[3])));
                continue;
            }
            catch (Exception e) {
                field_184243_a.warn("Skipping bad Biome adjustment= " + line);
                field_184243_a.warn("Reason= " + e.getMessage());
            }
        }
    }

    private static void setupWeights() {
        int[] array = MyConfig.spawnVariantWeights;
        int count = 0;
        boolean first = true;
        for (int i = 0; i < 6; ++i) {
            if (array[i] <= 0) continue;
            ++count;
            if (!first) continue;
            first = false;
            defVariant = i;
        }
        if (count <= 1) {
            singleVariant = true;
        }
    }

    private int randomVariant() {
        return this.randomWeight(MyConfig.spawnVariantWeights);
    }

    private int randomTempBased(float temp) {
        int[] standard = MyConfig.spawnVariantWeights;
        int[] choices = new int[6];
        for (int i = 0; i < 6; ++i) {
            choices[i] = standard[i];
        }
        if (!(temp > 0.2f) || !(temp < 1.2f)) {
            choices[0] = 0;
        }
        if (!(temp > 1.0f)) {
            choices[1] = 0;
        }
        if (!(temp < 0.4f)) {
            choices[2] = 0;
        }
        return this.randomWeight(choices);
    }

    private int randomWeight(int[] weights) {
        int sum = 0;
        for (int i = 0; i < 6; ++i) {
            sum += weights[i];
        }
        if (sum > 0) {
            int j = this.field_70146_Z.nextInt(sum);
            for (int i = 0; i < 6; ++i) {
                if (j < weights[i]) {
                    return i;
                }
                j -= weights[i];
            }
        }
        return defVariant;
    }

    public static boolean isValidLightLevel(IServerWorld worldIn, BlockPos pos, Random randomIn) {
        if (worldIn.func_226658_a_(LightType.SKY, pos) > randomIn.nextInt(32)) {
            return false;
        }
        int i = worldIn.func_201672_e().func_72911_I() ? worldIn.func_205049_d(pos, 10) : worldIn.func_201696_r(pos);
        return i <= randomIn.nextInt(MyConfig.spawnLightLevel + 1);
    }

    public static boolean canSpawn(EntityType<? extends NastySkeletonEntity> type, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && NastySkeletonEntity.isValidLightLevel(worldIn, pos, randomIn) && NastySkeletonEntity.func_223315_a(type, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected void setPotionsBasedOnDifficulty(DifficultyInstance difficulty) {
        int amp = 2;
        if (difficulty.func_203095_a() == Difficulty.HARD) {
            ++amp;
        }
        this.func_195064_c(new EffectInstance(Effects.field_76430_j, Integer.MAX_VALUE, amp));
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        ItemStack stack = this.func_184582_a(EquipmentSlotType.HEAD);
        if (stack.func_190926_b() || stack.func_77973_b() == Items.field_151024_Q) {
            stack = new ItemStack((IItemProvider)Items.field_151024_Q);
            CompoundNBT nbt = stack.func_190925_c("display");
            int subtype = this.getSubType();
            int color = subtype == 0 ? 65280 : (subtype == 1 ? 0xFF0000 : (subtype == 2 ? 0xFF00FF : (subtype == 3 ? 33023 : (subtype == 4 ? 16738816 : 16766976))));
            nbt.func_74768_a("color", color);
            this.func_184201_a(EquipmentSlotType.HEAD, stack);
        }
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f)));
        AbstractArrowEntity abstractarrowentity = this.func_213624_b(itemstack, distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(abstractarrowentity);
        }
        this.enchantArrow(abstractarrowentity);
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_226283_e_(0.3333333333333333) - abstractarrowentity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        if (d3 > 40.0) {
            return;
        }
        double velocity = 1.6;
        d1 = ArrowHelper.computeY(d3, d1, velocity, abstractarrowentity.func_226278_cu_(), target.func_226278_cu_(), target.func_213302_cg());
        float inaccuracy = 0.0f;
        if (this.field_70146_Z.nextDouble() < MyConfig.addInaccuracy) {
            inaccuracy = 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4;
        }
        abstractarrowentity.func_70186_c(d0, d1, d2, (float)velocity, inaccuracy);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }

    public ItemStack func_213356_f(ItemStack shootable) {
        int subtype = this.getSubType();
        if (subtype == 2) {
            return new ItemStack((IItemProvider)ModItems.MAGIC_ARROW);
        }
        if (subtype == 4) {
            return new ItemStack((IItemProvider)ModItems.EXPLOSIVE_ARROW);
        }
        return super.func_213356_f(shootable);
    }

    protected void enchantArrow(AbstractArrowEntity entity) {
        int subtype;
        int i;
        int j = 1;
        if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
            ++j;
            i = MyConfig.bonusHardPower;
        } else {
            i = MyConfig.bonusPower;
        }
        if (i > 0) {
            entity.func_70239_b(entity.func_70242_d() + (double)(i + 1) * 0.5);
        }
        if (j > 0) {
            entity.func_70240_a(j);
        }
        if ((subtype = this.getSubType()) == 0) {
            ((ArrowEntity)entity).func_184558_a(new EffectInstance(Effects.field_76436_u, MyConfig.poisonTime));
        } else if (subtype == 1) {
            entity.func_70015_d(100);
        } else if (subtype == 3) {
            ((ArrowEntity)entity).func_184558_a(new EffectInstance(Effects.field_188424_y, 140));
        } else if (subtype == 5) {
            Effect effect = MyConfig.useBlindness ? Effects.field_76440_q : Effects.field_76431_k;
            ((ArrowEntity)entity).func_184558_a(new EffectInstance(effect, MyConfig.yellowTime, 1));
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        WolfEntity mob;
        Entity entity = source.func_76346_g();
        if (amount > 0.0f && entity != null && entity instanceof ServerPlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            double new_range = 64.0;
            ModifiableAttributeInstance attr = this.func_110148_a(Attributes.field_233819_b_);
            if (new_range > attr.func_111125_b()) {
                attr.func_111128_a(new_range);
            }
            this.func_70604_c((LivingEntity)player);
        }
        boolean flag = super.func_70097_a(source, amount);
        entity = source.func_76364_f();
        if (flag && entity instanceof WolfEntity && NastyWolfEntity.canInfect(mob = (WolfEntity)entity)) {
            NastyWolfEntity.onInfect(mob);
        }
        return flag;
    }

    protected void func_70665_d(DamageSource source, float damageAmount) {
        if (source.func_76352_a()) {
            damageAmount = (float)((double)damageAmount * MyConfig.arrowDamageMultiplier);
        }
        super.func_70665_d(source, damageAmount);
    }

    @Override
    public void onInfect(Entity mob) {
        Entity riding;
        ServerWorld world = (ServerWorld)mob.field_70170_p;
        Vector3d mobpos = mob.func_213303_ch();
        if (mob.func_233570_aj_()) {
            mob.func_213293_j(0.0, 0.0, 0.0);
        }
        NastySkeletonEntity newmob = (NastySkeletonEntity)ModEntities.NASTY_SKELETON.func_200721_a((World)world);
        if (mob.func_145818_k_()) {
            newmob.func_200203_b(mob.func_200201_e());
            newmob.func_174805_g(mob.func_174833_aM());
        }
        newmob.func_82142_c(mob.func_82150_aj());
        newmob.func_184224_h(mob.func_190530_aW());
        newmob.func_70012_b(mobpos.func_82615_a(), mobpos.func_82617_b(), mobpos.func_82616_c(), mob.field_70177_z, mob.field_70125_A);
        newmob.field_70180_af.func_187227_b(SUB_TYPE, (Object)this.getSubType());
        newmob.func_213386_a((IServerWorld)world, world.func_175649_E(new BlockPos(mobpos)), SpawnReason.CONVERSION, null, null);
        if (mob instanceof MobEntity) {
            MobEntity from = (MobEntity)mob;
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                ItemStack stack = from.func_184582_a(slot);
                newmob.func_184201_a(slot, stack.func_77946_l());
                newmob.func_184642_a(slot, this.func_205712_c(slot));
                stack.func_190920_e(0);
            }
            newmob.func_98053_h(from.func_98052_bS());
            if (from.func_104002_bU()) {
                newmob.func_110163_bv();
            }
            newmob.func_94061_f(from.func_175446_cd());
            newmob.func_70604_c(from.func_70643_av());
            newmob.field_70759_as = from.field_70759_as;
            newmob.field_70761_aq = from.field_70759_as;
        }
        if ((riding = mob.func_184187_bx()) != null) {
            mob.func_184210_p();
            newmob.func_184205_a(riding, true);
        } else {
            newmob.func_213317_d(mob.func_213322_ci());
        }
        world.func_217378_a((PlayerEntity)null, 1027, newmob.func_233580_cy_(), 0);
        world.func_217376_c((Entity)newmob);
        mob.func_70106_y();
    }

    private static class AdjParms {
        public double hp;
        public double speed;

        public AdjParms(double hp, double speed) {
            this.hp = hp;
            this.speed = speed;
        }
    }
}

