/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.nasty.config;

import com.lupicus.nasty.entity.NastySkeletonEntity;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="nasty", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static double minHealth;
    public static double maxHealth;
    public static double minDistance;
    public static double maxDistance;
    public static double minDistanceSq;
    public static double maxDistanceSq;
    public static double arrowDamageMultiplier;
    public static double addInaccuracy;
    public static boolean explosiveArrowOnArmor;
    public static boolean explosiveArrowOnBlock;
    public static boolean explosiveArrowOnShield;
    public static boolean useBlindness;
    public static float explosiveArrowStrength;
    public static float virusDistance;
    public static float virusChance;
    public static float virusChance2;
    public static int bonusPower;
    public static int bonusHardPower;
    public static int magicDamage;
    public static int poisonTime;
    public static int yellowTime;
    public static int spawnBiome;
    public static int spawnFeature;
    public static int spawnDungeon;
    public static int spawnLightLevel;
    public static boolean spawnTempBased;
    public static int[] spawnVariantWeights;
    public static String[] biomeAdjustments;
    public static VMode virusMode2;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            MyConfig.bakeConfig();
        }
    }

    public static void bakeConfig() {
        MyConfig.check(MyConfig.COMMON.minHealth, MyConfig.COMMON.maxHealth);
        minHealth = (Double)MyConfig.COMMON.minHealth.get();
        maxHealth = (Double)MyConfig.COMMON.maxHealth.get();
        MyConfig.check(MyConfig.COMMON.minDistance, MyConfig.COMMON.maxDistance);
        minDistance = (Double)MyConfig.COMMON.minDistance.get();
        minDistanceSq = minDistance * minDistance;
        maxDistance = (Double)MyConfig.COMMON.maxDistance.get();
        maxDistanceSq = maxDistance * maxDistance;
        arrowDamageMultiplier = (Double)MyConfig.COMMON.arrowDamageMultiplier.get();
        addInaccuracy = (Double)MyConfig.COMMON.addInaccuracy.get();
        bonusPower = (Integer)MyConfig.COMMON.bonusPower.get();
        bonusHardPower = (Integer)MyConfig.COMMON.bonusHardPower.get();
        magicDamage = (Integer)MyConfig.COMMON.magicDamage.get();
        poisonTime = (Integer)MyConfig.COMMON.poisonTime.get() * 20;
        yellowTime = (Integer)MyConfig.COMMON.yellowTime.get() * 20;
        spawnBiome = (Integer)MyConfig.COMMON.spawnBiome.get();
        spawnFeature = (Integer)MyConfig.COMMON.spawnFeature.get();
        spawnDungeon = (Integer)MyConfig.COMMON.spawnDungeon.get();
        spawnLightLevel = (Integer)MyConfig.COMMON.spawnLightLevel.get();
        explosiveArrowOnArmor = (Boolean)MyConfig.COMMON.explosiveArrowOnArmor.get();
        explosiveArrowOnBlock = (Boolean)MyConfig.COMMON.explosiveArrowOnBlock.get();
        explosiveArrowOnShield = (Boolean)MyConfig.COMMON.explosiveArrowOnShield.get();
        useBlindness = (Boolean)MyConfig.COMMON.useBlindness.get();
        explosiveArrowStrength = (float)((Double)MyConfig.COMMON.explosiveArrowStrength.get()).doubleValue();
        virusDistance = (float)((Double)MyConfig.COMMON.virusDistance.get()).doubleValue();
        virusChance = (float)((Double)MyConfig.COMMON.virusChance.get()).doubleValue();
        virusChance2 = (float)((Double)MyConfig.COMMON.virusChance2.get()).doubleValue();
        spawnTempBased = (Boolean)MyConfig.COMMON.spawnTempBased.get();
        spawnVariantWeights = MyConfig.extract(6, (String)MyConfig.COMMON.spawnVariantWeights.get());
        biomeAdjustments = MyConfig.extract((List)MyConfig.COMMON.biomeAdjustments.get());
        virusMode2 = (VMode)((Object)MyConfig.COMMON.virusMode2.get());
        NastySkeletonEntity.configUpdate();
    }

    private static void check(ForgeConfigSpec.DoubleValue min, ForgeConfigSpec.DoubleValue max) {
        double v2;
        double v1 = (Double)min.get();
        if (v1 > (v2 = ((Double)max.get()).doubleValue())) {
            min.set((Object)v2);
            max.set((Object)v1);
        }
    }

    private static int[] extract(int num, String value) {
        int i;
        int count = 0;
        int[] ret = new int[num];
        String[] list = value.split(",");
        int len = list.length;
        if (len != num) {
            LOGGER.warn("Bad sequence; excepted " + num + " values but has " + len);
            LOGGER.warn("for value= " + value);
        }
        if (len > num) {
            len = num;
        }
        for (i = 0; i < len; ++i) {
            try {
                ret[i] = Integer.parseInt(list[i]);
                continue;
            }
            catch (NumberFormatException e) {
                ++count;
            }
        }
        if (count > 0) {
            LOGGER.warn("Encountered " + count + " parsing errors");
            LOGGER.warn("for value= " + value);
        }
        for (i = 0; i < num; ++i) {
            if (ret[i] >= 0) continue;
            ret[i] = 0;
        }
        return ret;
    }

    private static String[] extract(List<? extends String> value) {
        return value.toArray(new String[value.size()]);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.DoubleValue minHealth;
        public final ForgeConfigSpec.DoubleValue maxHealth;
        public final ForgeConfigSpec.DoubleValue minDistance;
        public final ForgeConfigSpec.DoubleValue maxDistance;
        public final ForgeConfigSpec.DoubleValue arrowDamageMultiplier;
        public final ForgeConfigSpec.DoubleValue addInaccuracy;
        public final ForgeConfigSpec.BooleanValue explosiveArrowOnArmor;
        public final ForgeConfigSpec.BooleanValue explosiveArrowOnBlock;
        public final ForgeConfigSpec.BooleanValue explosiveArrowOnShield;
        public final ForgeConfigSpec.BooleanValue useBlindness;
        public final ForgeConfigSpec.DoubleValue explosiveArrowStrength;
        public final ForgeConfigSpec.DoubleValue virusDistance;
        public final ForgeConfigSpec.DoubleValue virusChance;
        public final ForgeConfigSpec.DoubleValue virusChance2;
        public final ForgeConfigSpec.IntValue bonusPower;
        public final ForgeConfigSpec.IntValue bonusHardPower;
        public final ForgeConfigSpec.IntValue magicDamage;
        public final ForgeConfigSpec.IntValue poisonTime;
        public final ForgeConfigSpec.IntValue yellowTime;
        public final ForgeConfigSpec.IntValue spawnBiome;
        public final ForgeConfigSpec.IntValue spawnFeature;
        public final ForgeConfigSpec.IntValue spawnDungeon;
        public final ForgeConfigSpec.IntValue spawnLightLevel;
        public final ForgeConfigSpec.BooleanValue spawnTempBased;
        public final ForgeConfigSpec.ConfigValue<String> spawnVariantWeights;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> biomeAdjustments;
        public final ForgeConfigSpec.EnumValue<VMode> virusMode2;

        public Common(ForgeConfigSpec.Builder builder) {
            List<String> biomeAdjList = Arrays.asList("minecraft:plains,*,-0.2,0.2", "minecraft:swamp,0,0.2,0.0", "minecraft:swamp,*,0.1,-0.1", "minecraft:badlands,*,0.3,0.3", "minecraft:dark_forest_hills,*,0.3,0.3");
            String baseTrans = "nasty.config.";
            builder.push("Nasty Skeleton");
            String sectionTrans = baseTrans + "skeleton.";
            this.minHealth = builder.comment("Minimum health").translation(sectionTrans + "min_health").defineInRange("MinHealth", () -> 20.0, 4.0, 5000.0);
            this.maxHealth = builder.comment("Maximum health").translation(sectionTrans + "max_health").defineInRange("MaxHealth", () -> 46.0, 20.0, 5000.0);
            this.minDistance = builder.comment("Minimum Distance").translation(sectionTrans + "min_distance").defineInRange("MinDistance", () -> 500.0, 0.0, 1280000.0);
            this.maxDistance = builder.comment("Maximum Distance").translation(sectionTrans + "max_distance").defineInRange("MaxDistance", () -> 22500.0, 0.0, 1280000.0);
            this.bonusPower = builder.comment("Bonus Power").translation(sectionTrans + "bonus_power").defineInRange("BonusPower", 3, 0, 10);
            this.bonusHardPower = builder.comment("Bonus Power for Hard").translation(sectionTrans + "bonus_hard_power").defineInRange("BonusHardPower", 7, 0, 20);
            this.magicDamage = builder.comment("Magic Damage for arrow used by purple skeleton").translation(sectionTrans + "magic_damage").defineInRange("MagicDamage", 3, 0, 50);
            this.poisonTime = builder.comment("Poison Time").translation(sectionTrans + "poison_time").defineInRange("PoisonTime", 9, 1, 30);
            this.yellowTime = builder.comment("Yellow skeleton effect Time").translation(sectionTrans + "yellow_time").defineInRange("YellowTime", 7, 1, 30);
            this.spawnBiome = builder.comment("Spawn in Biome weight").translation(sectionTrans + "spawn_biome").defineInRange("SpawnBiome", 100, 0, 200);
            this.spawnFeature = builder.comment("Spawn in Feature weight").translation(sectionTrans + "spawn_feature").defineInRange("SpawnFeature", 5, 0, 20);
            this.spawnDungeon = builder.comment("Spawn in Dungeon weight").translation(sectionTrans + "spawn_dungeon").defineInRange("SpawnDungeon", 100, 0, 200);
            this.spawnLightLevel = builder.comment("Spawn light level (use 7 to be same as normal skeletons)").translation(sectionTrans + "spawn_light_level").defineInRange("SpawnLightLevel", 9, 0, 15);
            this.arrowDamageMultiplier = builder.comment("Arrow Damage Multiplier (damage to skeleton)").translation(sectionTrans + "arrow_damage_multiplier").defineInRange("ArrowDamageMultiplier", () -> 0.5, 0.0, 1.0);
            this.addInaccuracy = builder.comment("Add inaccuracy to shot").translation(sectionTrans + "add_inaccuracy").defineInRange("AddInaccuracy", () -> 0.7, 0.0, 1.0);
            this.explosiveArrowOnArmor = builder.comment("Explosive Arrow cause Armor to drop").translation(sectionTrans + "explosive_arrow_armor").define("ExplosiveArrowOnArmor", true);
            this.explosiveArrowOnBlock = builder.comment("Explosive Arrow cause Block to drop").translation(sectionTrans + "explosive_arrow_block").define("ExplosiveArrowOnBlock", true);
            this.explosiveArrowOnShield = builder.comment("Explosive Arrow cause Shield to drop").translation(sectionTrans + "explosive_arrow_shield").define("ExplosiveArrowOnShield", false);
            this.useBlindness = builder.comment("Use blindness instead of nausea for the yellow skeleton").translation(sectionTrans + "use_blindness").define("UseBlindness", false);
            this.explosiveArrowStrength = builder.comment("Explosive Arrow strength").translation(sectionTrans + "explosive_arrow_strength").defineInRange("ExplosiveArrowStrength", () -> 8.0, 1.0, 1500.0);
            this.virusDistance = builder.comment("Virus Distance for spreading").translation(sectionTrans + "virus_distance").defineInRange("VirusDistance", () -> 5.0, 0.0, 20.0);
            this.virusChance = builder.comment("Virus Chance for spreading").translation(sectionTrans + "virus_chance").defineInRange("VirusChance", () -> 0.02, 0.0, 1.0);
            this.spawnTempBased = builder.comment("Spawn type based on Tempature").translation(sectionTrans + "spawn_type_temp_based").define("SpawnTempBased", false);
            this.spawnVariantWeights = builder.comment("Spawn weights (Green,Red,Purple,Cyan,Orange,Yellow)").translation(sectionTrans + "spawn_weights").define("SpawnVariantWeights", (Object)"5,5,5,5,5,1");
            this.biomeAdjustments = builder.comment("Biome adjustments (biome,variant,hp,speed)").translation(sectionTrans + "biome_adjuments").defineList("BiomeAdjustments", biomeAdjList, Common::isString);
            builder.pop();
            builder.push("Nasty Wolf");
            sectionTrans = baseTrans + "wolf.";
            this.virusMode2 = builder.comment("Virus Mode").translation(sectionTrans + "virus_mode").defineEnum("VirusMode", (Enum)VMode.WILD);
            this.virusChance2 = builder.comment("Virus Chance for spreading").translation(sectionTrans + "virus_chance").defineInRange("VirusChance", () -> 0.25, 0.0, 1.0);
            builder.pop();
        }

        public static boolean isString(Object o) {
            return o instanceof String;
        }
    }

    public static enum VMode {
        OFF,
        WILD,
        UNNAMED;

    }
}

