/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.nasty.entity;

import com.lupicus.nasty.config.MyConfig;
import com.lupicus.nasty.entity.NastySkeletonEntity;
import com.lupicus.nasty.entity.NastyWolfEntity;
import com.lupicus.nasty.renderer.entity.NastySkeletonRenderer;
import com.lupicus.nasty.renderer.entity.NastyWolfRenderer;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModEntities {
    public static final EntityType<NastySkeletonEntity> NASTY_SKELETON = ModEntities.register("skeleton", EntityType.Builder.m_20704_(NastySkeletonEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.99f).m_20702_(8));
    public static final EntityType<NastyWolfEntity> NASTY_WOLF = ModEntities.register("wolf", EntityType.Builder.m_20704_(NastyWolfEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 0.85f).m_20702_(8));

    private static <T extends Entity> EntityType<T> register(String name, EntityType.Builder<T> builder) {
        String key = "nasty:" + name;
        EntityType type = builder.m_20712_(key);
        type.setRegistryName(key);
        return type;
    }

    public static void register(IForgeRegistry<EntityType<?>> forgeRegistry) {
        forgeRegistry.registerAll((IForgeRegistryEntry[])new EntityType[]{NASTY_SKELETON, NASTY_WOLF});
        SpawnPlacements.m_21754_(NASTY_SKELETON, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, NastySkeletonEntity::checkSpawnRules);
        SpawnPlacements.m_21754_(NASTY_WOLF, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, NastyWolfEntity::checkSpawnRules);
    }

    public static void onAttribute(EntityAttributeCreationEvent event) {
        event.put(NASTY_SKELETON, NastySkeletonEntity.createAttributes().m_22265_());
        event.put(NASTY_WOLF, NastyWolfEntity.createAttributes().m_22265_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setupClient(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(NASTY_SKELETON, NastySkeletonRenderer::new);
        event.registerEntityRenderer(NASTY_WOLF, NastyWolfRenderer::new);
    }

    public static void addSpawnData() {
        int val = MyConfig.spawnDungeon;
        if (val > 0) {
            DungeonHooks.addDungeonMob(NASTY_SKELETON, (int)val);
        }
    }

    public static void removeSpawnData() {
        DungeonHooks.removeDungeonMob(NASTY_SKELETON);
    }

    public static void getBiomeSpawnData(List<EntityType<?>> mobs, List<MobSpawnSettings.SpawnerData> spawns) {
        int val = MyConfig.spawnBiome;
        if (val > 0) {
            mobs.add(EntityType.f_20524_);
            spawns.add(new MobSpawnSettings.SpawnerData(NASTY_SKELETON, val, 1, 3));
        }
    }

    public static void getFeatureSpawnData(List<EntityType<?>> mobs, List<MobSpawnSettings.SpawnerData> spawns) {
        int val = MyConfig.spawnFeature;
        if (val > 0) {
            mobs.add(EntityType.f_20524_);
            spawns.add(new MobSpawnSettings.SpawnerData(NASTY_SKELETON, val, 3, 4));
        }
    }
}

