/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.nasty;

import com.lupicus.nasty.config.MyConfig;
import com.lupicus.nasty.entity.ModEntities;
import com.lupicus.nasty.item.ModItems;
import com.lupicus.nasty.sound.ModSounds;
import com.lupicus.nasty.util.ModBiomeModifier;
import com.lupicus.nasty.util.ModStructureModifier;
import com.lupicus.nasty.util.SpawnData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

@Mod(value="nasty")
public class Main {
    public static final String MODID = "nasty";

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MyConfig.COMMON_SPEC);
        MinecraftForge.EVENT_BUS.register(SpawnData.class);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ModItems.setup());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void setupClient(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public void setupServer(FMLDedicatedServerSetupEvent event) {
    }

    @Mod.EventBusSubscriber
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onServerStarting(ServerStartingEvent event) {
            ModEntities.addSpawnData();
        }

        @SubscribeEvent
        public static void onServerStopping(ServerStoppingEvent event) {
            ModEntities.removeSpawnData();
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void onRegister(RegisterEvent event) {
            @NotNull ResourceKey key = event.getRegistryKey();
            if (key.equals((Object)ForgeRegistries.Keys.ITEMS)) {
                ModItems.register((IForgeRegistry<Item>)event.getForgeRegistry());
            } else if (key.equals((Object)ForgeRegistries.Keys.ENTITY_TYPES)) {
                ModEntities.register(event.getForgeRegistry());
            } else if (key.equals((Object)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS)) {
                ModBiomeModifier.register((IForgeRegistry<Object>)event.getForgeRegistry());
            } else if (key.equals((Object)ForgeRegistries.Keys.STRUCTURE_MODIFIER_SERIALIZERS)) {
                ModStructureModifier.register((IForgeRegistry<Object>)event.getForgeRegistry());
            } else if (key.equals((Object)ForgeRegistries.Keys.SOUND_EVENTS)) {
                ModSounds.register((IForgeRegistry<SoundEvent>)event.getForgeRegistry());
            }
        }

        @SubscribeEvent
        public static void onCreativeTab(CreativeModeTabEvent.BuildContents event) {
            ModItems.setupTabs(event);
        }

        @SubscribeEvent
        public static void onRenderers(EntityRenderersEvent.RegisterRenderers event) {
            ModEntities.setupClient(event);
        }

        @SubscribeEvent
        public static void onAttribute(EntityAttributeCreationEvent event) {
            ModEntities.onAttribute(event);
        }
    }
}

