/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.nasty.entity;

import com.lupicus.nasty.config.MyConfig;
import com.lupicus.nasty.sound.ModSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class ExplosiveArrowEntity
extends Arrow {
    private BlockPos target;

    public ExplosiveArrowEntity(EntityType<? extends Arrow> type, Level world) {
        super(type, world);
    }

    public ExplosiveArrowEntity(Level worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public ExplosiveArrowEntity(Level worldIn, LivingEntity shooter) {
        super(worldIn, shooter);
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        super.m_6532_(raytraceResultIn);
        if (raytraceResultIn.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult result = (BlockHitResult)raytraceResultIn;
            this.target = result.m_82425_();
            this.createExplosion((double)this.target.m_123341_() + 0.5, (double)this.target.m_123342_() + 0.5, (double)this.target.m_123343_() + 0.5, 0.5f, Explosion.BlockInteraction.DESTROY);
            this.m_146870_();
        }
    }

    private Explosion createExplosion(double x, double y, double z, float r, Explosion.BlockInteraction mode) {
        return this.createExplosion(null, x, y, z, r, mode);
    }

    private Explosion createExplosion(@Nullable DamageSource source, double x, double y, double z, float r, Explosion.BlockInteraction mode) {
        if (!(this.f_19853_ instanceof ServerLevel)) {
            return null;
        }
        ServerLevel world = (ServerLevel)this.f_19853_;
        SimpleExplosion e = new SimpleExplosion((Level)world, (Entity)this, source, null, x, y, z, r, false, mode);
        if (ForgeEventFactory.onExplosionStart((Level)world, (Explosion)e)) {
            return e;
        }
        e.m_46061_();
        e.m_46075_(false);
        if (mode == Explosion.BlockInteraction.KEEP) {
            e.m_46080_();
        }
        for (ServerPlayer serverplayerentity : world.m_6907_()) {
            if (!(serverplayerentity.m_20275_(x, y, z) < 4096.0)) continue;
            serverplayerentity.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(x, y, z, r, e.m_46081_(), (Vec3)e.m_46078_().get(serverplayerentity)));
        }
        return e;
    }

    public boolean m_7349_(Explosion explosionIn, BlockGetter worldIn, BlockPos pos, BlockState blockStateIn, float f) {
        if (!this.target.equals((Object)pos)) {
            return false;
        }
        return MyConfig.explosiveArrowOnBlock;
    }

    protected void m_5790_(EntityHitResult raytraceResultIn) {
        Entity entity = raytraceResultIn.m_82443_();
        LivingEntity le = null;
        boolean blocking = false;
        EquipmentSlot slot = EquipmentSlot.OFFHAND;
        double rot = 0.0;
        if (MyConfig.explosiveArrowOnArmor && entity instanceof LivingEntity) {
            le = (LivingEntity)entity;
            if (MyConfig.explosiveArrowOnShield) {
                Object se = this.m_37282_();
                if (se == null) {
                    se = this;
                }
                if ((blocking = this.isDamageSourceBlocked(le, (Entity)se)) && le.m_7655_() == InteractionHand.MAIN_HAND) {
                    slot = EquipmentSlot.MAINHAND;
                }
            }
            rot = this.m_146908_();
        }
        super.m_5790_(raytraceResultIn);
        if (blocking || le != null && rot == (double)this.m_146908_()) {
            ItemStack stack;
            if (!blocking) {
                slot = EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)this.f_19796_.m_188503_(4));
            }
            if (!(stack = le.m_6844_(slot)).m_41619_()) {
                le.m_8061_(slot, ItemStack.f_41583_);
                Vec3 pos = le.m_20182_();
                ItemEntity itementity = new ItemEntity(le.f_19853_, pos.f_82479_, pos.f_82480_ + 1.0, pos.f_82481_, stack);
                itementity.m_32060_();
                float f = this.f_19796_.m_188501_() * 0.5f;
                float f1 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                itementity.m_20334_((double)(-Mth.m_14031_((float)f1) * f), 0.2, (double)(Mth.m_14089_((float)f1) * f));
                le.f_19853_.m_7967_((Entity)itementity);
                le.f_19853_.m_6263_(null, le.m_20185_(), le.m_20186_(), le.m_20189_(), ModSounds.ARMOR_DROP, le.m_5720_(), 1.0f, 1.0f);
            }
            if (this.m_6084_()) {
                this.m_146870_();
            }
        }
    }

    private boolean isDamageSourceBlocked(LivingEntity target, Entity source) {
        if (target.m_21254_() && this.m_36796_() <= 0) {
            Vec3 vec3d2 = source.m_20182_();
            Vec3 vec3d = target.m_20252_(1.0f);
            Vec3 vec3d1 = vec3d2.m_82505_(target.m_20182_()).m_82541_();
            vec3d1 = new Vec3(vec3d1.f_82479_, 0.0, vec3d1.f_82481_);
            if (vec3d1.m_82526_(vec3d) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public float m_7077_(Explosion explosionIn, BlockGetter worldIn, BlockPos pos, BlockState blockStateIn, FluidState ifluidstateIn, float f2) {
        return f2 / MyConfig.explosiveArrowStrength;
    }

    public static class SimpleExplosion
    extends Explosion {
        private double x;
        private double y;
        private double z;
        private Level world;
        private Entity exploder;

        public SimpleExplosion(Level worldIn, Entity exploderIn, @Nullable DamageSource dmgsrc, @Nullable ExplosionDamageCalculator ctx, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, Explosion.BlockInteraction modeIn) {
            super(worldIn, exploderIn, dmgsrc, ctx, xIn, yIn, zIn, sizeIn, causesFireIn, modeIn);
            this.world = worldIn;
            this.x = xIn;
            this.y = yIn;
            this.z = zIn;
            this.exploder = exploderIn;
        }

        public void m_46061_() {
            List list = this.m_46081_();
            BlockPos blockpos = new BlockPos(this.x, this.y, this.z);
            BlockState blockstate = this.world.m_8055_(blockpos);
            FluidState fluidstate = this.world.m_6425_(blockpos);
            if (!blockstate.m_60795_() || !fluidstate.m_76178_()) {
                float f2 = Math.max(blockstate.getExplosionResistance((BlockGetter)this.world, blockpos, (Explosion)this), fluidstate.getExplosionResistance((BlockGetter)this.world, blockpos, (Explosion)this));
                if (this.exploder != null) {
                    f2 = this.exploder.m_7077_((Explosion)this, (BlockGetter)this.world, blockpos, blockstate, fluidstate, f2);
                }
                if (f2 < 1.0f && (this.exploder == null || this.exploder.m_7349_((Explosion)this, (BlockGetter)this.world, blockpos, blockstate, f2))) {
                    list.add(blockpos);
                }
            }
        }
    }
}

