/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.common;

import com.hexagram2021.oceanworld.common.OWSounds;
import com.hexagram2021.oceanworld.common.entities.OysterEntity;
import com.hexagram2021.oceanworld.common.entities.SeaCucumberEntity;
import com.hexagram2021.oceanworld.common.register.OWBlocks;
import com.hexagram2021.oceanworld.common.register.OWEntities;
import com.hexagram2021.oceanworld.common.register.OWFeatures;
import com.hexagram2021.oceanworld.common.register.OWItems;
import com.hexagram2021.oceanworld.common.register.OWPlacedFeatures;
import com.hexagram2021.oceanworld.common.register.OWProcessorType;
import com.hexagram2021.oceanworld.common.register.OWProcessors;
import com.hexagram2021.oceanworld.common.register.OWStructurePieceTypes;
import com.hexagram2021.oceanworld.common.register.OWStructureSets;
import com.hexagram2021.oceanworld.common.register.OWStructureTypes;
import com.hexagram2021.oceanworld.common.register.OWStructures;
import com.hexagram2021.oceanworld.common.spawns.RaiderTypes;
import com.hexagram2021.oceanworld.world.pools.AristocratsResidencePools;
import java.util.function.Consumer;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(modid="oceanworld", bus=Mod.EventBusSubscriber.Bus.MOD)
public class OWContent {
    public static void modConstruction(IEventBus bus, Consumer<Runnable> runLater) {
        OWBlocks.init(bus);
        OWItems.init(bus);
        OWFeatures.init(bus);
        AristocratsResidencePools.bootstrap();
    }

    @SubscribeEvent
    public static void onRegister(RegisterEvent event) {
        OWSounds.init(event);
        OWProcessorType.init(event);
        OWProcessors.init(event);
        OWStructureTypes.init();
        OWStructurePieceTypes.init();
        OWStructures.init();
        OWStructureSets.init();
        OWEntities.init(event);
        RaiderTypes.init();
    }

    public static void init(FMLCommonSetupEvent event) {
        OWPlacedFeatures.init();
        event.enqueueWork(() -> {
            SpawnPlacements.m_21754_(OWEntities.SEA_CUCUMBER, (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SeaCucumberEntity::checkSeaCucumberSpawnRules);
            SpawnPlacements.m_21754_(OWEntities.OCEANOLOGER, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::m_219025_);
            SpawnPlacements.m_21754_(OWEntities.BLACKLIP_OYSTER, (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, OysterEntity::checkOysterSpawnRules);
            SpawnPlacements.m_21754_(OWEntities.WHITELIP_OYSTER, (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, OysterEntity::checkOysterSpawnRules);
        });
    }
}

