/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.common.config;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hexagram2021.oceanworld.common.OWLogger;
import com.hexagram2021.oceanworld.common.config.IConfigHelper;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class OWCommonConfig {
    public static final File filePath = new File("./config/");
    private static final File configFile = new File(filePath + "/oceanworld-config.json");
    private static final File readmeFile = new File(filePath + "/oceanworld-config-readme.md");
    public static final FloatConfigValue MUSHROOM_FIELDS_TO_DEEP_OCEAN_CONTINENTALNESS = new FloatConfigValue("MUSHROOM_FIELDS_TO_DEEP_OCEAN_CONTINENTALNESS", -1.01f, -1.2f, 1.2f);
    public static final FloatConfigValue DEEP_OCEAN_TO_OCEAN_CONTINENTALNESS = new FloatConfigValue("DEEP_OCEAN_TO_OCEAN_CONTINENTALNESS", 0.34f, -1.2f, 1.2f);
    public static final FloatConfigValue OCEAN_TO_COAST_CONTINENTALNESS = new FloatConfigValue("OCEAN_TO_COAST_CONTINENTALNESS", 0.42f, -1.2f, 1.2f);
    public static final FloatConfigValue COAST_TO_INLAND_CONTINENTALNESS = new FloatConfigValue("COAST_TO_INLAND_CONTINENTALNESS", 0.51f, -1.2f, 1.2f);
    public static final FloatConfigValue NEAR_INLAND_TO_MID_INLAND_CONTINENTALNESS = new FloatConfigValue("NEAR_INLAND_TO_MID_INLAND_CONTINENTALNESS", 0.62f, -1.2f, 1.2f);
    public static final FloatConfigValue MID_INLAND_TO_MOUNTAINS_CONTINENTALNESS = new FloatConfigValue("MID_INLAND_TO_MOUNTAINS_CONTINENTALNESS", 0.785f, -1.2f, 1.2f);
    public static final FloatConfigValue PEAKS_CONTINENTALNESS = new FloatConfigValue("PEAKS_CONTINENTALNESS", 0.9f, -1.2f, 1.2f);
    public static final FloatConfigValue MUSHROOM_FIELDS_TO_DEEP_OCEAN_SHAPER = new FloatConfigValue("MUSHROOM_FIELDS_TO_DEEP_OCEAN_SHAPER", -0.99f, -1.2f, 1.2f);
    public static final FloatConfigValue DEEP_OCEAN_TO_OCEAN_SHAPER = new FloatConfigValue("DEEP_OCEAN_TO_OCEAN_SHAPER", 0.31f, -1.2f, 1.2f);
    public static final FloatConfigValue OCEAN_TO_COAST_SHAPER = new FloatConfigValue("OCEAN_TO_COAST_SHAPER", 0.395f, -1.2f, 1.2f);
    public static final FloatConfigValue COAST_WATER_SHAPER = new FloatConfigValue("COAST_WATER_SHAPER", 0.43f, -1.2f, 1.2f);
    public static final FloatConfigValue COAST_BANK_SHAPER = new FloatConfigValue("COAST_BANK_SHAPER", 0.47f, -1.2f, 1.2f);
    public static final FloatConfigValue COAST_LAND_SHAPER = new FloatConfigValue("COAST_LAND_SHAPER", 0.48f, -1.2f, 1.2f);
    public static final FloatConfigValue NEAR_INLAND_SHAPER = new FloatConfigValue("NEAR_INLAND_SHAPER", 0.52f, -1.2f, 1.2f);
    public static final FloatConfigValue INLAND_EROSION_SHAPER = new FloatConfigValue("INLAND_EROSION_SHAPER", 0.64f, -1.2f, 1.2f);
    public static final FloatConfigValue MID_INLAND_SHAPER = new FloatConfigValue("MID_INLAND_SHAPER", 0.76f, -1.2f, 1.2f);
    public static final FloatConfigValue PEAKS_EROSION_SHAPER = new FloatConfigValue("PEAKS_EROSION_SHAPER", 0.92f, -1.2f, 1.2f);

    private static void lazyInit() {
        block15: {
            try {
                if (!filePath.exists() && !filePath.mkdir()) {
                    OWLogger.LOGGER.error("Could not mkdir " + filePath);
                    break block15;
                }
                if (configFile.exists()) {
                    try (FileReader reader = new FileReader(configFile);){
                        JsonElement json = JsonParser.parseReader((Reader)reader);
                        OWCommonConfig.loadFromJson(json.getAsJsonObject());
                    }
                    OWCommonConfig.checkValues();
                    OWCommonConfig.saveConfig();
                } else if (configFile.createNewFile()) {
                    OWCommonConfig.saveConfig();
                } else {
                    OWLogger.LOGGER.error("Could not create new file " + configFile);
                }
                if (!readmeFile.exists()) {
                    if (readmeFile.createNewFile()) {
                        OWCommonConfig.fillReadmeFile();
                    } else {
                        OWLogger.LOGGER.error("Could not create new file " + readmeFile);
                    }
                }
            }
            catch (IOException e) {
                OWLogger.LOGGER.error("Error during loading config.", (Throwable)e);
            }
        }
    }

    private static void fillReadmeFile() throws IOException {
        try (FileWriter writer = new FileWriter(readmeFile);){
            writer.write("The continentalness values and shaper values MUST BE ASCENDING!\n\n");
            writer.write("If you modify these continentalness values, please remember to modify shaper values under the guide.\n\n");
            writer.write("For example, default values are:\n\n");
            writer.write("```json\n{\n");
            writer.write("\t\"MUSHROOM_FIELDS_TO_DEEP_OCEAN_CONTINENTALNESS\": -1.01,\n");
            writer.write("\t\"DEEP_OCEAN_TO_OCEAN_CONTINENTALNESS\": 0.34,\n");
            writer.write("\t\"OCEAN_TO_COAST_CONTINENTALNESS\": 0.42,\n");
            writer.write("\t\"COAST_TO_INLAND_CONTINENTALNESS\": 0.51,\n");
            writer.write("\t\"NEAR_INLAND_TO_MID_INLAND_CONTINENTALNESS\": 0.62,\n");
            writer.write("\t\"MID_INLAND_TO_MOUNTAINS_CONTINENTALNESS\": 0.785,\n");
            writer.write("\t\"PEAKS_CONTINENTALNESS\": 0.9,\n\n");
            writer.write("\t\"MUSHROOM_FIELDS_TO_DEEP_OCEAN_SHAPER\": -0.99,\n");
            writer.write("\t\"DEEP_OCEAN_TO_OCEAN_SHAPER\": 0.31,\n");
            writer.write("\t\"OCEAN_TO_COAST_SHAPER\": 0.395,\n");
            writer.write("\t\"COAST_WATER_SHAPER\": 0.43,\n");
            writer.write("\t\"COAST_BANK_SHAPER\": 0.47,\n");
            writer.write("\t\"COAST_LAND_SHAPER\": 0.48,\n");
            writer.write("\t\"NEAR_INLAND_SHAPER\": 0.52,\n");
            writer.write("\t\"INLAND_EROSION_SHAPER\": 0.64,\n");
            writer.write("\t\"MID_INLAND_SHAPER\": 0.76,\n");
            writer.write("\t\"PEAKS_EROSION_SHAPER\": 0.92\n");
            writer.write("}\n```\n\n");
            writer.write("Notice that the larger gap between two neighbor values, the more frequently it will generate. The example given above means deep ocean (-1.01~0.34) will generate most frequently.\n\n");
            writer.write("You can also try the value Vanilla uses:\n\n");
            writer.write("```json\n{\n");
            writer.write("\t\"MUSHROOM_FIELDS_TO_DEEP_OCEAN_CONTINENTALNESS\": -1.05,\n");
            writer.write("\t\"DEEP_OCEAN_TO_OCEAN_CONTINENTALNESS\": -0.455,\n");
            writer.write("\t\"OCEAN_TO_COAST_CONTINENTALNESS\": -0.19,\n");
            writer.write("\t\"COAST_TO_INLAND_CONTINENTALNESS\": -0.11,\n");
            writer.write("\t\"NEAR_INLAND_TO_MID_INLAND_CONTINENTALNESS\": 0.03,\n");
            writer.write("\t\"MID_INLAND_TO_MOUNTAINS_CONTINENTALNESS\": 0.3,\n");
            writer.write("\t\"PEAKS_CONTINENTALNESS\": 0.55,\n\n");
            writer.write("\t\"MUSHROOM_FIELDS_TO_DEEP_OCEAN_SHAPER\": -1.02,\n");
            writer.write("\t\"DEEP_OCEAN_TO_OCEAN_SHAPER\": -0.51,\n");
            writer.write("\t\"OCEAN_TO_COAST_SHAPER\": -0.44,\n");
            writer.write("\t\"COAST_WATER_SHAPER\": -0.18,\n");
            writer.write("\t\"COAST_BANK_SHAPER\": -0.16,\n");
            writer.write("\t\"COAST_LAND_SHAPER\": -0.15,\n");
            writer.write("\t\"NEAR_INLAND_SHAPER\": -0.1,\n");
            writer.write("\t\"INLAND_EROSION_SHAPER\": 0.06,\n");
            writer.write("\t\"MID_INLAND_SHAPER\": 0.25,\n");
            writer.write("\t\"PEAKS_EROSION_SHAPER\": 0.65\n");
            writer.write("}\n```\n\n");
            writer.write("And here are some constructive comments for you to modify the shaper values:\n\n");
            writer.write("- MUSHROOM_FIELDS_TO_DEEP_OCEAN_SHAPER should be greater than MUSHROOM_FIELDS_TO_DEEP_OCEAN_CONTINENTALNESS.\n");
            writer.write("- DEEP_OCEAN_TO_OCEAN_SHAPER should be a little less than DEEP_OCEAN_TO_OCEAN_CONTINENTALNESS.\n");
            writer.write("- OCEAN_TO_COAST_SHAPER should be between DEEP_OCEAN_TO_OCEAN_CONTINENTALNESS and OCEAN_TO_COAST_CONTINENTALNESS.\n");
            writer.write("- COAST_WATER_SHAPER should be close to OCEAN_TO_COAST_CONTINENTALNESS.\n");
            writer.write("- COAST_BANK_SHAPER should be between OCEAN_TO_COAST_CONTINENTALNESS and COAST_TO_INLAND_CONTINENTALNESS.\n");
            writer.write("- COAST_LAND_SHAPER should be a little greater than COAST_BANK_SHAPER.\n");
            writer.write("- NEAR_INLAND_SHAPER should be a little greater than COAST_TO_INLAND_CONTINENTALNESS.\n");
            writer.write("- INLAND_EROSION_SHAPER should be a little greater than NEAR_INLAND_TO_MID_INLAND_CONTINENTALNESS.\n");
            writer.write("- MID_INLAND_SHAPER should be a little less than MID_INLAND_TO_MOUNTAINS_CONTINENTALNESS.\n");
            writer.write("- PEAKS_EROSION_SHAPER should be a little greater than PEAKS_CONTINENTALNESS.\n\n");
        }
    }

    private static void loadFromJson(JsonObject jsonObject) {
        OWLogger.LOGGER.debug("Loading json config file.");
        IConfigValue.configValues.forEach(iConfigValue -> {
            if (jsonObject.has(iConfigValue.name())) {
                iConfigValue.parseAsValue(jsonObject.get(iConfigValue.name()));
            }
        });
    }

    private static void saveConfig() throws IOException {
        OWLogger.LOGGER.debug("Saving json config file.");
        try (FileWriter writer = new FileWriter(configFile);){
            JsonObject configJson = new JsonObject();
            IConfigValue.configValues.forEach(iConfigValue -> configJson.addProperty(iConfigValue.name(), iConfigValue.value()));
            IConfigHelper.writeJsonToFile(writer, null, (JsonElement)configJson, 0);
        }
    }

    public static void checkValue(FloatConfigValue less, FloatConfigValue greater) {
        if (less.value().floatValue() >= greater.value().floatValue() - 1.0E-6f) {
            throw new ConfigValueException(less.name() + " is greater than " + greater.name() + "! Please check your config file.");
        }
    }

    public static void checkValues() {
        IConfigValue.configValues.forEach(IConfigValue::checkValueRange);
        OWCommonConfig.checkValue(MUSHROOM_FIELDS_TO_DEEP_OCEAN_CONTINENTALNESS, DEEP_OCEAN_TO_OCEAN_CONTINENTALNESS);
        OWCommonConfig.checkValue(DEEP_OCEAN_TO_OCEAN_CONTINENTALNESS, OCEAN_TO_COAST_CONTINENTALNESS);
        OWCommonConfig.checkValue(OCEAN_TO_COAST_CONTINENTALNESS, COAST_TO_INLAND_CONTINENTALNESS);
        OWCommonConfig.checkValue(COAST_TO_INLAND_CONTINENTALNESS, NEAR_INLAND_TO_MID_INLAND_CONTINENTALNESS);
        OWCommonConfig.checkValue(NEAR_INLAND_TO_MID_INLAND_CONTINENTALNESS, MID_INLAND_TO_MOUNTAINS_CONTINENTALNESS);
        OWCommonConfig.checkValue(MID_INLAND_TO_MOUNTAINS_CONTINENTALNESS, PEAKS_CONTINENTALNESS);
        OWCommonConfig.checkValue(MUSHROOM_FIELDS_TO_DEEP_OCEAN_SHAPER, DEEP_OCEAN_TO_OCEAN_SHAPER);
        OWCommonConfig.checkValue(DEEP_OCEAN_TO_OCEAN_SHAPER, OCEAN_TO_COAST_SHAPER);
        OWCommonConfig.checkValue(OCEAN_TO_COAST_SHAPER, COAST_WATER_SHAPER);
        OWCommonConfig.checkValue(COAST_WATER_SHAPER, COAST_BANK_SHAPER);
        OWCommonConfig.checkValue(COAST_BANK_SHAPER, COAST_LAND_SHAPER);
        OWCommonConfig.checkValue(COAST_LAND_SHAPER, NEAR_INLAND_SHAPER);
        OWCommonConfig.checkValue(NEAR_INLAND_SHAPER, INLAND_EROSION_SHAPER);
        OWCommonConfig.checkValue(INLAND_EROSION_SHAPER, MID_INLAND_SHAPER);
        OWCommonConfig.checkValue(MID_INLAND_SHAPER, PEAKS_EROSION_SHAPER);
    }

    static {
        OWCommonConfig.lazyInit();
    }

    public static interface IConfigValue<T extends Number> {
        public static final List<IConfigValue<?>> configValues = Lists.newArrayList();

        public String name();

        public T value();

        public void parseAsValue(JsonElement var1);

        public void checkValueRange() throws ConfigValueException;
    }

    public static class FloatConfigValue
    implements IConfigValue<Float> {
        private final String name;
        private float value;
        private final float min;
        private final float max;

        public FloatConfigValue(String name, float value, float min, float max) {
            this.name = name;
            this.value = value;
            this.min = min;
            this.max = max;
            configValues.add(this);
        }

        @Override
        public void checkValueRange() throws ConfigValueException {
            if (this.value > this.max || this.value < this.min) {
                throw new ConfigValueException(this.name + " is not in range [%f, %f]! Please check your config file.".formatted(Float.valueOf(this.min), Float.valueOf(this.max)));
            }
        }

        @Override
        public void parseAsValue(JsonElement element) {
            this.value = element.getAsFloat();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Float value() {
            return Float.valueOf(this.value);
        }
    }

    public static class ConfigValueException
    extends RuntimeException {
        public ConfigValueException(String message) {
            super(message);
        }
    }
}

