/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.common.entities;

import com.hexagram2021.oceanworld.common.OWSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OysterEntity
extends Animal
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(OysterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_OPEN = SynchedEntityData.m_135353_(OysterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    int openShellRemainTicks = 1;
    int closeShellRemainTicks = 0;
    int productPearlRemainTicks = 56000;

    protected OysterEntity(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.openShellRemainTicks == 1) {
            for (Mob mob : this.f_19853_.m_45976_(Mob.class, this.m_20191_().m_82400_(0.3))) {
                if (!mob.m_6084_() || mob == this) continue;
                this.touch(mob);
            }
        }
        if (this.openShellRemainTicks > 0) {
            if (!this.isOpen()) {
                this.setOpen(true);
            }
            --this.openShellRemainTicks;
            if (this.openShellRemainTicks <= 0) {
                this.setOpen(false);
                this.closeShellRemainTicks = 1200 + this.f_19796_.m_188503_(120);
            }
        } else {
            --this.closeShellRemainTicks;
            if (this.closeShellRemainTicks <= 0) {
                this.openShellRemainTicks = 80 + this.f_19796_.m_188503_(20);
            }
        }
        --this.productPearlRemainTicks;
        if (this.productPearlRemainTicks <= 0) {
            this.productPearlRemainTicks = 50000 + this.f_19796_.m_188503_(6000);
            this.m_19998_((ItemLike)this.dropPearlItem());
        }
    }

    private void touch(Mob mob) {
        if (mob.m_6469_(DamageSource.m_19370_((LivingEntity)this), 2.0f)) {
            this.m_216990_(OWSounds.OYSTER_ATTACK);
        }
    }

    public void m_6123_(@NotNull Player player) {
        if (this.m_6084_() && this.openShellRemainTicks == 1 && player instanceof ServerPlayer && player.m_6469_(DamageSource.m_19370_((LivingEntity)this), 2.0f)) {
            this.m_216990_(OWSounds.OYSTER_ATTACK);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(IS_OPEN, (Object)true);
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("FromBucket", this.m_27487_());
        nbt.m_128405_("OpenRemainTick", this.openShellRemainTicks);
        nbt.m_128405_("CloseRemainTick", this.closeShellRemainTicks);
        nbt.m_128405_("ProductRemainTick", this.productPearlRemainTicks);
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.m_27497_(nbt.m_128471_("FromBucket"));
        this.openShellRemainTicks = nbt.m_128451_("OpenRemainTick");
        this.closeShellRemainTicks = nbt.m_128451_("CloseRemainTick");
        this.productPearlRemainTicks = nbt.m_128451_("ProductRemainTick");
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public float m_5610_(@NotNull BlockPos blockPos, @NotNull LevelReader level) {
        return 0.0f;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return null;
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public boolean isOpen() {
        return (Boolean)this.f_19804_.m_135370_(IS_OPEN);
    }

    private void setOpen(boolean open) {
        this.f_19804_.m_135381_(IS_OPEN, (Object)open);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_142066_() {
        return this.isOpen() && super.m_142066_();
    }

    public int m_6062_() {
        return 6000;
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        if (!this.m_21525_()) {
            this.handleAirSupply(i);
        }
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float value) {
        if (this.isOpen()) {
            this.openShellRemainTicks = 1;
            return super.m_6469_(damageSource, value * 2.0f);
        }
        return super.m_6469_(damageSource, value);
    }

    protected void handleAirSupply(int airSupply) {
        if (this.m_6084_() && !this.m_20071_()) {
            this.m_20301_(airSupply - 1);
            if (this.m_20146_() == -40) {
                this.m_20301_(0);
                this.m_6469_(DamageSource.f_19324_, 1.0f);
            }
        } else {
            this.m_20301_(this.m_6062_());
        }
    }

    public void m_6872_(@NotNull ItemStack itemStack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)itemStack);
        CompoundTag nbt = itemStack.m_41784_();
        nbt.m_128405_("OpenRemainTick", this.openShellRemainTicks);
        nbt.m_128405_("CloseRemainTick", this.closeShellRemainTicks);
        nbt.m_128405_("ProductRemainTick", this.productPearlRemainTicks);
    }

    public void m_142278_(@NotNull CompoundTag nbt) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)nbt);
        if (nbt.m_128425_("FromBucket", 1)) {
            this.m_27497_(nbt.m_128471_("FromBucket"));
        }
        if (nbt.m_128425_("OpenRemainTick", 3)) {
            this.openShellRemainTicks = nbt.m_128451_("OpenRemainTick");
        }
        if (nbt.m_128425_("CloseRemainTick", 3)) {
            this.closeShellRemainTicks = nbt.m_128451_("CloseRemainTick");
        }
        if (nbt.m_128425_("ProductRemainTick", 3)) {
            this.productPearlRemainTicks = nbt.m_128451_("ProductRemainTick");
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return OWSounds.OYSTER_AMBIENT;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return OWSounds.OYSTER_HURT;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return OWSounds.OYSTER_DEATH;
    }

    @NotNull
    public SoundEvent m_142623_() {
        return OWSounds.BUCKET_FILL_OYSTER;
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    protected void m_7472_(@NotNull DamageSource damageSource, int looting, boolean recentlyHitIn) {
        super.m_7472_(damageSource, looting, recentlyHitIn);
        ItemStack itemStack = new ItemStack((ItemLike)this.dropPearlItem(), this.f_19796_.m_188503_(looting + 1));
        this.m_19983_(itemStack);
    }

    @NotNull
    protected abstract Item dropPearlItem();

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public static boolean checkOysterSpawnRules(EntityType<? extends OysterEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        int brightness = level.m_45517_(LightLayer.SKY, pos);
        return brightness > 0 && pos.m_123342_() < 56 && pos.m_123342_() >= 8 && level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }
}

