/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.common.register;

import com.hexagram2021.oceanworld.common.register.OWBiomeTags;
import com.hexagram2021.oceanworld.common.register.OWEntities;
import com.hexagram2021.oceanworld.common.register.OWStructureKeys;
import com.hexagram2021.oceanworld.world.structures.AristocratsResidenceFeature;
import com.hexagram2021.oceanworld.world.structures.IllusionerShelterFeature;
import com.hexagram2021.oceanworld.world.structures.OceanAltarFeature;
import com.hexagram2021.oceanworld.world.structures.OceanologerShipFeature;
import com.hexagram2021.oceanworld.world.structures.PrismarineCastleFeature;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;

public class OWStructures {
    public static final Holder<Structure> OCEAN_ALTAR = OWStructures.register(OWStructureKeys.OCEAN_ALTAR, new OceanAltarFeature(OWStructures.structure(OWBiomeTags.HAS_OCEAN_ALTAR, TerrainAdjustment.BEARD_THIN)));
    public static final Holder<Structure> ILLUSIONER_SHELTER = OWStructures.register(OWStructureKeys.ILLUSIONER_SHELTER, new IllusionerShelterFeature(OWStructures.structure(OWBiomeTags.HAS_ILLUSIONER_SHELTER, Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.f_20459_, 5, 1, 2)}))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
    public static final Holder<Structure> PRISMARINE_CASTLE = OWStructures.register(OWStructureKeys.PRISMARINE_CASTLE, new PrismarineCastleFeature(OWStructures.structure(OWBiomeTags.HAS_PRISMARINE_CASTLE, TerrainAdjustment.BEARD_THIN)));
    public static final Holder<Structure> ARISTOCRATS_RESIDENCE = OWStructures.register(OWStructureKeys.ARISTOCRATS_RESIDENCE, new AristocratsResidenceFeature(OWStructures.structure(OWBiomeTags.HAS_ARISTOCRATS_RESIDENCE, Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.f_20562_, 5, 1, 4)}))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_BOX)));
    public static final Holder<Structure> OCEANOLOGER_SHIP = OWStructures.register(OWStructureKeys.OCEANOLOGER_SHIP, new OceanologerShipFeature(OWStructures.structure(OWBiomeTags.HAS_OCEANOLOGER_SHIP, Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(OWEntities.OCEANOLOGER, 10, 1, 1)}))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));

    public static void init() {
    }

    private static Holder<Structure> register(ResourceKey<Structure> id, Structure structure) {
        return BuiltinRegistries.m_206384_((Registry)BuiltinRegistries.f_235988_, id, (Object)structure);
    }

    private static Structure.StructureSettings structure(TagKey<Biome> biome, Map<MobCategory, StructureSpawnOverride> mobs, GenerationStep.Decoration step, TerrainAdjustment adjustment) {
        return new Structure.StructureSettings(OWStructures.biomes(biome), mobs, step, adjustment);
    }

    private static Structure.StructureSettings structure(TagKey<Biome> biome, TerrainAdjustment adjustment) {
        return OWStructures.structure(biome, Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, adjustment);
    }

    private static HolderSet<Biome> biomes(TagKey<Biome> biome) {
        return BuiltinRegistries.f_123865_.m_203561_(biome);
    }
}

