/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.hexagram2021.oceanworld.common.OWLogger;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;

public class OceanJigsawPlacement {
    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext context, Holder<StructureTemplatePool> pool, @Nullable ResourceLocation piece, int maxDepth, BlockPos blockPos, boolean expansion, int maxD) {
        BlockPos blockpos;
        RegistryAccess registryaccess = context.f_226621_();
        ChunkGenerator chunkgenerator = context.f_226622_();
        StructureTemplateManager structuretemplatemanager = context.f_226625_();
        LevelHeightAccessor level = context.f_226629_();
        WorldgenRandom random = context.f_226626_();
        Registry registry = registryaccess.m_175515_(Registry.f_122884_);
        Rotation rotation = Rotation.m_221990_((RandomSource)random);
        StructureTemplatePool structuretemplatepool = (StructureTemplatePool)pool.m_203334_();
        StructurePoolElement structurepoolelement = structuretemplatepool.m_227355_((RandomSource)random);
        if (structurepoolelement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        if (piece != null) {
            Optional<BlockPos> optional = OceanJigsawPlacement.getRandomNamedJigsaw(structurepoolelement, piece, blockPos, rotation, structuretemplatemanager, random);
            if (optional.isEmpty()) {
                OWLogger.LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)piece, (Object)Objects.requireNonNull(pool.m_203543_().orElse(null)).m_135782_());
                return Optional.empty();
            }
            blockpos = optional.get();
        } else {
            blockpos = blockPos;
        }
        BlockPos vec3i = blockpos.m_121996_((Vec3i)blockPos);
        BlockPos blockpos1 = blockPos.m_121996_((Vec3i)vec3i);
        PoolElementStructurePiece element = new PoolElementStructurePiece(structuretemplatemanager, structurepoolelement, blockpos1, structurepoolelement.m_210540_(), rotation, structurepoolelement.m_214015_(structuretemplatemanager, blockpos1, rotation));
        BoundingBox boundingbox = element.m_73547_();
        int i = (boundingbox.m_162399_() + boundingbox.m_162395_()) / 2;
        int j = (boundingbox.m_162401_() + boundingbox.m_162398_()) / 2;
        int k = blockPos.m_123342_() + chunkgenerator.m_223221_(i, j, Heightmap.Types.OCEAN_FLOOR_WG, level, context.f_226624_());
        int l = boundingbox.m_162396_() + element.m_72647_();
        element.m_6324_(0, k - l, 0);
        int i1 = k + vec3i.m_123342_();
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, i1, j), builder -> {
            ArrayList list = Lists.newArrayList();
            list.add(element);
            if (maxDepth > 0) {
                AABB aabb = new AABB((double)(i - maxD), (double)(i1 - maxD), (double)(j - maxD), (double)(i + maxD + 1), (double)(i1 + maxD + 1), (double)(j + maxD + 1));
                VoxelShape voxelshape = Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)aabb), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)), (BooleanOp)BooleanOp.f_82685_);
                OceanJigsawPlacement.addPieces(context.f_226624_(), maxDepth, expansion, chunkgenerator, structuretemplatemanager, level, (RandomSource)random, (Registry<StructureTemplatePool>)registry, element, list, voxelshape);
                list.forEach(arg_0 -> ((StructurePiecesBuilder)builder).m_142679_(arg_0));
            }
        }));
    }

    private static Optional<BlockPos> getRandomNamedJigsaw(StructurePoolElement poolElement, ResourceLocation piece, BlockPos blockPos, Rotation rotation, StructureTemplateManager manager, WorldgenRandom random) {
        List list = poolElement.m_213638_(manager, blockPos, rotation, (RandomSource)random);
        Optional<BlockPos> optional = Optional.empty();
        for (StructureTemplate.StructureBlockInfo blockInfo : list) {
            ResourceLocation resourcelocation = ResourceLocation.m_135820_((String)blockInfo.f_74677_.m_128461_("name"));
            if (!piece.equals((Object)resourcelocation)) continue;
            optional = Optional.of(blockInfo.f_74675_);
            break;
        }
        return optional;
    }

    private static void addPieces(RandomState randomState, int depth, boolean expansion, ChunkGenerator chunkGenerator, StructureTemplateManager manager, LevelHeightAccessor level, RandomSource random, Registry<StructureTemplatePool> pools, PoolElementStructurePiece piece, List<PoolElementStructurePiece> pieces, VoxelShape shape) {
        Placer placer = new Placer(pools, depth, chunkGenerator, manager, pieces, random);
        placer.placing.addLast(new PieceState(piece, (MutableObject<VoxelShape>)new MutableObject((Object)shape), 0));
        while (!placer.placing.isEmpty()) {
            PieceState pieceState = placer.placing.removeFirst();
            placer.tryPlacingChildren(pieceState.piece, pieceState.free, pieceState.depth, expansion, level, randomState);
        }
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource random;
        final Deque<PieceState> placing = Queues.newArrayDeque();

        Placer(Registry<StructureTemplatePool> pools, int depth, ChunkGenerator chunkGenerator, StructureTemplateManager manager, List<? super PoolElementStructurePiece> pieces, RandomSource random) {
            this.pools = pools;
            this.maxDepth = depth;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = manager;
            this.pieces = pieces;
            this.random = random;
        }

        void tryPlacingChildren(PoolElementStructurePiece piece, MutableObject<VoxelShape> shape, int depth, boolean expansion, LevelHeightAccessor level, RandomState random) {
            StructurePoolElement structurepoolelement = piece.m_209918_();
            BlockPos blockpos = piece.m_72646_();
            Rotation rotation = piece.m_6830_();
            StructureTemplatePool.Projection projection = structurepoolelement.m_210539_();
            boolean flag = projection == StructureTemplatePool.Projection.RIGID;
            MutableObject<VoxelShape> mutableobject = new MutableObject<VoxelShape>();
            BoundingBox boundingbox = piece.m_73547_();
            int i = boundingbox.m_162396_();
            block0: for (StructureTemplate.StructureBlockInfo jigsawInfo : structurepoolelement.m_213638_(this.structureTemplateManager, blockpos, rotation, this.random)) {
                Direction direction = JigsawBlock.m_54250_((BlockState)jigsawInfo.f_74676_);
                BlockPos blockpos1 = jigsawInfo.f_74675_;
                BlockPos blockpos2 = blockpos1.m_121945_(direction);
                int j = blockpos1.m_123342_() - i;
                int k = -1;
                ResourceLocation pool1 = new ResourceLocation(jigsawInfo.f_74677_.m_128461_("pool"));
                Optional optional = this.pools.m_6612_(pool1);
                if (optional.isPresent() && (((StructureTemplatePool)optional.get()).m_210590_() != 0 || Objects.equals(pool1, Pools.f_127186_.m_135782_()))) {
                    ResourceLocation resourcelocation1 = ((StructureTemplatePool)optional.get()).m_210573_();
                    Optional optional1 = this.pools.m_6612_(resourcelocation1);
                    if (optional1.isPresent() && (((StructureTemplatePool)optional1.get()).m_210590_() != 0 || Objects.equals(resourcelocation1, Pools.f_127186_.m_135782_()))) {
                        StructurePoolElement nextElement;
                        MutableObject<VoxelShape> mutableobject1;
                        boolean flag1 = boundingbox.m_71051_((Vec3i)blockpos2);
                        if (flag1) {
                            mutableobject1 = mutableobject;
                            if (mutableobject.getValue() == null) {
                                mutableobject.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)));
                            }
                        } else {
                            mutableobject1 = shape;
                        }
                        ArrayList list = Lists.newArrayList();
                        if (depth != this.maxDepth) {
                            list.addAll(((StructureTemplatePool)optional.get()).m_227362_(this.random));
                        }
                        list.addAll(((StructureTemplatePool)optional1.get()).m_227362_(this.random));
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext() && (nextElement = (StructurePoolElement)iterator.next()) != EmptyPoolElement.f_210175_) {
                            for (Rotation rotation1 : Rotation.m_221992_((RandomSource)this.random)) {
                                List nextJigsawBlocks = nextElement.m_213638_(this.structureTemplateManager, BlockPos.f_121853_, rotation1, this.random);
                                BoundingBox nextbbox = nextElement.m_214015_(this.structureTemplateManager, BlockPos.f_121853_, rotation1);
                                int l = expansion && nextbbox.m_71057_() <= 16 ? nextJigsawBlocks.stream().mapToInt(blockInfo -> {
                                    if (!nextbbox.m_71051_((Vec3i)blockInfo.f_74675_.m_121945_(JigsawBlock.m_54250_((BlockState)blockInfo.f_74676_)))) {
                                        return 0;
                                    }
                                    ResourceLocation pool2 = new ResourceLocation(blockInfo.f_74677_.m_128461_("pool"));
                                    Optional optional2 = this.pools.m_6612_(pool2);
                                    Optional<Integer> optional3 = optional2.flatMap(pool -> this.pools.m_6612_(pool.m_210573_()));
                                    int j3 = optional2.map(pool -> pool.m_227357_(this.structureTemplateManager)).orElse(0);
                                    int k3 = optional3.map(pool -> pool.m_227357_(this.structureTemplateManager)).orElse(0);
                                    return Math.max(j3, k3);
                                }).max().orElse(0) : 0;
                                for (StructureTemplate.StructureBlockInfo nextJigsawInfo : nextJigsawBlocks) {
                                    int l2;
                                    int l1;
                                    if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)jigsawInfo, (StructureTemplate.StructureBlockInfo)nextJigsawInfo)) continue;
                                    BlockPos blockpos3 = nextJigsawInfo.f_74675_;
                                    BlockPos blockpos4 = blockpos2.m_121996_((Vec3i)blockpos3);
                                    BoundingBox boundingbox2 = nextElement.m_214015_(this.structureTemplateManager, blockpos4, rotation1);
                                    int i1 = boundingbox2.m_162396_();
                                    StructureTemplatePool.Projection nextProjection = nextElement.m_210539_();
                                    boolean flag2 = nextProjection == StructureTemplatePool.Projection.RIGID;
                                    int j1 = blockpos3.m_123342_();
                                    int k1 = j - j1 + JigsawBlock.m_54250_((BlockState)jigsawInfo.f_74676_).m_122430_();
                                    if (flag && flag2) {
                                        l1 = i + k1;
                                    } else {
                                        if (k == -1) {
                                            k = this.chunkGenerator.m_223221_(blockpos1.m_123341_(), blockpos1.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, level, random);
                                        }
                                        l1 = k - j1;
                                    }
                                    int i2 = l1 - i1;
                                    BoundingBox boundingbox3 = boundingbox2.m_71045_(0, i2, 0);
                                    BlockPos blockpos5 = blockpos4.m_7918_(0, i2, 0);
                                    if (l > 0) {
                                        int j2 = Math.max(l + 1, boundingbox3.m_162400_() - boundingbox3.m_162396_());
                                        boundingbox3.m_162371_(new BlockPos(boundingbox3.m_162395_(), boundingbox3.m_162396_() + j2, boundingbox3.m_162398_()));
                                    }
                                    if (Shapes.m_83157_((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox3).m_82406_(0.25)), (BooleanOp)BooleanOp.f_82683_)) continue;
                                    mutableobject1.setValue((Object)Shapes.m_83148_((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox3)), (BooleanOp)BooleanOp.f_82685_));
                                    int i3 = piece.m_72647_();
                                    int k2 = flag2 ? i3 - k1 : nextElement.m_210540_();
                                    PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(this.structureTemplateManager, nextElement, blockpos5, k2, rotation1, boundingbox3);
                                    if (flag) {
                                        l2 = i + j;
                                    } else if (flag2) {
                                        l2 = l1 + j1;
                                    } else {
                                        if (k == -1) {
                                            k = this.chunkGenerator.m_223221_(blockpos1.m_123341_(), blockpos1.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, level, random);
                                        }
                                        l2 = k + k1 / 2;
                                    }
                                    piece.m_209916_(new JigsawJunction(blockpos2.m_123341_(), l2 - j + i3, blockpos2.m_123343_(), k1, nextProjection));
                                    poolelementstructurepiece.m_209916_(new JigsawJunction(blockpos1.m_123341_(), l2 - j1 + k2, blockpos1.m_123343_(), -k1, projection));
                                    this.pieces.add((PoolElementStructurePiece)poolelementstructurepiece);
                                    if (depth + 1 > this.maxDepth) continue block0;
                                    this.placing.addLast(new PieceState(poolelementstructurepiece, mutableobject1, depth + 1));
                                    continue block0;
                                }
                            }
                        }
                        continue;
                    }
                    OWLogger.LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)resourcelocation1);
                    continue;
                }
                OWLogger.LOGGER.warn("Empty or non-existent pool: {}", (Object)pool1);
            }
        }
    }

    static final class PieceState {
        final PoolElementStructurePiece piece;
        final MutableObject<VoxelShape> free;
        final int depth;

        PieceState(PoolElementStructurePiece piece, MutableObject<VoxelShape> shape, int depth) {
            this.piece = piece;
            this.free = shape;
            this.depth = depth;
        }
    }
}

