/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.world.features;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class OceanStoneFeature
extends Feature<NoneFeatureConfiguration> {
    private final Block replaceBlock;
    private final BlockState targetBlockState;
    private static final int MAX_DEPTH = 10;

    public OceanStoneFeature(Block replaceBlock, BlockState targetBlockState, Codec<NoneFeatureConfiguration> codec) {
        super(codec);
        this.replaceBlock = replaceBlock;
        this.targetBlockState = targetBlockState;
    }

    private boolean tryPlace(WorldGenLevel level, Set<BlockPos> visited, BlockPos curPosition, RandomSource random, Predicate<BlockState> predicate, int depth, boolean toPlace) {
        for (int b = 1; b <= 6; ++b) {
            int s = (b & 4) >> 2;
            int b1 = (b & 3) + s;
            int y = b1 & 1 ^ (b1 & 2) >> 1 ^ 1;
            int x = b1 & 1 ^ y;
            int z = (b1 & 2) >> 1 ^ y;
            BlockPos blockpos1 = curPosition.m_7918_(x *= 1 - 2 * s, y *= 1 - 2 * s, z *= 1 - 2 * s);
            BlockState blockstate = level.m_8055_(blockpos1);
            if (blockstate.m_60713_(Blocks.f_49990_) || blockstate.m_60713_(Blocks.f_50016_) || blockstate.m_60713_(Blocks.f_50627_)) {
                return depth > 0;
            }
            if (depth >= 10) {
                return false;
            }
            if (visited.contains(blockpos1)) continue;
            visited.add(blockpos1);
            if (random.m_188503_(3) == 0 || !blockstate.m_60713_(this.replaceBlock) && !blockstate.m_60713_(Blocks.f_50069_) && !blockstate.m_60713_(Blocks.f_50334_) && !blockstate.m_60713_(Blocks.f_50228_) && !blockstate.m_60713_(Blocks.f_50122_)) continue;
            if (this.tryPlace(level, visited, blockpos1, random, predicate, depth + 1, toPlace)) {
                toPlace = true;
            }
            if (!toPlace) continue;
            this.m_159742_(level, blockpos1, this.targetBlockState, predicate);
        }
        return toPlace;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        Predicate predicate = Feature.m_204735_((TagKey)BlockTags.f_144287_);
        BlockPos blockpos = context.m_159777_();
        RandomSource random = context.m_225041_();
        WorldGenLevel worldgenlevel = context.m_159774_();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        return this.tryPlace(worldgenlevel, visited, blockpos, random, predicate, 0, false);
    }
}

