/*
 * Decompiled with CFR 0.152.
 */
package pixelgamewizard.pgwbandedtorches.common;

import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.particles.IParticleData;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import pixelgamewizard.pgwbandedtorches.common.Constants;
import pixelgamewizard.pgwbandedtorches.common.ModBlocks;

public class RegistrationHandler {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"pgwbandedtorches");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"pgwbandedtorches");

    public static void init() {
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    static {
        for (int torchPropertiesIndex = 0; torchPropertiesIndex < Constants.TORCH_PROPERTIES_ARRAY.length; ++torchPropertiesIndex) {
            Constants.TorchProperties torchProperties = Constants.TORCH_PROPERTIES_ARRAY[torchPropertiesIndex];
            for (int colourIndex = 0; colourIndex < Constants.COLOUR_ARRAY.length; ++colourIndex) {
                String bandedTorchName = "banded_" + torchProperties.name + "_" + Constants.COLOUR_ARRAY[colourIndex];
                String bandedTorchWallName = bandedTorchName + "_wall";
                RegistryObject blockRegistryObject = BLOCKS.register(bandedTorchName, () -> new TorchBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200946_b().func_235838_a_(BlockState2 -> torchProperties.lightLevel).func_200947_a(SoundType.field_185848_a), (IParticleData)torchProperties.particleType));
                RegistryObject wallBlockRegistryObject = BLOCKS.register(bandedTorchWallName, () -> new WallTorchBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200946_b().func_235838_a_(BlockState2 -> torchProperties.lightLevel).func_200947_a(SoundType.field_185848_a).lootFrom((Supplier)blockRegistryObject), (IParticleData)torchProperties.particleType));
                RegistryObject itemRegistryObject = ITEMS.register(bandedTorchName, () -> new WallOrFloorItem((Block)blockRegistryObject.get(), (Block)wallBlockRegistryObject.get(), new Item.Properties().func_200916_a(ItemGroup.field_78031_c)));
                int torchIndex = ModBlocks.CalculateTorchIndex(torchPropertiesIndex, colourIndex);
                ModBlocks.torches[torchIndex] = new ModBlocks.TorchBlockRegistryObjects();
                ModBlocks.torches[torchIndex].block = blockRegistryObject;
                ModBlocks.torches[torchIndex].wallBlock = wallBlockRegistryObject;
                ModBlocks.torches[torchIndex].item = itemRegistryObject;
            }
        }
    }
}

