/*
 * Decompiled with CFR 0.152.
 */
package pixelgamewizard.pgwbandedtorches.common;

import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pixelgamewizard.pgwbandedtorches.common.Constants;

public class ModBlocks {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final TorchBlockRegistryObjects[] torches = new TorchBlockRegistryObjects[Constants.TORCH_COUNT];

    public static int CalculateTorchIndex(int torchPropertiesIndex, int colourIndex) {
        if (torchPropertiesIndex < 0 || torchPropertiesIndex >= Constants.TORCH_PROPERTIES_ARRAY.length) {
            LOGGER.error("Torch Properties index " + torchPropertiesIndex + " is out of bounds. Count is " + Constants.TORCH_PROPERTIES_ARRAY.length + ". Continuing world load is *NOT* recommended. This is a bug in the Banded Torches mod, please report it on the project's GitHub page at: https://github.com/pixelgamewizard/pgwbandedtorches/issues");
            return -1;
        }
        if (colourIndex < 0 || colourIndex >= Constants.COLOUR_ARRAY.length) {
            LOGGER.error("Colour index " + torchPropertiesIndex + " is out of bounds. Count is " + Constants.COLOUR_ARRAY.length + ". Continuing world load is *NOT* recommended. This is a bug in the Banded Torches mod, please report it on the project's GitHub page at: https://github.com/pixelgamewizard/pgwbandedtorches/issues");
            return -1;
        }
        return torchPropertiesIndex * Constants.COLOUR_ARRAY.length + colourIndex;
    }

    static class TorchBlockRegistryObjects {
        public RegistryObject<Block> block;
        public RegistryObject<Block> wallBlock;
        public RegistryObject<Item> item;

        TorchBlockRegistryObjects() {
        }
    }
}

