/*
 * Decompiled with CFR 0.152.
 */
package pixelgamewizard.pgwbandedtorches.common;

import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import pixelgamewizard.pgwbandedtorches.common.Constants;
import pixelgamewizard.pgwbandedtorches.common.ModBlocks;

public class RegistrationHandler {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"pgwbandedtorches");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"pgwbandedtorches");

    public static void init() {
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    static {
        for (int torchPropertiesIndex = 0; torchPropertiesIndex < Constants.TORCH_PROPERTIES_ARRAY.length; ++torchPropertiesIndex) {
            Constants.TorchProperties torchProperties = Constants.TORCH_PROPERTIES_ARRAY[torchPropertiesIndex];
            for (int colourIndex = 0; colourIndex < Constants.COLOUR_ARRAY.length; ++colourIndex) {
                String bandedTorchName = "banded_" + torchProperties.name + "_" + Constants.COLOUR_ARRAY[colourIndex];
                String bandedTorchWallName = bandedTorchName + "_wall";
                RegistryObject blockRegistryObject = BLOCKS.register(bandedTorchName, () -> new TorchBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_().m_60953_(BlockState2 -> torchProperties.lightLevel).m_60918_(SoundType.f_56736_), (ParticleOptions)torchProperties.particleType));
                RegistryObject wallBlockRegistryObject = BLOCKS.register(bandedTorchWallName, () -> new WallTorchBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_().m_60953_(BlockState2 -> torchProperties.lightLevel).m_60918_(SoundType.f_56736_).lootFrom((Supplier)blockRegistryObject), (ParticleOptions)torchProperties.particleType));
                RegistryObject itemRegistryObject = ITEMS.register(bandedTorchName, () -> new StandingAndWallBlockItem((Block)blockRegistryObject.get(), (Block)wallBlockRegistryObject.get(), new Item.Properties(), Direction.DOWN));
                int torchIndex = ModBlocks.CalculateTorchIndex(torchPropertiesIndex, colourIndex);
                ModBlocks.torches[torchIndex] = new ModBlocks.TorchBlockRegistryObjects();
                ModBlocks.torches[torchIndex].block = blockRegistryObject;
                ModBlocks.torches[torchIndex].wallBlock = wallBlockRegistryObject;
                ModBlocks.torches[torchIndex].item = itemRegistryObject;
            }
        }
    }
}

