/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import se.gory_moon.player_mobs.LangKeys;
import se.gory_moon.player_mobs.entity.EntityRegistry;
import se.gory_moon.player_mobs.entity.PlayerMobEntity;
import se.gory_moon.player_mobs.utils.NameManager;

public class PlayerMobsCommand {
    private static final SimpleCommandExceptionType SUMMON_FAILED = new SimpleCommandExceptionType((Message)new TranslationTextComponent(LangKeys.COMMANDS_SPAWN_FAILED.key()));
    private static final SimpleCommandExceptionType DUPLICATE_UUID = new SimpleCommandExceptionType((Message)new TranslationTextComponent(LangKeys.COMMANDS_SPAWN_UUID.key()));
    private static final SimpleCommandExceptionType INVALID_POS = new SimpleCommandExceptionType((Message)new TranslationTextComponent(LangKeys.COMMANDS_SPAWN_INVALID_POS.key()));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"playermobs").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197057_a((String)"reload").executes(context -> {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(LangKeys.COMMANDS_RELOAD_START.key()), true);
            NameManager.INSTANCE.reloadRemoteLinks().thenAccept(change -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(LangKeys.COMMANDS_RELOAD_DONE.key(), new Object[]{change}), true));
            return 1;
        }))).then(Commands.func_197057_a((String)"spawn").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"username", (ArgumentType)StringArgumentType.word()).executes(context -> PlayerMobsCommand.spawnPlayerMob((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"username"), ((CommandSource)context.getSource()).func_197036_d()))).then(Commands.func_197056_a((String)"pos", (ArgumentType)Vec3Argument.func_197301_a()).executes(context -> PlayerMobsCommand.spawnPlayerMob((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"username"), Vec3Argument.func_197300_a((CommandContext)context, (String)"pos")))))));
    }

    private static int spawnPlayerMob(CommandSource source, String username, Vector3d pos) throws CommandSyntaxException {
        BlockPos blockpos = new BlockPos(pos);
        if (!World.func_234935_k_((BlockPos)blockpos)) {
            throw INVALID_POS.create();
        }
        PlayerMobEntity entity = EntityRegistry.PLAYER_MOB_ENTITY.create((World)source.func_197023_e());
        if (entity == null) {
            throw SUMMON_FAILED.create();
        }
        entity.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, entity.field_70177_z, entity.field_70125_A);
        entity.func_213386_a((IServerWorld)source.func_197023_e(), source.func_197023_e().func_175649_E(entity.func_233580_cy_()), SpawnReason.COMMAND, null, null);
        entity.setUsername(username);
        if (!source.func_197023_e().func_242106_g((Entity)entity)) {
            throw DUPLICATE_UUID.create();
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent(LangKeys.COMMANDS_SPAWN_SUCCESS.key(), new Object[]{entity.func_145748_c_()}), true);
        return 1;
    }
}

