/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import se.gory_moon.player_mobs.client.render.PlayerMobCapeLayer;
import se.gory_moon.player_mobs.client.render.PlayerMobDeadmau5HeadLayer;
import se.gory_moon.player_mobs.entity.PlayerMobEntity;
import se.gory_moon.player_mobs.utils.TextureUtils;

public class PlayerMobRenderer
extends BipedRenderer<PlayerMobEntity, PlayerModel<PlayerMobEntity>> {
    private static final PlayerModel<PlayerMobEntity> STEVE = new PlayerModel(0.0f, false);
    private static final PlayerModel<PlayerMobEntity> ALEX = new PlayerModel(0.0f, true);

    public PlayerMobRenderer(EntityRendererManager renderManager) {
        super(renderManager, STEVE, 0.5f);
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
        this.func_177094_a((LayerRenderer)new ArrowLayer((LivingRenderer)this));
        this.func_177094_a(new PlayerMobDeadmau5HeadLayer((IEntityRenderer<PlayerMobEntity, PlayerModel<PlayerMobEntity>>)this));
        this.func_177094_a(new PlayerMobCapeLayer((IEntityRenderer<PlayerMobEntity, PlayerModel<PlayerMobEntity>>)this));
    }

    public void render(PlayerMobEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLightIn) {
        this.field_77045_g = TextureUtils.getPlayerSkinType(entity.getProfile()) == TextureUtils.SkinType.SLIM ? ALEX : STEVE;
        ((PlayerModel)this.field_77045_g).field_187075_l = BipedModel.ArmPose.EMPTY;
        ((PlayerModel)this.field_77045_g).field_187076_m = BipedModel.ArmPose.EMPTY;
        ItemStack stack = entity.func_184614_ca();
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof BowItem && entity.func_213398_dR()) {
                this.setHandPose(entity, BipedModel.ArmPose.BOW_AND_ARROW);
            } else {
                this.setHandPose(entity, BipedModel.ArmPose.ITEM);
            }
        }
        super.func_225623_a_((MobEntity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLightIn);
    }

    private void setHandPose(PlayerMobEntity entity, BipedModel.ArmPose pose) {
        if (entity.func_184591_cq() == HandSide.RIGHT) {
            ((PlayerModel)this.field_77045_g).field_187076_m = pose;
        } else {
            ((PlayerModel)this.field_77045_g).field_187075_l = pose;
        }
    }

    protected void scale(PlayerMobEntity entity, MatrixStack matrix, float partialTickTime) {
        matrix.func_227862_a_(0.9375f, 0.9375f, 0.9375f);
    }

    public ResourceLocation getTextureLocation(PlayerMobEntity entity) {
        return TextureUtils.getPlayerSkin(entity);
    }
}

