/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.BreakDoorGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import se.gory_moon.player_mobs.Configs;
import se.gory_moon.player_mobs.entity.EntityRegistry;
import se.gory_moon.player_mobs.sound.SoundRegistry;
import se.gory_moon.player_mobs.utils.ItemManager;
import se.gory_moon.player_mobs.utils.NameManager;
import se.gory_moon.player_mobs.utils.PlayerName;
import se.gory_moon.player_mobs.utils.ProfileUpdater;

public class PlayerMobEntity
extends MonsterEntity
implements IRangedAttackMob {
    private GameProfile profile;
    private ResourceLocation skin;
    private ResourceLocation cape;
    private boolean skinAvailable;
    private boolean capeAvailable;
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;
    private static final UUID BABY_SPEED_BOOST_ID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier BABY_SPEED_BOOST = new AttributeModifier(BABY_SPEED_BOOST_ID, "Baby speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(PlayerMobEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> NAME = EntityDataManager.func_187226_a(PlayerMobEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private boolean canBreakDoor;
    private final BreakDoorGoal breakDoor = new BreakDoorGoal((MobEntity)this, difficulty -> difficulty == Difficulty.HARD);
    private final RangedBowAttackGoal<PlayerMobEntity> aiArrowAttack = new RangedBowAttackGoal((MonsterEntity)this, 1.0, 20, 15.0f);

    public PlayerMobEntity(World worldIn) {
        this((EntityType<? extends MonsterEntity>)((EntityType)EntityRegistry.PLAYER_MOB_ENTITY.get()), worldIn);
    }

    public PlayerMobEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.setCombatTask();
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233819_b_, 35.0).func_233814_a_(Attributes.field_233824_g_).func_233815_a_(Attributes.field_233823_f_, 3.5).func_233815_a_(Attributes.field_233821_d_, 0.24);
    }

    private boolean targetTwin(LivingEntity livingEntity) {
        return (Boolean)Configs.COMMON.attackTwin.get() != false || !(livingEntity instanceof PlayerEntity) || !livingEntity.func_200200_C_().getString().equals(this.getUsername().getDisplayName());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        if (((Boolean)Configs.COMMON.openDoors.get()).booleanValue() && this.field_70170_p.func_175659_aa() == Configs.COMMON.openDoorsDifficulty.get()) {
            this.field_70714_bg.func_75776_a(1, (Goal)new OpenDoorGoal((MobEntity)this, true));
        }
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{ZombifiedPiglinEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, this::targetTwin));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(NAME, (Object)"");
        this.func_184212_Q().func_187214_a(IS_CHILD, (Object)false);
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof CreatureEntity) {
            CreatureEntity creatureentity = (CreatureEntity)this.func_184187_bx();
            this.field_70761_aq = creatureentity.field_70761_aq;
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        int i;
        super.func_180481_a(difficulty);
        float f = this.field_70146_Z.nextFloat();
        float f2 = difficulty.func_203095_a() == Difficulty.HARD ? 0.1f : 0.5f;
        if (f < f2 && (i = this.field_70146_Z.nextInt(3)) <= 1) {
            ItemStack stack = ItemManager.INSTANCE.getRandomMainHand(this.field_70146_Z);
            this.func_184201_a(EquipmentSlotType.MAINHAND, stack);
            if (this.field_70146_Z.nextFloat() > 0.5f) {
                if (stack.func_77973_b() instanceof ShootableItem) {
                    ArrayList potions = new ArrayList(ForgeRegistries.POTION_TYPES.getKeys());
                    Potion potion = (Potion)ForgeRegistries.POTION_TYPES.getValue((ResourceLocation)potions.get(this.field_70146_Z.nextInt(potions.size())));
                    this.func_184201_a(EquipmentSlotType.OFFHAND, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185167_i), (Potion)potion));
                } else if (difficulty.func_203095_a() == Difficulty.HARD) {
                    this.func_184201_a(EquipmentSlotType.OFFHAND, ItemManager.INSTANCE.getRandomOffHand(this.field_70146_Z));
                    this.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier("Shield Bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
                }
            }
        }
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K) {
            this.setCombatTask();
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (IS_CHILD.equals(key)) {
            this.func_213323_x_();
        }
        super.func_184206_a(key);
    }

    protected int func_70693_a(PlayerEntity player) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = (int)((float)this.field_70728_aV * 2.5f);
        }
        return super.func_70693_a(player);
    }

    public float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 0.93f : 1.62f;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public boolean func_184613_cA() {
        return false;
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.45;
    }

    public boolean func_175448_a(ItemStack stack) {
        return (stack.func_77973_b() != Items.field_151110_aK || !this.func_70631_g_() || !this.func_184218_aH()) && super.func_175448_a(stack);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.xCloakO = this.xCloak;
        this.yCloakO = this.yCloak;
        this.zCloakO = this.zCloak;
        double x = this.func_226277_ct_() - this.xCloak;
        double y = this.func_226278_cu_() - this.yCloak;
        double z = this.func_226281_cx_() - this.zCloak;
        double maxCapeAngle = 10.0;
        if (x > maxCapeAngle) {
            this.xCloakO = this.xCloak = this.func_226277_ct_();
        }
        if (z > maxCapeAngle) {
            this.zCloakO = this.zCloak = this.func_226281_cx_();
        }
        if (y > maxCapeAngle) {
            this.yCloakO = this.yCloak = this.func_226278_cu_();
        }
        if (x < -maxCapeAngle) {
            this.xCloakO = this.xCloak = this.func_226277_ct_();
        }
        if (z < -maxCapeAngle) {
            this.zCloakO = this.zCloak = this.func_226281_cx_();
        }
        if (y < -maxCapeAngle) {
            this.yCloakO = this.yCloak = this.func_226278_cu_();
        }
        this.xCloak += x * 0.25;
        this.zCloak += z * 0.25;
        this.yCloak += y * 0.25;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean result = super.func_70652_k(entityIn);
        if (result) {
            this.func_184609_a(Hand.MAIN_HAND);
        }
        return result;
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_CHILD);
    }

    public void func_82227_f(boolean isChild) {
        super.func_82227_f(isChild);
        this.func_184212_Q().func_187227_b(IS_CHILD, (Object)isChild);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            ModifiableAttributeInstance attribute = this.func_110148_a(Attributes.field_233821_d_);
            attribute.func_111124_b(BABY_SPEED_BOOST);
            if (isChild) {
                attribute.func_233767_b_(BABY_SPEED_BOOST);
            }
        }
    }

    protected void func_213406_a(PlayerEntity player, MobEntity child) {
        if (child instanceof PlayerMobEntity) {
            ((PlayerMobEntity)child).setUsername(this.getUsername());
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        this.setUsername(NameManager.INSTANCE.getRandomName());
        this.setCombatTask();
        float additionalDifficulty = difficulty.func_180170_c();
        this.func_98053_h((double)this.field_70146_Z.nextFloat() < (Double)Configs.COMMON.pickupItemsChance.get() * (double)additionalDifficulty);
        double rangeBonus = this.field_70146_Z.nextDouble() * 1.5 * (double)additionalDifficulty;
        if (rangeBonus > 1.0) {
            this.func_110148_a(Attributes.field_233819_b_).func_233769_c_(new AttributeModifier("Range Bonus", rangeBonus, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.field_70146_Z.nextFloat() < additionalDifficulty * 0.05f) {
            this.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier("Health Bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.field_70146_Z.nextFloat() < additionalDifficulty * 0.15f) {
            this.func_110148_a(Attributes.field_233823_f_).func_233769_c_(new AttributeModifier("Damage Bonus", this.field_70146_Z.nextDouble() + 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.field_70146_Z.nextFloat() < additionalDifficulty * 0.2f) {
            this.func_110148_a(Attributes.field_233821_d_).func_233769_c_(new AttributeModifier("Speed Bonus", this.field_70146_Z.nextDouble() * 2.0 * 0.24 + 0.01, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.field_70146_Z.nextDouble() < (Double)Configs.COMMON.babySpawnChance.get()) {
            this.func_82227_f(true);
        }
        if (this.field_70146_Z.nextFloat() < additionalDifficulty * 0.1f) {
            this.setBreakDoorsAItask(true);
        }
        return spawnData;
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a(this.aiArrowAttack);
            ItemStack itemstack = this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f));
            if (itemstack.func_77973_b() instanceof BowItem) {
                this.aiArrowAttack.func_189428_b(this.field_70170_p.func_175659_aa() != Difficulty.HARD ? 20 : 40);
                this.field_70714_bg.func_75776_a(2, this.aiArrowAttack);
            }
        }
    }

    public void setBreakDoorsAItask(boolean enabled) {
        this.canBreakDoor = enabled;
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(enabled);
        if (enabled) {
            this.field_70714_bg.func_75776_a(1, (Goal)this.breakDoor);
        } else {
            this.field_70714_bg.func_85156_a((Goal)this.breakDoor);
        }
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f)));
        AbstractArrowEntity abstractarrowentity = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(abstractarrowentity);
        }
        double x = target.func_226277_ct_() - this.func_226277_ct_();
        double y = target.func_226283_e_(0.3333333333333333) - abstractarrowentity.func_226278_cu_();
        double z = target.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(x * x + z * z));
        abstractarrowentity.func_70186_c(x, y + d3 * (double)0.2f, z, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        String username = this.getUsername().getCombinedNames();
        if (!StringUtils.func_151246_b((String)username)) {
            compound.func_74778_a("Username", username);
        }
        compound.func_74757_a("CanBreakDoors", this.canBreakDoor);
        compound.func_74757_a("IsBaby", this.func_70631_g_());
        if (this.profile != null && this.profile.isComplete()) {
            compound.func_218657_a("Profile", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)this.profile));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        PlayerName playerName;
        super.func_70037_a(compound);
        String username = compound.func_74779_i("Username");
        if (!StringUtils.func_151246_b((String)username)) {
            playerName = new PlayerName(username);
            NameManager.INSTANCE.useName(playerName);
        } else {
            playerName = NameManager.INSTANCE.getRandomName();
        }
        this.setUsername(playerName);
        this.func_82227_f(compound.func_74767_n("IsBaby"));
        this.setBreakDoorsAItask(compound.func_74767_n("CanBreakDoors"));
        if (compound.func_150297_b("Profile", 10)) {
            this.profile = NBTUtil.func_152459_a((CompoundNBT)compound.func_74775_l("Profile"));
        }
        this.setCombatTask();
    }

    public ITextComponent func_200200_C_() {
        ITextComponent customName = this.func_200201_e();
        return customName != null ? customName : new StringTextComponent(this.getUsername().getDisplayName());
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    public boolean func_145818_k_() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.PLAYER_MOB_LIVING.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundRegistry.PLAYER_MOB_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.PLAYER_MOB_DEATH.get();
    }

    public GameProfile getProfile() {
        if (this.profile == null && this.getUsername() != null && !this.getUsername().getSkinName().isEmpty()) {
            this.profile = new GameProfile(null, this.getUsername().getSkinName());
            ProfileUpdater.updateProfile(this);
        }
        return this.profile;
    }

    public void setProfile(@Nullable GameProfile profile) {
        this.profile = profile;
    }

    public PlayerName getUsername() {
        return new PlayerName((String)this.func_184212_Q().func_187225_a(NAME));
    }

    public void setUsername(String name) {
        this.setUsername(new PlayerName(name));
    }

    public void setUsername(PlayerName name) {
        PlayerName oldName = this.getUsername();
        this.func_184212_Q().func_187227_b(NAME, (Object)name.getCombinedNames());
        this.func_200203_b((ITextComponent)new StringTextComponent(name.getDisplayName()));
        if ("Herobrine".equals(name.getDisplayName())) {
            this.func_110148_a(Attributes.field_233823_f_).func_233769_c_(new AttributeModifier("Herobrine Damage Bonus", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            this.func_110148_a(Attributes.field_233821_d_).func_233769_c_(new AttributeModifier("Herobrine Speed Bonus", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (!Objects.equals(oldName, name)) {
            this.setProfile(null);
            this.getProfile();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public SkinManager.ISkinAvailableCallback getSkinCallback() {
        return (type, location, profileTexture) -> {
            switch (type) {
                case SKIN: {
                    this.skin = location;
                    this.skinAvailable = true;
                    break;
                }
                case CAPE: {
                    this.cape = location;
                    this.capeAvailable = true;
                }
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isTextureAvailable(MinecraftProfileTexture.Type type) {
        switch (type) {
            case SKIN: {
                return this.skinAvailable;
            }
        }
        return this.capeAvailable;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture(MinecraftProfileTexture.Type type) {
        switch (type) {
            case SKIN: {
                return this.skin;
            }
        }
        return this.cape;
    }
}

