/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.repack.registrate.builders;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import se.gory_moon.player_mobs.repack.registrate.AbstractRegistrate;
import se.gory_moon.player_mobs.repack.registrate.builders.AbstractBuilder;
import se.gory_moon.player_mobs.repack.registrate.builders.BuilderCallback;
import se.gory_moon.player_mobs.repack.registrate.util.OneTimeEventReceiver;
import se.gory_moon.player_mobs.repack.registrate.util.entry.RegistryEntry;
import se.gory_moon.player_mobs.repack.registrate.util.entry.TileEntityEntry;
import se.gory_moon.player_mobs.repack.registrate.util.nullness.NonNullFunction;
import se.gory_moon.player_mobs.repack.registrate.util.nullness.NonNullSupplier;

public class TileEntityBuilder<T extends TileEntity, P>
extends AbstractBuilder<TileEntityType<?>, TileEntityType<T>, P, TileEntityBuilder<T, P>> {
    private final NonNullFunction<TileEntityType<T>, ? extends T> factory;
    private final Set<NonNullSupplier<? extends Block>> validBlocks = new HashSet<NonNullSupplier<? extends Block>>();
    @Nullable
    private NonNullSupplier<Function<TileEntityRendererDispatcher, TileEntityRenderer<? super T>>> renderer;

    public static <T extends TileEntity, P> TileEntityBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<TileEntityType<T>, ? extends T> factory) {
        return new TileEntityBuilder<T, P>(owner, parent, name, callback, factory);
    }

    protected TileEntityBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<TileEntityType<T>, ? extends T> factory) {
        super(owner, parent, name, callback, TileEntityType.class);
        this.factory = factory;
    }

    public TileEntityBuilder<T, P> validBlock(NonNullSupplier<? extends Block> block) {
        this.validBlocks.add(block);
        return this;
    }

    @SafeVarargs
    public final TileEntityBuilder<T, P> validBlocks(NonNullSupplier<? extends Block> ... blocks) {
        Arrays.stream(blocks).forEach(this::validBlock);
        return this;
    }

    public TileEntityBuilder<T, P> renderer(NonNullSupplier<Function<TileEntityRendererDispatcher, TileEntityRenderer<? super T>>> renderer) {
        if (this.renderer == null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::registerRenderer);
        }
        this.renderer = renderer;
        return this;
    }

    protected void registerRenderer() {
        OneTimeEventReceiver.addModListener(FMLClientSetupEvent.class, $ -> {
            NonNullSupplier<Function<TileEntityRendererDispatcher, TileEntityRenderer<T>>> renderer = this.renderer;
            if (renderer != null) {
                ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)this.getEntry()), renderer.get());
            }
        });
    }

    @Override
    protected TileEntityType<T> createEntry() {
        NonNullFunction factory = this.factory;
        NonNullSupplier supplier = this.asSupplier();
        return TileEntityType.Builder.func_223042_a(() -> (TileEntity)factory.apply((TileEntityType)supplier.get()), (Block[])((Block[])this.validBlocks.stream().map(NonNullSupplier::get).toArray(Block[]::new))).func_206865_a(null);
    }

    @Override
    protected RegistryEntry<TileEntityType<T>> createEntryWrapper(RegistryObject<TileEntityType<T>> delegate) {
        return new TileEntityEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public TileEntityEntry<T> register() {
        return (TileEntityEntry)super.register();
    }
}

