/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.utils;

import com.mojang.authlib.GameProfile;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameRules;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.gory_moon.player_mobs.Configs;
import se.gory_moon.player_mobs.entity.PlayerMobEntity;

@Mod.EventBusSubscriber(modid="player_mobs")
public class DeathHandler {
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        ItemStack stack;
        int looting;
        ItemStack drop;
        Entity trueSource;
        DamageSource source;
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity && entity.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223600_c) && (source = event.getSource()) instanceof EntityDamageSource && (trueSource = source.func_76346_g()) instanceof PlayerEntity && !(drop = DeathHandler.getDrop(entity, source, looting = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)(stack = ((PlayerEntity)trueSource).func_184607_cu())))).func_190926_b()) {
            ((PlayerEntity)entity).func_71019_a(drop, true);
        }
    }

    @SubscribeEvent
    public static void onLivingDrop(LivingDropsEvent event) {
        ItemStack drop;
        LivingEntity entity = event.getEntityLiving();
        if ((entity instanceof PlayerEntity || entity instanceof PlayerMobEntity) && !(drop = DeathHandler.getDrop(entity, event.getSource(), event.getLootingLevel())).func_190926_b()) {
            event.getDrops().add(new ItemEntity(entity.func_130014_f_(), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), drop));
        }
    }

    private static ItemStack getDrop(LivingEntity entity, DamageSource source, int looting) {
        double baseChance;
        if (entity.func_130014_f_().func_201670_d() || entity.func_110143_aJ() > 0.0f) {
            return ItemStack.field_190927_a;
        }
        if (entity.func_70631_g_()) {
            return ItemStack.field_190927_a;
        }
        double d = baseChance = entity instanceof PlayerMobEntity ? ((Double)Configs.COMMON.mobHeadDropChance.get()).doubleValue() : ((Double)Configs.COMMON.playerHeadDropChance.get()).doubleValue();
        if (baseChance <= 0.0) {
            return ItemStack.field_190927_a;
        }
        if (DeathHandler.poweredCreeper(source) || DeathHandler.randomDrop(entity.func_130014_f_().func_201674_k(), baseChance, looting)) {
            String displayName;
            PlayerMobEntity pmentity;
            String skinName;
            GameProfile gameprofile;
            ItemStack stack = new ItemStack((IItemProvider)Items.field_196184_dx);
            GameProfile gameProfile = gameprofile = entity instanceof PlayerMobEntity ? ((PlayerMobEntity)entity).getProfile() : ((PlayerEntity)entity).func_146103_bH();
            if (entity instanceof PlayerMobEntity && !(skinName = (pmentity = (PlayerMobEntity)entity).getUsername().getSkinName()).equals(displayName = pmentity.getUsername().getDisplayName())) {
                stack.func_200302_a((ITextComponent)new StringTextComponent(displayName + "'s Head"));
            }
            stack.func_196082_o().func_218657_a("SkullOwner", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)gameprofile));
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private static boolean poweredCreeper(DamageSource source) {
        Entity entity;
        if (source.func_94541_c() && source instanceof EntityDamageSource && (entity = source.func_76346_g()) instanceof CreeperEntity) {
            return ((CreeperEntity)entity).func_225509_J__();
        }
        return false;
    }

    private static boolean randomDrop(Random rand, double baseChance, int looting) {
        return rand.nextDouble() <= Math.max(0.0, baseChance * (double)Math.max(looting + 1, 1));
    }
}

