/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.utils;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.gory_moon.player_mobs.Configs;

public class ItemManager {
    public static final ItemManager INSTANCE = new ItemManager();
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<WeightedItem> weightedMainItems = new CopyOnWriteArrayList<WeightedItem>();
    private final List<WeightedItem> weightedOffItems = new CopyOnWriteArrayList<WeightedItem>();

    private ItemManager() {
    }

    public void configLoad() {
        this.weightedMainItems.clear();
        this.weightedOffItems.clear();
        this.weightedMainItems.addAll(this.parseItems(Configs.COMMON.mainItems));
        this.weightedOffItems.addAll(this.parseItems(Configs.COMMON.offhandItems));
    }

    private List<WeightedItem> parseItems(ForgeConfigSpec.ConfigValue<List<? extends String>> offhandItems) {
        return ((List)offhandItems.get()).stream().map(item -> {
            ResourceLocation location;
            String[] parts = item.split("-");
            int weight = 1;
            if (parts.length == 2) {
                try {
                    weight = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException e) {
                    LOGGER.error(String.format("Failed to parse item weight: %s", parts[1]), (Throwable)e);
                }
            }
            if ((location = ResourceLocation.func_208304_a((String)parts[0])) == null || !ForgeRegistries.ITEMS.containsKey(location)) {
                LOGGER.error(String.format("Failed to parse item id: %s", parts[0]));
                return null;
            }
            return new WeightedItem(location, weight);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public ItemStack getRandomMainHand(Random rand) {
        return this.getRandomItem(this.weightedMainItems, rand);
    }

    public ItemStack getRandomOffHand(Random rand) {
        return this.getRandomItem(this.weightedOffItems, rand);
    }

    private ItemStack getRandomItem(List<WeightedItem> items, Random rand) {
        if (items.size() <= 0) {
            return ItemStack.field_190927_a;
        }
        WeightedItem item = (WeightedItem)WeightedRandom.func_76271_a((Random)rand, items);
        return new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(item.id));
    }

    private static class WeightedItem
    extends WeightedRandom.Item {
        private final ResourceLocation id;

        public WeightedItem(ResourceLocation id, int itemWeightIn) {
            super(itemWeightIn);
            this.id = id;
        }
    }
}

