/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.utils;

import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.gory_moon.player_mobs.Configs;
import se.gory_moon.player_mobs.entity.EntityRegistry;
import se.gory_moon.player_mobs.entity.PlayerMobEntity;

@Mod.EventBusSubscriber(modid="player_mobs")
public class SpawnHandler {
    private static MobSpawnInfo.Spawners getPlayerMobSpawner() {
        return new MobSpawnInfo.Spawners((EntityType)EntityRegistry.PLAYER_MOB_ENTITY.get(), ((Integer)Configs.COMMON.spawnWeight.get()).intValue(), ((Integer)Configs.COMMON.spawnMinSize.get()).intValue(), ((Integer)Configs.COMMON.spawnMaxSize.get()).intValue());
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        List spawnersList = event.getSpawns().getSpawner(EntityClassification.MONSTER);
        boolean hasZombies = false;
        for (MobSpawnInfo.Spawners spawners : spawnersList) {
            if (spawners.field_242588_c != EntityType.field_200725_aD) continue;
            hasZombies = true;
            break;
        }
        if (hasZombies) {
            spawnersList.add(SpawnHandler.getPlayerMobSpawner());
        }
    }

    @SubscribeEvent
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntityLiving() instanceof PlayerMobEntity) {
            RegistryKey worldKey = World.field_234918_g_;
            if (event.getWorld() instanceof IServerWorld) {
                worldKey = ((IServerWorld)event.getWorld()).func_201672_e().func_234923_W_();
            } else if (event.getWorld() instanceof World) {
                worldKey = ((World)event.getWorld()).func_234923_W_();
            }
            if (Configs.COMMON.isDimensionBlocked((RegistryKey<World>)worldKey)) {
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

