/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.utils;

import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.util.ResourceLocation;
import se.gory_moon.player_mobs.entity.PlayerMobEntity;

public class TextureUtils {
    private static final ResourceLocation TEXTURE_STEVE = new ResourceLocation("textures/entity/steve.png");
    private static final ResourceLocation TEXTURE_ALEX = new ResourceLocation("textures/entity/alex.png");
    private static final Map<UUID, SkinType> SKIN_TYPE_CACHE = new Object2ObjectOpenHashMap();

    public static SkinType getPlayerSkinType(GameProfile profile) {
        SkinType type = SkinType.DEFAULT;
        if (profile != null && profile.isComplete()) {
            if (SKIN_TYPE_CACHE.containsKey(profile.getId())) {
                type = SKIN_TYPE_CACHE.get(profile.getId());
            } else {
                Minecraft mc = Minecraft.func_71410_x();
                Map map = mc.func_152342_ad().func_152788_a(profile);
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    String stringType = ((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN)).getMetadata("model");
                    type = TextureUtils.getType(stringType);
                    SKIN_TYPE_CACHE.put(profile.getId(), type);
                } else {
                    type = TextureUtils.getType(DefaultPlayerSkin.func_177332_b((UUID)profile.getId()));
                }
            }
        }
        return type;
    }

    private static SkinType getType(String stringType) {
        return "slim".equals(stringType) ? SkinType.SLIM : SkinType.DEFAULT;
    }

    public static ResourceLocation getPlayerSkin(PlayerMobEntity entity) {
        return TextureUtils.getTexture(entity, MinecraftProfileTexture.Type.SKIN);
    }

    public static ResourceLocation getPlayerCape(PlayerMobEntity entity) {
        return TextureUtils.getTexture(entity, MinecraftProfileTexture.Type.CAPE);
    }

    private static ResourceLocation getTexture(PlayerMobEntity entity, MinecraftProfileTexture.Type type) {
        Minecraft mc;
        Map map;
        if (entity.isTextureAvailable(type)) {
            return entity.getTexture(type);
        }
        GameProfile profile = entity.getProfile();
        if (profile != null && !profile.isComplete()) {
            return TextureUtils.getDefault(profile, type);
        }
        if (profile != null && profile.getName() != null && (map = (mc = Minecraft.func_71410_x()).func_152342_ad().func_152788_a(profile)).containsKey(type)) {
            MinecraftProfileTexture profileTexture = (MinecraftProfileTexture)map.get(type);
            String s = Hashing.sha1().hashUnencodedChars((CharSequence)profileTexture.getHash()).toString();
            ResourceLocation location = new ResourceLocation("skins/" + s);
            if (mc.field_71446_o.func_229267_b_(location) != null) {
                return location;
            }
            RenderSystem.recordRenderCall(() -> mc.func_152342_ad().func_152789_a(profileTexture, type, entity.getSkinCallback()));
        }
        return TextureUtils.getDefault(profile, type);
    }

    private static ResourceLocation getDefault(GameProfile profile, MinecraftProfileTexture.Type type) {
        if (type == MinecraftProfileTexture.Type.CAPE || type == MinecraftProfileTexture.Type.ELYTRA) {
            return null;
        }
        return TextureUtils.getPlayerSkinType(profile) == SkinType.SLIM ? TEXTURE_ALEX : TEXTURE_STEVE;
    }

    public static enum SkinType {
        DEFAULT,
        SLIM;

    }
}

